/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.PatternFilterableResourceTransformer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.tools.zip.ZipOutputStream;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.util.PatternSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@CacheableTransformer
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0019\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\u001cH\u0000\u00a2\u0006\u0002\b\u001dR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f8\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/PatternFilterableResourceTransformer;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "patternSet", "Lorg/gradle/api/tasks/util/PatternSet;", "<init>", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/tasks/util/PatternSet;)V", "(Lorg/gradle/api/model/ObjectFactory;)V", "getObjectFactory", "()Lorg/gradle/api/model/ObjectFactory;", "sources", "", "", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer$PathInfos;", "getSources$shadow", "()Ljava/util/Map;", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "hasTransformedResource", "modifyOutputStream", "", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "duplicateContentViolations", "", "duplicateContentViolations$shadow", "PathInfos", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nDeduplicatingResourceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeduplicatingResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,124:1\n216#2:125\n216#2:126\n217#2:129\n217#2:130\n1869#3,2:127\n536#4:131\n521#4,6:132\n*S KotlinDebug\n*F\n+ 1 DeduplicatingResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer\n*L\n86#1:125\n88#1:126\n88#1:129\n86#1:130\n89#1:127,2\n98#1:131\n98#1:132,6\n*E\n"})
public class DeduplicatingResourceTransformer
extends PatternFilterableResourceTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectFactory objectFactory;
    @NotNull
    private final Map<String, PathInfos> sources;

    public DeduplicatingResourceTransformer(@NotNull ObjectFactory objectFactory, @NotNull PatternSet patternSet) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        Intrinsics.checkNotNullParameter((Object)patternSet, (String)"patternSet");
        super(patternSet);
        this.objectFactory = objectFactory;
        this.sources = new LinkedHashMap();
    }

    @Override
    @NotNull
    public final ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Internal
    @NotNull
    public final Map<String, PathInfos> getSources$shadow() {
        return this.sources;
    }

    @Inject
    public DeduplicatingResourceTransformer(@NotNull ObjectFactory objectFactory) {
        Intrinsics.checkNotNullParameter((Object)objectFactory, (String)"objectFactory");
        this(objectFactory, new PatternSet());
    }

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        File file = element.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        File file2 = file;
        String hash = Companion.sha256Hex(file2);
        PathInfos pathInfos = this.sources.computeIfAbsent(element.getPath(), arg_0 -> DeduplicatingResourceTransformer.canTransformResource$lambda$1(arg_0 -> DeduplicatingResourceTransformer.canTransformResource$lambda$0(this, element, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)pathInfos, (String)"computeIfAbsent(...)");
        PathInfos pathInfos2 = pathInfos;
        boolean retainInOutput = pathInfos2.addFile(hash, file2);
        return !retainInOutput;
    }

    @Override
    public boolean hasTransformedResource() {
        return true;
    }

    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        Map<String, PathInfos> duplicatePaths = this.duplicateContentViolations$shadow();
        if (!duplicatePaths.isEmpty()) {
            StringBuilder stringBuilder;
            StringBuilder $this$modifyOutputStream_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            $this$modifyOutputStream_u24lambda_u240.append("Found " + duplicatePaths.size() + " path duplicate(s) with different content in the shadowed JAR:\n");
            Map<String, PathInfos> $this$forEach$iv = duplicatePaths;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, PathInfos>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, PathInfos> element$iv;
                Map.Entry<String, PathInfos> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String path = entry.getKey();
                PathInfos infos = entry.getValue();
                $this$modifyOutputStream_u24lambda_u240.append("  * " + path + "\n");
                Map<String, List<File>> $this$forEach$iv2 = infos.getFilesPerHash();
                boolean $i$f$forEach2 = false;
                Iterator<Map.Entry<String, List<File>>> iterator2 = $this$forEach$iv2.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, List<File>> element$iv2;
                    Map.Entry<String, List<File>> entry2 = element$iv2 = iterator2.next();
                    boolean bl3 = false;
                    String hash = entry2.getKey();
                    List<File> files = entry2.getValue();
                    Iterable $this$forEach$iv3 = files;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv3 : $this$forEach$iv3) {
                        File file = (File)element$iv3;
                        boolean bl4 = false;
                        $this$modifyOutputStream_u24lambda_u240.append("    * " + file.getPath() + " (SHA256: " + hash + ")\n");
                    }
                }
            }
            String message = stringBuilder.toString();
            throw new GradleException(message);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, PathInfos> duplicateContentViolations$shadow() {
        void $this$filterTo$iv$iv;
        Map<String, PathInfos> $this$filter$iv = this.sources;
        boolean $i$f$filter = false;
        Map<String, PathInfos> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = iterator.next();
            boolean bl = false;
            PathInfos pathInfos = (PathInfos)entry.getValue();
            if (!(pathInfos.getFailOnDuplicateContent() && pathInfos.uniqueContentCount() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    private static final PathInfos canTransformResource$lambda$0(DeduplicatingResourceTransformer this$0, FileTreeElement $element, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new PathInfos(this$0.getPatternSpec().isSatisfiedBy((Object)$element));
    }

    private static final PathInfos canTransformResource$lambda$1(Function1 $tmp0, Object p0) {
        return (PathInfos)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer$Companion;", "", "<init>", "()V", "sha256Hex", "", "Ljava/io/File;", "shadow"})
    @SourceDebugExtension(value={"SMAP\nDeduplicatingResourceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeduplicatingResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final String sha256Hex(@NotNull File $this$sha256Hex) {
            Intrinsics.checkNotNullParameter((Object)$this$sha256Hex, (String)"<this>");
            try {
                String string;
                Closeable closeable = new FileInputStream($this$sha256Hex);
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)closeable;
                    boolean bl = false;
                    String string2 = DigestUtils.sha256Hex((InputStream)it);
                    string = string2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"use(...)");
                return string;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read data or calculate hash for " + $this$sha256Hex, e);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\b\u0080\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\fJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0016\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0018\u001a\u00020\u0010H\u00d6\u0081\u0004J\n\u0010\u0019\u001a\u00020\nH\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R#\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer$PathInfos;", "", "failOnDuplicateContent", "", "<init>", "(Z)V", "getFailOnDuplicateContent", "()Z", "filesPerHash", "", "", "", "Ljava/io/File;", "getFilesPerHash", "()Ljava/util/Map;", "uniqueContentCount", "", "addFile", "hash", "file", "component1", "copy", "equals", "other", "hashCode", "toString", "shadow"})
    @SourceDebugExtension(value={"SMAP\nDeduplicatingResourceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeduplicatingResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer$PathInfos\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,124:1\n382#2,7:125\n*S KotlinDebug\n*F\n+ 1 DeduplicatingResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/DeduplicatingResourceTransformer$PathInfos\n*L\n109#1:125,7\n*E\n"})
    public static final class PathInfos {
        private final boolean failOnDuplicateContent;
        @NotNull
        private final Map<String, List<File>> filesPerHash;

        public PathInfos(boolean failOnDuplicateContent) {
            this.failOnDuplicateContent = failOnDuplicateContent;
            this.filesPerHash = new LinkedHashMap();
        }

        public final boolean getFailOnDuplicateContent() {
            return this.failOnDuplicateContent;
        }

        @NotNull
        public final Map<String, List<File>> getFilesPerHash() {
            return this.filesPerHash;
        }

        public final int uniqueContentCount() {
            return this.filesPerHash.size();
        }

        /*
         * WARNING - void declaration
         */
        public final boolean addFile(@NotNull String hash, @NotNull File file) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean bl = !this.filesPerHash.containsKey(hash);
            Map<String, List<File>> map = this.filesPerHash;
            String key$iv = hash;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(file);
            return bl;
        }

        public final boolean component1() {
            return this.failOnDuplicateContent;
        }

        @NotNull
        public final PathInfos copy(boolean failOnDuplicateContent) {
            return new PathInfos(failOnDuplicateContent);
        }

        public static /* synthetic */ PathInfos copy$default(PathInfos pathInfos, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = pathInfos.failOnDuplicateContent;
            }
            return pathInfos.copy(bl);
        }

        @NotNull
        public String toString() {
            return "PathInfos(failOnDuplicateContent=" + this.failOnDuplicateContent + ")";
        }

        public int hashCode() {
            return Boolean.hashCode(this.failOnDuplicateContent);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathInfos)) {
                return false;
            }
            PathInfos pathInfos = (PathInfos)other;
            return this.failOnDuplicateContent == pathInfos.failOnDuplicateContent;
        }
    }
}

