/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.transformers;

import com.github.jengelman.gradle.plugins.shadow.relocation.RelocationContextKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import com.github.jengelman.gradle.plugins.shadow.tasks.ShadowCopyAction;
import com.github.jengelman.gradle.plugins.shadow.transformers.CacheableTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.ResourceTransformer;
import com.github.jengelman.gradle.plugins.shadow.transformers.TransformerContext;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipOutputStream;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.Xpp3DomWriter;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.tasks.Internal;
import org.jetbrains.annotations.NotNull;

@CacheableTransformer
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8AX\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ComponentsXmlResourceTransformer;", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/ResourceTransformer;", "<init>", "()V", "components", "", "", "Lorg/codehaus/plexus/util/xml/Xpp3Dom;", "transformedResource", "", "getTransformedResource$shadow", "()[B", "canTransformResource", "", "element", "Lorg/gradle/api/file/FileTreeElement;", "transform", "", "context", "Lcom/github/jengelman/gradle/plugins/shadow/transformers/TransformerContext;", "modifyOutputStream", "os", "Lorg/apache/tools/zip/ZipOutputStream;", "preserveFileTimestamps", "hasTransformedResource", "Companion", "shadow"})
@SourceDebugExtension(value={"SMAP\nComponentsXmlResourceTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentsXmlResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/ComponentsXmlResourceTransformer\n+ 2 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt\n+ 3 Utils.kt\ncom/github/jengelman/gradle/plugins/shadow/internal/UtilsKt$zipEntry$1\n*L\n1#1,122:1\n35#2,14:123\n49#2:138\n39#3:137\n*S KotlinDebug\n*F\n+ 1 ComponentsXmlResourceTransformer.kt\ncom/github/jengelman/gradle/plugins/shadow/transformers/ComponentsXmlResourceTransformer\n*L\n100#1:123,14\n100#1:138\n100#1:137\n*E\n"})
public class ComponentsXmlResourceTransformer
implements ResourceTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Xpp3Dom> components = new LinkedHashMap();
    @NotNull
    public static final String COMPONENTS_XML_PATH = "META-INF/plexus/components.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Internal
    @NotNull
    public final byte[] getTransformedResource$shadow() {
        ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
        Closeable closeable = (Closeable)new XmlStreamWriter((OutputStream)os);
        Throwable throwable = null;
        try {
            XmlStreamWriter writer = (XmlStreamWriter)closeable;
            boolean bl = false;
            Xpp3Dom dom = new Xpp3Dom("component-set");
            Xpp3Dom componentDom = new Xpp3Dom("components");
            dom.addChild(componentDom);
            for (Xpp3Dom component : this.components.values()) {
                componentDom.addChild(component);
            }
            Xpp3DomWriter.write((Writer)((Writer)writer), (Xpp3Dom)dom);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        byte[] byArray = os.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return byArray;
    }

    @Override
    public boolean canTransformResource(@NotNull FileTreeElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return Intrinsics.areEqual((Object)COMPONENTS_XML_PATH, (Object)element.getPath());
    }

    @Override
    public void transform(@NotNull TransformerContext context) {
        BufferedInputStream bis2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Xpp3Dom[] xpp3DomArray = context.getInputStream();
            bis2 = new BufferedInputStream((InputStream)xpp3DomArray){

                public void close() throws IOException {
                }
            };
            bis2 = Xpp3DomBuilder.build((Reader)((Reader)new XmlStreamReader((InputStream)bis2)));
        }
        catch (Exception e) {
            throw new IOException("Error parsing components.xml in " + context.getInputStream(), e);
        }
        BufferedInputStream newDom2 = bis2;
        if (newDom2.getChild("components") == null) {
            return;
        }
        Xpp3Dom[] children = newDom2.getChild("components").getChildren("component");
        Intrinsics.checkNotNull((Object)children);
        for (Xpp3Dom component : children) {
            Intrinsics.checkNotNull((Object)component);
            String it = ComponentsXmlResourceTransformer.Companion.getValue(component, "role");
            boolean bl = false;
            String role = RelocationContextKt.relocateClass((Iterable<? extends Relocator>)context.getRelocators(), it);
            ComponentsXmlResourceTransformer.Companion.setValue(component, "role", role);
            String roleHint = ComponentsXmlResourceTransformer.Companion.getValue(component, "role-hint");
            String it2 = ComponentsXmlResourceTransformer.Companion.getValue(component, "implementation");
            boolean bl2 = false;
            String impl = RelocationContextKt.relocateClass((Iterable<? extends Relocator>)context.getRelocators(), it2);
            ComponentsXmlResourceTransformer.Companion.setValue(component, "implementation", impl);
            String key = role + ":" + roleHint;
            Xpp3Dom xpp3Dom = this.components.get(key);
            if (xpp3Dom != null && (xpp3Dom = xpp3Dom.getChild("configuration")) != null) {
                Xpp3Dom it3 = xpp3Dom;
                boolean bl3 = false;
                component.addChild(it3);
            }
            Xpp3Dom requirements = component.getChild("requirements");
            if (requirements != null && requirements.getChildCount() > 0) {
                for (int r = requirements.getChildCount() - 1; -1 < r; --r) {
                    Xpp3Dom requirement = requirements.getChild(r);
                    Intrinsics.checkNotNull((Object)requirement);
                    String it4 = ComponentsXmlResourceTransformer.Companion.getValue(requirement, "role");
                    boolean bl4 = false;
                    String requiredRole = RelocationContextKt.relocateClass((Iterable<? extends Relocator>)context.getRelocators(), it4);
                    ComponentsXmlResourceTransformer.Companion.setValue(requirement, "role", requiredRole);
                }
            }
            this.components.put(key, component);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void modifyOutputStream(@NotNull ZipOutputStream os, boolean preserveFileTimestamps) {
        void name$iv;
        ZipEntry zipEntry2;
        Intrinsics.checkNotNullParameter((Object)os, (String)"os");
        String string = COMPONENTS_XML_PATH;
        boolean preserveLastModified$iv = preserveFileTimestamps;
        long lastModified$iv = -1L;
        boolean $i$f$zipEntry = false;
        ZipEntry $this$zipEntry_u24lambda_u240$iv = zipEntry2 = new ZipEntry((String)name$iv);
        boolean bl = false;
        if (preserveLastModified$iv) {
            if (lastModified$iv >= 0L) {
                $this$zipEntry_u24lambda_u240$iv.setTime(lastModified$iv);
            }
        } else {
            $this$zipEntry_u24lambda_u240$iv.setTime(ShadowCopyAction.Companion.getCONSTANT_TIME_FOR_ZIP_ENTRIES());
        }
        ZipEntry zipEntry3 = $this$zipEntry_u24lambda_u240$iv;
        ZipOutputStream zipOutputStream = os;
        boolean bl2 = false;
        ZipEntry zipEntry4 = zipEntry3;
        zipOutputStream.putNextEntry(zipEntry2);
        os.write(this.getTransformedResource$shadow());
        this.components.clear();
        os.closeEntry();
    }

    @Override
    public boolean hasTransformedResource() {
        return !this.components.isEmpty();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/transformers/ComponentsXmlResourceTransformer$Companion;", "", "<init>", "()V", "COMPONENTS_XML_PATH", "", "getValue", "dom", "Lorg/codehaus/plexus/util/xml/Xpp3Dom;", "element", "setValue", "", "value", "shadow"})
    public static final class Companion {
        private Companion() {
        }

        private final String getValue(Xpp3Dom dom, String element) {
            String string = dom.getChild(element).getValue();
            if (string == null) {
                string = "";
            }
            return string;
        }

        private final void setValue(Xpp3Dom dom, String element, String value) {
            CharSequence charSequence;
            Xpp3Dom child = dom.getChild(element);
            if (child == null || (charSequence = (CharSequence)value) == null || charSequence.length() == 0) {
                return;
            }
            child.setValue(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

