/*
 * Decompiled with CFR 0.152.
 */
package com.github.jengelman.gradle.plugins.shadow.internal;

import com.github.jengelman.gradle.plugins.shadow.relocation.RelocationContextKt;
import com.github.jengelman.gradle.plugins.shadow.relocation.Relocator;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.commons.Remapper;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/github/jengelman/gradle/plugins/shadow/internal/RelocatorRemapper;", "Lorg/objectweb/asm/commons/Remapper;", "relocators", "", "Lcom/github/jengelman/gradle/plugins/shadow/relocation/Relocator;", "onModified", "Lkotlin/Function0;", "", "<init>", "(Ljava/util/Set;Lkotlin/jvm/functions/Function0;)V", "classPattern", "Ljava/util/regex/Pattern;", "mapValue", "", "value", "map", "", "internalName", "mapPath", "path", "mapName", "name", "mapLiterals", "", "mapNameImpl", "shadow"})
public final class RelocatorRemapper
extends Remapper {
    @NotNull
    private final Set<Relocator> relocators;
    @NotNull
    private final Function0<Unit> onModified;
    @NotNull
    private final Pattern classPattern;

    public RelocatorRemapper(@NotNull Set<? extends Relocator> relocators, @NotNull Function0<Unit> onModified) {
        Intrinsics.checkNotNullParameter(relocators, (String)"relocators");
        Intrinsics.checkNotNullParameter(onModified, (String)"onModified");
        this.relocators = relocators;
        this.onModified = onModified;
        Pattern pattern = Pattern.compile("(\\[*)?L(.+)");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        this.classPattern = pattern;
    }

    public /* synthetic */ RelocatorRemapper(Set set, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = RelocatorRemapper::_init_$lambda$0;
        }
        this(set, (Function0<Unit>)function0);
    }

    @NotNull
    public Object mapValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value instanceof String ? this.mapName((String)value, true) : super.mapValue(value);
        Intrinsics.checkNotNull((Object)object);
        return object;
    }

    @NotNull
    public String map(@NotNull String internalName) {
        Intrinsics.checkNotNullParameter((Object)internalName, (String)"internalName");
        return RelocatorRemapper.mapName$default(this, internalName, false, 2, null);
    }

    @NotNull
    public final String mapPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int dotIndex = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)0, (boolean)false, (int)6, null);
        return dotIndex == -1 ? path : this.map(StringsKt.take((String)path, (int)dotIndex));
    }

    private final String mapName(String name, boolean mapLiterals) {
        String newName = this.mapNameImpl(name, mapLiterals);
        if (!Intrinsics.areEqual((Object)newName, (Object)name)) {
            this.onModified.invoke();
        }
        return newName;
    }

    static /* synthetic */ String mapName$default(RelocatorRemapper relocatorRemapper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return relocatorRemapper.mapName(string, bl);
    }

    private final String mapNameImpl(String name, boolean mapLiterals) {
        String newName = name;
        Object prefix = "";
        String suffix = "";
        Matcher matcher = this.classPattern.matcher(newName);
        if (matcher.matches()) {
            prefix = matcher.group(1) + "L";
            suffix = "";
            String string = matcher.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            newName = string;
        }
        for (Relocator relocator : this.relocators) {
            if (mapLiterals && relocator.getSkipStringConstants()) {
                return name;
            }
            if (relocator.canRelocateClass(newName)) {
                return (String)prefix + RelocationContextKt.relocateClass(relocator, newName) + suffix;
            }
            if (!relocator.canRelocatePath(newName)) continue;
            return (String)prefix + RelocationContextKt.relocatePath(relocator, newName) + suffix;
        }
        return name;
    }

    private static final Unit _init_$lambda$0() {
        return Unit.INSTANCE;
    }
}

