/*
 * Decompiled with CFR 0.152.
 */
package shadow.org.apache.logging.log4j.core.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import java.io.IOException;
import java.util.List;
import shadow.org.apache.logging.log4j.core.impl.ContextDataFactory;
import shadow.org.apache.logging.log4j.core.jackson.MapEntry;
import shadow.org.apache.logging.log4j.util.StringMap;

public class ContextDataAsEntryListDeserializer
extends StdDeserializer<StringMap> {
    private static final long serialVersionUID = 1L;

    ContextDataAsEntryListDeserializer() {
        super(StringMap.class);
    }

    public StringMap deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        List list = (List)jp.readValueAs((TypeReference)new TypeReference<List<MapEntry>>(){});
        StringMap contextData = ContextDataFactory.createContextData();
        for (MapEntry mapEntry : list) {
            contextData.putValue(mapEntry.getKey(), mapEntry.getValue());
        }
        return contextData;
    }
}

