/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.message;

import com.gradle.scan.plugin.internal.dep.org.apache.http.FormattedHeader;
import com.gradle.scan.plugin.internal.dep.org.apache.http.Header;
import com.gradle.scan.plugin.internal.dep.org.apache.http.ProtocolVersion;
import com.gradle.scan.plugin.internal.dep.org.apache.http.RequestLine;
import com.gradle.scan.plugin.internal.dep.org.apache.http.StatusLine;
import com.gradle.scan.plugin.internal.dep.org.apache.http.message.LineFormatter;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.CharArrayBuffer;

public class BasicLineFormatter
implements LineFormatter {
    @Deprecated
    public static final BasicLineFormatter DEFAULT = new BasicLineFormatter();
    public static final BasicLineFormatter INSTANCE = new BasicLineFormatter();

    protected CharArrayBuffer initBuffer(CharArrayBuffer charArrayBuffer) {
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        if (charArrayBuffer2 != null) {
            charArrayBuffer2.clear();
        } else {
            charArrayBuffer2 = new CharArrayBuffer(64);
        }
        return charArrayBuffer2;
    }

    public CharArrayBuffer appendProtocolVersion(CharArrayBuffer charArrayBuffer, ProtocolVersion protocolVersion) {
        Args.notNull(protocolVersion, "Protocol version");
        CharArrayBuffer charArrayBuffer2 = charArrayBuffer;
        int n2 = this.estimateProtocolVersionLen(protocolVersion);
        if (charArrayBuffer2 == null) {
            charArrayBuffer2 = new CharArrayBuffer(n2);
        } else {
            charArrayBuffer2.ensureCapacity(n2);
        }
        charArrayBuffer2.append(protocolVersion.getProtocol());
        charArrayBuffer2.append('/');
        charArrayBuffer2.append(Integer.toString(protocolVersion.getMajor()));
        charArrayBuffer2.append('.');
        charArrayBuffer2.append(Integer.toString(protocolVersion.getMinor()));
        return charArrayBuffer2;
    }

    protected int estimateProtocolVersionLen(ProtocolVersion protocolVersion) {
        return protocolVersion.getProtocol().length() + 4;
    }

    @Override
    public CharArrayBuffer formatRequestLine(CharArrayBuffer charArrayBuffer, RequestLine requestLine) {
        Args.notNull(requestLine, "Request line");
        CharArrayBuffer charArrayBuffer2 = this.initBuffer(charArrayBuffer);
        this.doFormatRequestLine(charArrayBuffer2, requestLine);
        return charArrayBuffer2;
    }

    protected void doFormatRequestLine(CharArrayBuffer charArrayBuffer, RequestLine requestLine) {
        String string = requestLine.getMethod();
        String string2 = requestLine.getUri();
        int n2 = string.length() + 1 + string2.length() + 1 + this.estimateProtocolVersionLen(requestLine.getProtocolVersion());
        charArrayBuffer.ensureCapacity(n2);
        charArrayBuffer.append(string);
        charArrayBuffer.append(' ');
        charArrayBuffer.append(string2);
        charArrayBuffer.append(' ');
        this.appendProtocolVersion(charArrayBuffer, requestLine.getProtocolVersion());
    }

    public CharArrayBuffer formatStatusLine(CharArrayBuffer charArrayBuffer, StatusLine statusLine) {
        Args.notNull(statusLine, "Status line");
        CharArrayBuffer charArrayBuffer2 = this.initBuffer(charArrayBuffer);
        this.doFormatStatusLine(charArrayBuffer2, statusLine);
        return charArrayBuffer2;
    }

    protected void doFormatStatusLine(CharArrayBuffer charArrayBuffer, StatusLine statusLine) {
        int n2 = this.estimateProtocolVersionLen(statusLine.getProtocolVersion()) + 1 + 3 + 1;
        String string = statusLine.getReasonPhrase();
        if (string != null) {
            n2 += string.length();
        }
        charArrayBuffer.ensureCapacity(n2);
        this.appendProtocolVersion(charArrayBuffer, statusLine.getProtocolVersion());
        charArrayBuffer.append(' ');
        charArrayBuffer.append(Integer.toString(statusLine.getStatusCode()));
        charArrayBuffer.append(' ');
        if (string != null) {
            charArrayBuffer.append(string);
        }
    }

    @Override
    public CharArrayBuffer formatHeader(CharArrayBuffer charArrayBuffer, Header header) {
        CharArrayBuffer charArrayBuffer2;
        Args.notNull(header, "Header");
        if (header instanceof FormattedHeader) {
            charArrayBuffer2 = ((FormattedHeader)header).getBuffer();
        } else {
            charArrayBuffer2 = this.initBuffer(charArrayBuffer);
            this.doFormatHeader(charArrayBuffer2, header);
        }
        return charArrayBuffer2;
    }

    protected void doFormatHeader(CharArrayBuffer charArrayBuffer, Header header) {
        String string = header.getName();
        String string2 = header.getValue();
        int n2 = string.length() + 2;
        if (string2 != null) {
            n2 += string2.length();
        }
        charArrayBuffer.ensureCapacity(n2);
        charArrayBuffer.append(string);
        charArrayBuffer.append(": ");
        if (string2 != null) {
            charArrayBuffer.ensureCapacity(charArrayBuffer.length() + string2.length());
            for (int i2 = 0; i2 < string2.length(); ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\u000b') {
                    c2 = ' ';
                }
                charArrayBuffer.append(c2);
            }
        }
    }
}

