/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.cookie;

import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CommonCookieAttributeHandler;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.Cookie;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieOrigin;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.CookieRestrictionViolationException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.MalformedCookieException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.cookie.SetCookie;
import com.gradle.scan.plugin.internal.dep.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;

public class RFC2109VersionHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie setCookie, String string) throws MalformedCookieException {
        Args.notNull(setCookie, "Cookie");
        if (string == null) {
            throw new MalformedCookieException("Missing value for version attribute");
        }
        if (string.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for version attribute");
        }
        try {
            setCookie.setVersion(Integer.parseInt(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new MalformedCookieException("Invalid version: " + numberFormatException.getMessage());
        }
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin cookieOrigin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (cookie.getVersion() < 0) {
            throw new CookieRestrictionViolationException("Cookie version may not be negative");
        }
    }

    @Override
    public String getAttributeName() {
        return "version";
    }
}

