/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.util.BouncyCastleUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PrivateKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.bouncycastle.pkcs.PKCSException;

final class BouncyCastlePemReader {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(BouncyCastlePemReader.class);

    public static PrivateKey getPrivateKey(InputStream inputStream, String string) {
        if (!BouncyCastleUtil.isBcPkixAvailable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bouncy castle provider is unavailable.", BouncyCastleUtil.unavailabilityCauseBcPkix());
            }
            return null;
        }
        try {
            PEMParser pEMParser = BouncyCastlePemReader.newParser(inputStream);
            return BouncyCastlePemReader.getPrivateKey(pEMParser, string);
        }
        catch (Exception exception) {
            logger.debug("Unable to extract private key", exception);
            return null;
        }
    }

    public static PrivateKey getPrivateKey(File file, String string) {
        if (!BouncyCastleUtil.isBcPkixAvailable()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Bouncy castle provider is unavailable.", BouncyCastleUtil.unavailabilityCauseBcPkix());
            }
            return null;
        }
        try {
            PEMParser pEMParser = BouncyCastlePemReader.newParser(file);
            return BouncyCastlePemReader.getPrivateKey(pEMParser, string);
        }
        catch (Exception exception) {
            logger.debug("Unable to extract private key", exception);
            return null;
        }
    }

    private static JcaPEMKeyConverter newConverter() {
        return new JcaPEMKeyConverter().setProvider(BouncyCastleUtil.getBcProviderJce());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PrivateKey getPrivateKey(PEMParser pEMParser, String string) throws IOException, PKCSException, OperatorCreationException {
        try {
            PrivateKey privateKey;
            JcaPEMKeyConverter jcaPEMKeyConverter = BouncyCastlePemReader.newConverter();
            PrivateKey privateKey2 = null;
            Object object = pEMParser.readObject();
            while (object != null && privateKey2 == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Parsed PEM object of type {} and assume key is {}encrypted", (Object)object.getClass().getName(), (Object)(string == null ? "not " : ""));
                }
                if (string == null) {
                    if (object instanceof PrivateKeyInfo) {
                        privateKey2 = jcaPEMKeyConverter.getPrivateKey((PrivateKeyInfo)object);
                    } else if (object instanceof PEMKeyPair) {
                        privateKey2 = jcaPEMKeyConverter.getKeyPair((PEMKeyPair)object).getPrivate();
                    } else {
                        logger.debug("Unable to handle PEM object of type {} as a non encrypted key", (Object)object.getClass());
                    }
                } else if (object instanceof PEMEncryptedKeyPair) {
                    privateKey = new JcePEMDecryptorProviderBuilder().setProvider(BouncyCastleUtil.getBcProviderJce()).build(string.toCharArray());
                    privateKey2 = jcaPEMKeyConverter.getKeyPair(((PEMEncryptedKeyPair)object).decryptKeyPair((PEMDecryptorProvider)privateKey)).getPrivate();
                } else if (object instanceof PKCS8EncryptedPrivateKeyInfo) {
                    privateKey = new JceOpenSSLPKCS8DecryptorProviderBuilder().setProvider(BouncyCastleUtil.getBcProviderJce()).build(string.toCharArray());
                    privateKey2 = jcaPEMKeyConverter.getPrivateKey(((PKCS8EncryptedPrivateKeyInfo)object).decryptPrivateKeyInfo((InputDecryptorProvider)privateKey));
                } else {
                    logger.debug("Unable to handle PEM object of type {} as a encrypted key", (Object)object.getClass());
                }
                if (privateKey2 != null) continue;
                object = pEMParser.readObject();
            }
            if (privateKey2 == null && logger.isDebugEnabled()) {
                logger.debug("No key found");
            }
            privateKey = privateKey2;
            return privateKey;
        }
        finally {
            if (pEMParser != null) {
                try {
                    pEMParser.close();
                }
                catch (Exception exception) {
                    logger.debug("Failed closing pem parser", exception);
                }
            }
        }
    }

    private static PEMParser newParser(File file) throws FileNotFoundException {
        return new PEMParser((Reader)new FileReader(file));
    }

    private static PEMParser newParser(InputStream inputStream) {
        return new PEMParser((Reader)new InputStreamReader(inputStream, CharsetUtil.US_ASCII));
    }

    private BouncyCastlePemReader() {
    }
}

