/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.util.AsciiString;

public enum HttpStatusClass {
    INFORMATIONAL(100, 200, "Informational"),
    SUCCESS(200, 300, "Success"),
    REDIRECTION(300, 400, "Redirection"),
    CLIENT_ERROR(400, 500, "Client Error"),
    SERVER_ERROR(500, 600, "Server Error"),
    UNKNOWN(0, 0, "Unknown Status"){

        @Override
        public boolean contains(int n2) {
            return n2 < 100 || n2 >= 600;
        }
    };

    private static final HttpStatusClass[] statusArray;
    private final int min;
    private final int max;
    private final AsciiString defaultReasonPhrase;

    public static HttpStatusClass valueOf(int n2) {
        if (UNKNOWN.contains(n2)) {
            return UNKNOWN;
        }
        return statusArray[HttpStatusClass.fast_div100(n2)];
    }

    private static int fast_div100(int n2) {
        return (int)((long)n2 * 1374389535L >> 37);
    }

    private HttpStatusClass(int n3, int n4, String string2) {
        this.min = n3;
        this.max = n4;
        this.defaultReasonPhrase = AsciiString.cached(string2);
    }

    public boolean contains(int n2) {
        return n2 >= this.min && n2 < this.max;
    }

    static {
        statusArray = new HttpStatusClass[6];
        HttpStatusClass.statusArray[1] = INFORMATIONAL;
        HttpStatusClass.statusArray[2] = SUCCESS;
        HttpStatusClass.statusArray[3] = REDIRECTION;
        HttpStatusClass.statusArray[4] = CLIENT_ERROR;
        HttpStatusClass.statusArray[5] = SERVER_ERROR;
    }
}

