/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JacksonInject;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonCreator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.JavaType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.MapperFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyName;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.ConstructorDetector;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.Annotated;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.ObjectIdInfo;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.POJOPropertyBuilder;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.PotentialCreator;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.PotentialCreators;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.introspect.VisibilityChecker;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.jdk14.JDK14Util;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class POJOPropertiesCollector {
    protected final MapperConfig<?> _config;
    protected final AccessorNamingStrategy _accessorNaming;
    protected final boolean _forSerialization;
    protected final JavaType _type;
    protected final AnnotatedClass _classDef;
    protected final VisibilityChecker<?> _visibilityChecker;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected final boolean _useAnnotations;
    protected final boolean _isRecordType;
    protected boolean _collected;
    protected LinkedHashMap<String, POJOPropertyBuilder> _properties;
    protected List<POJOPropertyBuilder> _creatorProperties;
    protected PotentialCreators _potentialCreators;
    protected Map<PropertyName, PropertyName> _fieldRenameMappings;
    protected LinkedList<AnnotatedMember> _anyGetters;
    protected LinkedList<AnnotatedMember> _anyGetterField;
    protected LinkedList<AnnotatedMethod> _anySetters;
    protected LinkedList<AnnotatedMember> _anySetterField;
    protected LinkedList<AnnotatedMember> _jsonKeyAccessors;
    protected LinkedList<AnnotatedMember> _jsonValueAccessors;
    protected HashSet<String> _ignoredPropertyNames;
    protected LinkedHashMap<Object, AnnotatedMember> _injectables;
    protected JsonFormat.Value _formatOverrides;

    protected POJOPropertiesCollector(MapperConfig<?> mapperConfig, boolean bl2, JavaType javaType, AnnotatedClass annotatedClass, AccessorNamingStrategy accessorNamingStrategy) {
        this._config = mapperConfig;
        this._forSerialization = bl2;
        this._type = javaType;
        this._classDef = annotatedClass;
        this._isRecordType = this._type.isRecordType();
        if (mapperConfig.isAnnotationProcessingEnabled()) {
            this._useAnnotations = true;
            this._annotationIntrospector = this._config.getAnnotationIntrospector();
        } else {
            this._useAnnotations = false;
            this._annotationIntrospector = AnnotationIntrospector.nopInstance();
        }
        this._visibilityChecker = this._config.getDefaultVisibilityChecker(javaType.getRawClass(), annotatedClass);
        this._accessorNaming = accessorNamingStrategy;
    }

    public MapperConfig<?> getConfig() {
        return this._config;
    }

    public JavaType getType() {
        return this._type;
    }

    public boolean isRecordType() {
        return this._isRecordType;
    }

    public AnnotatedClass getClassDef() {
        return this._classDef;
    }

    public List<BeanPropertyDefinition> getProperties() {
        Map<String, POJOPropertyBuilder> map = this.getPropertyMap();
        return new ArrayList<BeanPropertyDefinition>(map.values());
    }

    public PotentialCreators getPotentialCreators() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._potentialCreators;
    }

    public Map<Object, AnnotatedMember> getInjectables() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._injectables;
    }

    public AnnotatedMember getJsonKeyAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonKeyAccessors != null) {
            if (this._jsonKeyAccessors.size() > 1 && !this._resolveFieldVsGetter(this._jsonKeyAccessors)) {
                this.reportProblem("Multiple 'as-key' properties defined (%s vs %s)", this._jsonKeyAccessors.get(0), this._jsonKeyAccessors.get(1));
            }
            return this._jsonKeyAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getJsonValueAccessor() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._jsonValueAccessors != null) {
            if (this._jsonValueAccessors.size() > 1 && !this._resolveFieldVsGetter(this._jsonValueAccessors)) {
                this.reportProblem("Multiple 'as-value' properties defined (%s vs %s)", this._jsonValueAccessors.get(0), this._jsonValueAccessors.get(1));
            }
            return this._jsonValueAccessors.get(0);
        }
        return null;
    }

    public AnnotatedMember getAnyGetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetterField != null) {
            if (this._anyGetterField.size() > 1) {
                this.reportProblem("Multiple 'any-getter' fields defined (%s vs %s)", this._anyGetterField.get(0), this._anyGetterField.get(1));
            }
            return this._anyGetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnyGetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anyGetters != null) {
            if (this._anyGetters.size() > 1) {
                this.reportProblem("Multiple 'any-getter' methods defined (%s vs %s)", this._anyGetters.get(0), this._anyGetters.get(1));
            }
            return this._anyGetters.getFirst();
        }
        return null;
    }

    public AnnotatedMember getAnySetterField() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetterField != null) {
            if (this._anySetterField.size() > 1) {
                this.reportProblem("Multiple 'any-setter' fields defined (%s vs %s)", this._anySetterField.get(0), this._anySetterField.get(1));
            }
            return this._anySetterField.getFirst();
        }
        return null;
    }

    public AnnotatedMethod getAnySetterMethod() {
        if (!this._collected) {
            this.collectAll();
        }
        if (this._anySetters != null) {
            if (this._anySetters.size() > 1) {
                this.reportProblem("Multiple 'any-setter' methods defined (%s vs %s)", this._anySetters.get(0), this._anySetters.get(1));
            }
            return this._anySetters.getFirst();
        }
        return null;
    }

    public Set<String> getIgnoredPropertyNames() {
        return this._ignoredPropertyNames;
    }

    public ObjectIdInfo getObjectIdInfo() {
        ObjectIdInfo objectIdInfo = this._annotationIntrospector.findObjectIdInfo(this._classDef);
        if (objectIdInfo != null) {
            objectIdInfo = this._annotationIntrospector.findObjectReferenceInfo(this._classDef, objectIdInfo);
        }
        return objectIdInfo;
    }

    protected Map<String, POJOPropertyBuilder> getPropertyMap() {
        if (!this._collected) {
            this.collectAll();
        }
        return this._properties;
    }

    public JsonFormat.Value getFormatOverrides() {
        if (this._formatOverrides == null) {
            JsonFormat.Value value;
            JsonFormat.Value value2 = null;
            if (this._annotationIntrospector != null) {
                value2 = this._annotationIntrospector.findFormat(this._classDef);
            }
            if ((value = this._config.getDefaultPropertyFormat(this._type.getRawClass())) != null) {
                value2 = value2 == null ? value : value2.withOverrides(value);
            }
            this._formatOverrides = value2 == null ? JsonFormat.Value.empty() : value2;
        }
        return this._formatOverrides;
    }

    protected void collectAll() {
        this._potentialCreators = new PotentialCreators();
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>();
        this._addFields(linkedHashMap);
        this._addMethods(linkedHashMap);
        if (!this._classDef.isNonStaticInnerClass()) {
            this._addCreators(linkedHashMap);
        }
        if (this._config.isEnabled(MapperFeature.FIX_FIELD_NAME_UPPER_CASE_PREFIX)) {
            this._fixLeadingFieldNameCase(linkedHashMap);
        }
        this._removeUnwantedProperties(linkedHashMap);
        this._removeUnwantedAccessors(linkedHashMap);
        this._renameProperties(linkedHashMap);
        this._addInjectables(linkedHashMap);
        for (POJOPropertyBuilder iterator : linkedHashMap.values()) {
            iterator.mergeAnnotations(this._forSerialization);
        }
        PropertyNamingStrategy propertyNamingStrategy = this._findNamingStrategy();
        if (propertyNamingStrategy != null) {
            this._renameUsing(linkedHashMap, propertyNamingStrategy);
        }
        for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
            pOJOPropertyBuilder.trimByVisibility();
        }
        if (this._isRecordType && !this._forSerialization) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedHashMap.values()) {
                pOJOPropertyBuilder.removeFields();
            }
        }
        if (this._config.isEnabled(MapperFeature.USE_WRAPPER_NAME_AS_PROPERTY_NAME)) {
            this._renameWithWrappers(linkedHashMap);
        }
        this._sortProperties(linkedHashMap);
        this._properties = linkedHashMap;
        this._collected = true;
    }

    private Map<String, POJOPropertyBuilder> _putAnyGettersInTheEnd(Map<String, POJOPropertyBuilder> map) {
        AnnotatedMember annotatedMember;
        if (this._anyGetters != null) {
            annotatedMember = this._anyGetters.getFirst();
        } else if (this._anyGetterField != null) {
            annotatedMember = this._anyGetterField.getFirst();
        } else {
            return map;
        }
        LinkedHashMap<String, POJOPropertyBuilder> linkedHashMap = new LinkedHashMap<String, POJOPropertyBuilder>(map.size() * 2);
        POJOPropertyBuilder pOJOPropertyBuilder = null;
        for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
            if (pOJOPropertyBuilder2.hasFieldOrGetter(annotatedMember)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder2;
                continue;
            }
            linkedHashMap.put(pOJOPropertyBuilder2.getName(), pOJOPropertyBuilder2);
        }
        if (pOJOPropertyBuilder != null) {
            linkedHashMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
        }
        return linkedHashMap;
    }

    protected void _addFields(Map<String, POJOPropertyBuilder> map) {
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        boolean bl2 = !this._forSerialization && !this._config.isEnabled(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS);
        boolean bl3 = this._config.isEnabled(MapperFeature.PROPAGATE_TRANSIENT_MARKER);
        for (AnnotatedField annotatedField : this._classDef.fields()) {
            boolean bl4;
            PropertyName propertyName;
            boolean bl5;
            boolean bl6;
            String string;
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedField))) {
                if (this._jsonKeyAccessors == null) {
                    this._jsonKeyAccessors = new LinkedList();
                }
                this._jsonKeyAccessors.add(annotatedField);
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedField))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedField);
                continue;
            }
            boolean bl7 = Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedField));
            boolean bl8 = Boolean.TRUE.equals(annotationIntrospector.hasAnySetter(annotatedField));
            if (bl7 || bl8) {
                if (bl7) {
                    if (this._anyGetterField == null) {
                        this._anyGetterField = new LinkedList();
                    }
                    this._anyGetterField.add(annotatedField);
                }
                if (bl8) {
                    if (this._anySetterField == null) {
                        this._anySetterField = new LinkedList();
                    }
                    this._anySetterField.add(annotatedField);
                    continue;
                }
            }
            if ((string = annotationIntrospector.findImplicitPropertyName(annotatedField)) == null) {
                string = annotatedField.getName();
            }
            if ((string = this._accessorNaming.modifyFieldName(annotatedField, string)) == null) continue;
            PropertyName propertyName2 = this._propNameFromSimple(string);
            PropertyName propertyName3 = annotationIntrospector.findRenameByField(this._config, annotatedField, propertyName2);
            if (propertyName3 != null && !propertyName3.equals(propertyName2)) {
                if (this._fieldRenameMappings == null) {
                    this._fieldRenameMappings = new HashMap<PropertyName, PropertyName>();
                }
                this._fieldRenameMappings.put(propertyName3, propertyName2);
            }
            if ((bl6 = (bl5 = (propertyName = this._forSerialization ? annotationIntrospector.findNameForSerialization(annotatedField) : annotationIntrospector.findNameForDeserialization(annotatedField)) != null)) && propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl6 = false;
            }
            boolean bl9 = bl4 = propertyName != null;
            if (!bl4) {
                bl4 = this._visibilityChecker.isFieldVisible(annotatedField);
            }
            boolean bl10 = annotationIntrospector.hasIgnoreMarker(annotatedField);
            if (annotatedField.isTransient() && !bl5) {
                if (bl3) {
                    bl10 = true;
                } else if (!bl10) continue;
            }
            if (bl2 && propertyName == null && !bl10 && Modifier.isFinal(annotatedField.getModifiers())) continue;
            this._property(map, string).addField(annotatedField, propertyName, bl6, bl4, bl10);
        }
    }

    protected void _addCreators(Map<String, POJOPropertyBuilder> map) {
        PotentialCreators potentialCreators = this._potentialCreators;
        List<PotentialCreator> list = this._collectCreators(this._classDef.getConstructors());
        List<PotentialCreator> list2 = this._collectCreators(this._classDef.getFactoryMethods());
        PotentialCreator potentialCreator = this._isRecordType ? JDK14Util.findCanonicalRecordConstructor(this._config, this._classDef, list) : this._annotationIntrospector.findDefaultCreator(this._config, this._classDef, list, list2);
        this._removeDisabledCreators(list);
        this._removeDisabledCreators(list2);
        this._removeNonFactoryStaticMethods(list2, potentialCreator);
        if (this._useAnnotations) {
            this._addExplicitlyAnnotatedCreators(potentialCreators, list, map, false);
            this._addExplicitlyAnnotatedCreators(potentialCreators, list2, map, potentialCreators.hasPropertiesBased());
        }
        if (!potentialCreators.hasPropertiesBased()) {
            this._addCreatorsWithAnnotatedNames(potentialCreators, list, potentialCreator);
        }
        if (potentialCreator != null && (list.remove(potentialCreator) || list2.remove(potentialCreator))) {
            if (this._isDelegatingConstructor(potentialCreator)) {
                if (!potentialCreators.hasDelegating()) {
                    potentialCreators.addExplicitDelegating(potentialCreator);
                }
            } else if (!potentialCreators.hasPropertiesBased()) {
                potentialCreators.setPropertiesBased(this._config, potentialCreator, "Primary");
            }
        }
        ConstructorDetector constructorDetector = this._config.getConstructorDetector();
        if (!(potentialCreators.hasPropertiesBasedOrDelegating() || constructorDetector.requireCtorAnnotation() || this._classDef.getDefaultConstructor() != null && !constructorDetector.singleArgCreatorDefaultsToProperties())) {
            this._addImplicitConstructor(potentialCreators, list, map);
        }
        this._removeNonVisibleCreators(list);
        this._removeNonVisibleCreators(list2);
        potentialCreators.setImplicitDelegating(list, list2);
        PotentialCreator potentialCreator2 = potentialCreators.propertiesBased;
        if (potentialCreator2 == null) {
            this._creatorProperties = Collections.emptyList();
        } else {
            this._creatorProperties = new ArrayList<POJOPropertyBuilder>();
            this._addCreatorParams(map, potentialCreator2, this._creatorProperties);
        }
    }

    private boolean _isDelegatingConstructor(PotentialCreator potentialCreator) {
        switch (potentialCreator.creatorModeOrDefault()) {
            case DELEGATING: {
                return true;
            }
            case DISABLED: 
            case PROPERTIES: {
                return false;
            }
        }
        return potentialCreator.paramCount() == 1 && this._jsonValueAccessors != null && !this._jsonValueAccessors.isEmpty();
    }

    private List<PotentialCreator> _collectCreators(List<? extends AnnotatedWithParams> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList();
        for (AnnotatedWithParams annotatedWithParams : list) {
            JsonCreator.Mode mode = this._useAnnotations ? this._annotationIntrospector.findCreatorAnnotation(this._config, annotatedWithParams) : null;
            arrayList.add(new PotentialCreator(annotatedWithParams, mode));
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    private void _removeDisabledCreators(List<PotentialCreator> list) {
        Iterator<PotentialCreator> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().creatorMode() != JsonCreator.Mode.DISABLED) continue;
            iterator.remove();
        }
    }

    private void _removeNonVisibleCreators(List<PotentialCreator> list) {
        Iterator<PotentialCreator> iterator = list.iterator();
        while (iterator.hasNext()) {
            PotentialCreator potentialCreator = iterator.next();
            if (this._visibilityChecker.isCreatorVisible(potentialCreator.creator())) continue;
            iterator.remove();
        }
    }

    private void _removeNonFactoryStaticMethods(List<PotentialCreator> list, PotentialCreator potentialCreator) {
        Class<?> clazz = this._type.getRawClass();
        Iterator<PotentialCreator> iterator = list.iterator();
        while (iterator.hasNext()) {
            Class<?> clazz2;
            String string;
            AnnotatedWithParams annotatedWithParams;
            PotentialCreator potentialCreator2 = iterator.next();
            if (potentialCreator2.isAnnotated() || potentialCreator == potentialCreator2 || clazz.isAssignableFrom((annotatedWithParams = potentialCreator2.creator()).getRawType()) && potentialCreator2.paramCount() == 1 && ("valueOf".equals(string = annotatedWithParams.getName()) || "fromString".equals(string) && ((clazz2 = annotatedWithParams.getRawParameterType(0)) == String.class || CharSequence.class.isAssignableFrom(clazz2)))) continue;
            iterator.remove();
        }
    }

    private void _addExplicitlyAnnotatedCreators(PotentialCreators potentialCreators, List<PotentialCreator> list, Map<String, POJOPropertyBuilder> map, boolean bl2) {
        ConstructorDetector constructorDetector = this._config.getConstructorDetector();
        Iterator<PotentialCreator> iterator = list.iterator();
        while (iterator.hasNext()) {
            boolean bl3;
            PotentialCreator potentialCreator = iterator.next();
            if (!potentialCreator.isAnnotated()) continue;
            iterator.remove();
            switch (potentialCreator.creatorMode()) {
                case DELEGATING: {
                    bl3 = false;
                    break;
                }
                case PROPERTIES: {
                    bl3 = true;
                    break;
                }
                default: {
                    bl3 = this._isExplicitlyAnnotatedCreatorPropsBased(potentialCreator, map, constructorDetector);
                }
            }
            if (bl3) {
                if (bl2) continue;
                potentialCreators.setPropertiesBased(this._config, potentialCreator, "explicit");
                continue;
            }
            potentialCreators.addExplicitDelegating(potentialCreator);
        }
    }

    private boolean _isExplicitlyAnnotatedCreatorPropsBased(PotentialCreator potentialCreator, Map<String, POJOPropertyBuilder> map, ConstructorDetector constructorDetector) {
        if (potentialCreator.paramCount() == 1) {
            switch (constructorDetector.singleArgMode()) {
                case DELEGATING: {
                    return false;
                }
                case PROPERTIES: {
                    return true;
                }
                case REQUIRE_MODE: {
                    throw new IllegalArgumentException(String.format("Single-argument constructor (%s) is annotated but no 'mode' defined; `ConstructorDetector`configured with `SingleArgConstructor.REQUIRE_MODE`", potentialCreator.creator()));
                }
            }
        }
        potentialCreator.introspectParamNames(this._config);
        if (potentialCreator.hasExplicitNames()) {
            return true;
        }
        if (this._jsonValueAccessors != null && !this._jsonValueAccessors.isEmpty()) {
            return false;
        }
        if (potentialCreator.paramCount() == 1) {
            PropertyName propertyName = potentialCreator.implicitName(0);
            if (propertyName != null) {
                POJOPropertyBuilder pOJOPropertyBuilder = map.get(propertyName.getSimpleName());
                if (pOJOPropertyBuilder != null) {
                    if (pOJOPropertyBuilder.anyVisible() && !pOJOPropertyBuilder.anyIgnorals()) {
                        return true;
                    }
                } else {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
                        if (!pOJOPropertyBuilder2.anyVisible() || pOJOPropertyBuilder2.anyIgnorals() || !pOJOPropertyBuilder2.hasExplicitName(propertyName)) continue;
                        return true;
                    }
                }
            }
            return this._annotationIntrospector != null && this._annotationIntrospector.findInjectableValue(potentialCreator.param(0)) != null;
        }
        return potentialCreator.hasNameOrInjectForAllParams(this._config);
    }

    private void _addCreatorsWithAnnotatedNames(PotentialCreators potentialCreators, List<PotentialCreator> list, PotentialCreator potentialCreator) {
        List<PotentialCreator> list2 = this._findCreatorsWithAnnotatedNames(list);
        if (potentialCreator != null && list2.contains(potentialCreator)) {
            potentialCreators.setPropertiesBased(this._config, potentialCreator, "implicit");
            return;
        }
        for (PotentialCreator potentialCreator2 : list2) {
            potentialCreators.setPropertiesBased(this._config, potentialCreator2, "implicit");
        }
    }

    private List<PotentialCreator> _findCreatorsWithAnnotatedNames(List<PotentialCreator> list) {
        ArrayList<PotentialCreator> arrayList = null;
        Iterator<PotentialCreator> iterator = list.iterator();
        while (iterator.hasNext()) {
            PotentialCreator potentialCreator = iterator.next();
            potentialCreator.introspectParamNames(this._config);
            if (!potentialCreator.hasExplicitNames()) continue;
            iterator.remove();
            if (arrayList == null) {
                arrayList = new ArrayList<PotentialCreator>(4);
            }
            arrayList.add(potentialCreator);
        }
        return arrayList == null ? Collections.emptyList() : arrayList;
    }

    private boolean _addImplicitConstructor(PotentialCreators potentialCreators, List<PotentialCreator> list, Map<String, POJOPropertyBuilder> map) {
        if (list.size() != 1) {
            return false;
        }
        PotentialCreator potentialCreator = list.get(0);
        if (!this._visibilityChecker.isCreatorVisible(potentialCreator.creator())) {
            return false;
        }
        potentialCreator.introspectParamNames(this._config);
        if (potentialCreator.paramCount() != 1) {
            if (!potentialCreator.hasNameOrInjectForAllParams(this._config)) {
                return false;
            }
        } else if (this._annotationIntrospector == null || this._annotationIntrospector.findInjectableValue(potentialCreator.param(0)) == null) {
            POJOPropertyBuilder pOJOPropertyBuilder;
            ConstructorDetector constructorDetector = this._config.getConstructorDetector();
            if (constructorDetector.singleArgCreatorDefaultsToDelegating()) {
                return false;
            }
            String string = potentialCreator.implicitNameSimple(0);
            if (string == null) {
                return false;
            }
            if (!(constructorDetector.singleArgCreatorDefaultsToProperties() || (pOJOPropertyBuilder = map.get(string)) != null && pOJOPropertyBuilder.anyVisible() && !pOJOPropertyBuilder.anyIgnorals())) {
                return false;
            }
        }
        list.remove(0);
        potentialCreators.setPropertiesBased(this._config, potentialCreator, "implicit");
        return true;
    }

    private void _addCreatorParams(Map<String, POJOPropertyBuilder> map, PotentialCreator potentialCreator, List<POJOPropertyBuilder> list) {
        int n2 = potentialCreator.paramCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            POJOPropertyBuilder pOJOPropertyBuilder;
            boolean bl2;
            AnnotatedParameter annotatedParameter = potentialCreator.param(i2);
            PropertyName propertyName = potentialCreator.explicitName(i2);
            PropertyName propertyName2 = potentialCreator.implicitName(i2);
            boolean bl3 = bl2 = propertyName != null;
            if (!bl2 && propertyName2 == null) {
                boolean bl4;
                boolean bl5 = bl4 = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedParameter) != null;
                if (bl4) {
                    PropertyName propertyName3 = UnwrappedPropertyHandler.creatorParamName(annotatedParameter.getIndex());
                    pOJOPropertyBuilder = this._property(map, propertyName3);
                    pOJOPropertyBuilder.addCtor(annotatedParameter, propertyName3, false, true, false);
                } else {
                    pOJOPropertyBuilder = null;
                }
            } else {
                if (propertyName2 != null) {
                    String string = this._checkRenameByField(propertyName2.getSimpleName());
                    propertyName2 = PropertyName.construct(string);
                }
                pOJOPropertyBuilder = propertyName2 == null ? this._property(map, propertyName) : this._property(map, propertyName2);
                pOJOPropertyBuilder.addCtor(annotatedParameter, bl2 ? propertyName : propertyName2, bl2, true, false);
            }
            list.add(pOJOPropertyBuilder);
        }
        potentialCreator.assignPropertyDefs(list);
    }

    protected void _addMethods(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            int n2 = annotatedMethod.getParameterCount();
            if (n2 == 0) {
                this._addGetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n2 == 1) {
                this._addSetterMethod(map, annotatedMethod, this._annotationIntrospector);
                continue;
            }
            if (n2 != 2 || !Boolean.TRUE.equals(this._annotationIntrospector.hasAnySetter(annotatedMethod))) continue;
            if (this._anySetters == null) {
                this._anySetters = new LinkedList();
            }
            this._anySetters.add(annotatedMethod);
        }
    }

    protected void _addGetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        boolean bl3;
        Object object = annotatedMethod.getRawReturnType();
        if (object == Void.TYPE || object == Void.class && !this._config.isEnabled(MapperFeature.ALLOW_VOID_VALUED_PROPERTIES)) {
            return;
        }
        if (Boolean.TRUE.equals(annotationIntrospector.hasAnyGetter(annotatedMethod))) {
            if (this._anyGetters == null) {
                this._anyGetters = new LinkedList();
            }
            this._anyGetters.add(annotatedMethod);
        } else {
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsKey(this._config, annotatedMethod))) {
                if (this._jsonKeyAccessors == null) {
                    this._jsonKeyAccessors = new LinkedList();
                }
                this._jsonKeyAccessors.add(annotatedMethod);
                return;
            }
            if (Boolean.TRUE.equals(annotationIntrospector.hasAsValue(annotatedMethod))) {
                if (this._jsonValueAccessors == null) {
                    this._jsonValueAccessors = new LinkedList();
                }
                this._jsonValueAccessors.add(annotatedMethod);
                return;
            }
        }
        PropertyName propertyName = annotationIntrospector.findNameForSerialization(annotatedMethod);
        boolean bl4 = bl3 = propertyName != null;
        if (!bl3) {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null) {
                object = this._accessorNaming.findNameForRegularGetter(annotatedMethod, annotatedMethod.getName());
            }
            if (object == null) {
                object = this._accessorNaming.findNameForIsGetter(annotatedMethod, annotatedMethod.getName());
                if (object == null) {
                    return;
                }
                bl2 = this._visibilityChecker.isIsGetterVisible(annotatedMethod);
            } else {
                bl2 = this._visibilityChecker.isGetterVisible(annotatedMethod);
            }
        } else {
            object = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (object == null && (object = this._accessorNaming.findNameForRegularGetter(annotatedMethod, annotatedMethod.getName())) == null) {
                object = this._accessorNaming.findNameForIsGetter(annotatedMethod, annotatedMethod.getName());
            }
            if (object == null) {
                object = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple((String)object);
                bl3 = false;
            }
            bl2 = true;
        }
        object = this._checkRenameByField((String)object);
        boolean bl5 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, (String)object).addGetter(annotatedMethod, propertyName, bl3, bl2, bl5);
    }

    protected void _addSetterMethod(Map<String, POJOPropertyBuilder> map, AnnotatedMethod annotatedMethod, AnnotationIntrospector annotationIntrospector) {
        boolean bl2;
        String string;
        boolean bl3;
        PropertyName propertyName = annotationIntrospector.findNameForDeserialization(annotatedMethod);
        boolean bl4 = bl3 = propertyName != null;
        if (!bl3) {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = this._accessorNaming.findNameForMutator(annotatedMethod, annotatedMethod.getName());
            }
            if (string == null) {
                return;
            }
            bl2 = this._visibilityChecker.isSetterVisible(annotatedMethod);
        } else {
            string = annotationIntrospector.findImplicitPropertyName(annotatedMethod);
            if (string == null) {
                string = this._accessorNaming.findNameForMutator(annotatedMethod, annotatedMethod.getName());
            }
            if (string == null) {
                string = annotatedMethod.getName();
            }
            if (propertyName.isEmpty()) {
                propertyName = this._propNameFromSimple(string);
                bl3 = false;
            }
            bl2 = true;
        }
        string = this._checkRenameByField(string);
        boolean bl5 = annotationIntrospector.hasIgnoreMarker(annotatedMethod);
        this._property(map, string).addSetter(annotatedMethod, propertyName, bl3, bl2, bl5);
    }

    protected void _addInjectables(Map<String, POJOPropertyBuilder> map) {
        for (AnnotatedField object : this._classDef.fields()) {
            this._doAddInjectable(this._annotationIntrospector.findInjectableValue(object), object);
        }
        for (AnnotatedMethod annotatedMethod : this._classDef.memberMethods()) {
            if (annotatedMethod.getParameterCount() != 1) continue;
            this._doAddInjectable(this._annotationIntrospector.findInjectableValue(annotatedMethod), annotatedMethod);
        }
        if (this._injectables != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                AnnotatedParameter annotatedParameter;
                JacksonInject.Value value;
                if (pOJOPropertyBuilder == null || (value = this._annotationIntrospector.findInjectableValue(annotatedParameter = pOJOPropertyBuilder.getConstructorParameter())) == null) continue;
                this._injectables.remove(value.getId());
            }
        }
    }

    protected void _doAddInjectable(JacksonInject.Value value, AnnotatedMember annotatedMember) {
        AnnotatedMember annotatedMember2;
        if (value == null) {
            return;
        }
        Object object = value.getId();
        if (this._injectables == null) {
            this._injectables = new LinkedHashMap();
        }
        if ((annotatedMember2 = this._injectables.put(object, annotatedMember)) != null && annotatedMember2.getClass() == annotatedMember.getClass()) {
            this.reportProblem("Duplicate injectable value with id '%s' (of type %s)", object, ClassUtil.classNameOf(object));
        }
    }

    private PropertyName _propNameFromSimple(String string) {
        return PropertyName.construct(string, null);
    }

    private String _checkRenameByField(String string) {
        PropertyName propertyName;
        if (this._fieldRenameMappings != null && (propertyName = this._fieldRenameMappings.get(this._propNameFromSimple(string))) != null) {
            string = propertyName.getSimpleName();
            return string;
        }
        return string;
    }

    protected void _fixLeadingFieldNameCase(Map<String, POJOPropertyBuilder> map) {
        Object object;
        HashMap<String, Object> hashMap = null;
        for (Map.Entry<String, POJOPropertyBuilder> entry : map.entrySet()) {
            object = entry.getValue();
            if (((POJOPropertyBuilder)object).isExplicitlyNamed() || !((POJOPropertyBuilder)object).hasField() && !((POJOPropertyBuilder)object).hasConstructorParameter() || ((POJOPropertyBuilder)object).hasGetter() || ((POJOPropertyBuilder)object).hasSetter() || !this._firstOrSecondCharUpperCase(entry.getKey())) continue;
            if (hashMap == null) {
                hashMap = new HashMap<String, Object>();
            }
            hashMap.put(entry.getKey(), object);
        }
        if (hashMap == null) {
            return;
        }
        block1: for (Map.Entry<String, POJOPropertyBuilder> entry : hashMap.entrySet()) {
            object = map.entrySet().iterator();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            String string = entry.getKey();
            while (object.hasNext()) {
                Map.Entry entry2 = (Map.Entry)object.next();
                POJOPropertyBuilder pOJOPropertyBuilder2 = (POJOPropertyBuilder)entry2.getValue();
                if (pOJOPropertyBuilder2 == pOJOPropertyBuilder || pOJOPropertyBuilder2.hasField() || !string.equalsIgnoreCase((String)entry2.getKey())) continue;
                object.remove();
                pOJOPropertyBuilder.addAll(pOJOPropertyBuilder2);
                continue block1;
            }
        }
    }

    private boolean _firstOrSecondCharUpperCase(String string) {
        switch (string.length()) {
            case 0: {
                return false;
            }
            default: {
                if (Character.isLowerCase(string.charAt(1))) break;
                return true;
            }
            case 1: 
        }
        return !Character.isLowerCase(string.charAt(0));
    }

    protected void _removeUnwantedProperties(Map<String, POJOPropertyBuilder> map) {
        Iterator<POJOPropertyBuilder> iterator = map.values().iterator();
        while (iterator.hasNext()) {
            POJOPropertyBuilder pOJOPropertyBuilder = iterator.next();
            if (!pOJOPropertyBuilder.anyVisible()) {
                iterator.remove();
                continue;
            }
            if (!pOJOPropertyBuilder.anyIgnorals()) continue;
            if (this.isRecordType() && !this._forSerialization) {
                pOJOPropertyBuilder.removeIgnored();
                this._collectIgnorals(pOJOPropertyBuilder.getName());
                continue;
            }
            if (!pOJOPropertyBuilder.anyExplicitsWithoutIgnoral()) {
                iterator.remove();
                this._collectIgnorals(pOJOPropertyBuilder.getName());
                continue;
            }
            pOJOPropertyBuilder.removeIgnored();
            if (pOJOPropertyBuilder.couldDeserialize()) continue;
            this._collectIgnorals(pOJOPropertyBuilder.getName());
        }
    }

    protected void _removeUnwantedAccessors(Map<String, POJOPropertyBuilder> map) {
        boolean bl2 = this._config.isEnabled(MapperFeature.INFER_PROPERTY_MUTATORS);
        for (POJOPropertyBuilder pOJOPropertyBuilder : map.values()) {
            pOJOPropertyBuilder.removeNonVisible(bl2, this._forSerialization ? null : this);
        }
    }

    protected void _collectIgnorals(String string) {
        if (!this._forSerialization && string != null) {
            if (this._ignoredPropertyNames == null) {
                this._ignoredPropertyNames = new HashSet();
            }
            this._ignoredPropertyNames.add(string);
        }
    }

    protected void _renameProperties(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            if (this._ignoredPropertyNames != null && this._ignoredPropertyNames.contains(pOJOPropertyBuilder.getName()) || (object2 = pOJOPropertyBuilder.findExplicitNames()).isEmpty()) continue;
            iterator.remove();
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            if (object2.size() == 1) {
                object = (PropertyName)object2.iterator().next();
                linkedList.add(pOJOPropertyBuilder.withName((PropertyName)object));
                continue;
            }
            linkedList.addAll(pOJOPropertyBuilder.explode((Collection<PropertyName>)object2));
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                } else {
                    ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
                }
                if (!this._replaceCreatorProperty(this._creatorProperties, pOJOPropertyBuilder) || this._ignoredPropertyNames == null) continue;
                this._ignoredPropertyNames.remove(object2);
            }
        }
    }

    protected void _renameUsing(Map<String, POJOPropertyBuilder> map, PropertyNamingStrategy propertyNamingStrategy) {
        if (this._type.isEnumType() && this.getFormatOverrides().getShape() != JsonFormat.Shape.OBJECT) {
            return;
        }
        POJOPropertyBuilder[] pOJOPropertyBuilderArray = map.values().toArray(new POJOPropertyBuilder[map.size()]);
        map.clear();
        for (POJOPropertyBuilder pOJOPropertyBuilder : pOJOPropertyBuilderArray) {
            String string;
            PropertyName propertyName = pOJOPropertyBuilder.getFullName();
            String string2 = null;
            if (!pOJOPropertyBuilder.isExplicitlyNamed() || this._config.isEnabled(MapperFeature.ALLOW_EXPLICIT_PROPERTY_RENAMING)) {
                if (this._forSerialization) {
                    if (pOJOPropertyBuilder.hasGetter()) {
                        string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetter(), propertyName.getSimpleName());
                    } else if (pOJOPropertyBuilder.hasField()) {
                        string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getField(), propertyName.getSimpleName());
                    }
                } else if (pOJOPropertyBuilder.hasSetter()) {
                    string2 = propertyNamingStrategy.nameForSetterMethod(this._config, pOJOPropertyBuilder.getSetterUnchecked(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasConstructorParameter()) {
                    string2 = propertyNamingStrategy.nameForConstructorParameter(this._config, pOJOPropertyBuilder.getConstructorParameter(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasField()) {
                    string2 = propertyNamingStrategy.nameForField(this._config, pOJOPropertyBuilder.getFieldUnchecked(), propertyName.getSimpleName());
                } else if (pOJOPropertyBuilder.hasGetter()) {
                    string2 = propertyNamingStrategy.nameForGetterMethod(this._config, pOJOPropertyBuilder.getGetterUnchecked(), propertyName.getSimpleName());
                }
            }
            if (string2 != null && !propertyName.hasSimpleName(string2)) {
                pOJOPropertyBuilder = pOJOPropertyBuilder.withSimpleName(string2);
                string = string2;
            } else {
                string = propertyName.getSimpleName();
            }
            POJOPropertyBuilder pOJOPropertyBuilder2 = map.get(string);
            if (pOJOPropertyBuilder2 == null) {
                map.put(string, pOJOPropertyBuilder);
            } else {
                pOJOPropertyBuilder2.addAll(pOJOPropertyBuilder);
            }
            this._replaceCreatorProperty(this._creatorProperties, pOJOPropertyBuilder);
        }
    }

    protected void _renameWithWrappers(Map<String, POJOPropertyBuilder> map) {
        Object object;
        Object object2;
        Iterator<Map.Entry<String, POJOPropertyBuilder>> iterator = map.entrySet().iterator();
        LinkedList<POJOPropertyBuilder> linkedList = null;
        while (iterator.hasNext()) {
            Map.Entry<String, POJOPropertyBuilder> entry = iterator.next();
            POJOPropertyBuilder pOJOPropertyBuilder = entry.getValue();
            object2 = pOJOPropertyBuilder.getPrimaryMember();
            if (object2 == null || (object = this._annotationIntrospector.findWrapperName((Annotated)object2)) == null || !((PropertyName)object).hasSimpleName() || ((PropertyName)object).equals(pOJOPropertyBuilder.getFullName())) continue;
            if (linkedList == null) {
                linkedList = new LinkedList<POJOPropertyBuilder>();
            }
            pOJOPropertyBuilder = pOJOPropertyBuilder.withName((PropertyName)object);
            linkedList.add(pOJOPropertyBuilder);
            iterator.remove();
        }
        if (linkedList != null) {
            for (POJOPropertyBuilder pOJOPropertyBuilder : linkedList) {
                object2 = pOJOPropertyBuilder.getName();
                object = map.get(object2);
                if (object == null) {
                    map.put((String)object2, pOJOPropertyBuilder);
                    continue;
                }
                ((POJOPropertyBuilder)object).addAll(pOJOPropertyBuilder);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void _sortProperties(Map<String, POJOPropertyBuilder> map) {
        Object object2;
        int n2;
        AnnotationIntrospector annotationIntrospector = this._annotationIntrospector;
        Boolean bl2 = annotationIntrospector.findSerializationSortAlphabetically(this._classDef);
        boolean bl3 = bl2 == null ? this._config.shouldSortPropertiesAlphabetically() : bl2.booleanValue();
        boolean bl4 = this._anyIndexed(map.values());
        String[] stringArray = annotationIntrospector.findSerializationPropertyOrder(this._classDef);
        if (!bl3 && !bl4 && this._creatorProperties == null && stringArray == null) {
            return;
        }
        int n3 = map.size();
        Map<Object, Object> map2 = bl3 ? new TreeMap() : new LinkedHashMap(n3 + n3);
        for (POJOPropertyBuilder object32 : map.values()) {
            map2.put(object32.getName(), object32);
        }
        map2 = this._putAnyGettersInTheEnd(map2);
        LinkedHashMap linkedHashMap = new LinkedHashMap(n3 + n3);
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            n2 = stringArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                void var14_26;
                object2 = stringArray2[i2];
                POJOPropertyBuilder pOJOPropertyBuilder = (POJOPropertyBuilder)map2.remove(object2);
                if (pOJOPropertyBuilder == null) {
                    for (POJOPropertyBuilder pOJOPropertyBuilder2 : map.values()) {
                        if (!((String)object2).equals(pOJOPropertyBuilder2.getInternalName())) continue;
                        POJOPropertyBuilder pOJOPropertyBuilder3 = pOJOPropertyBuilder2;
                        object2 = pOJOPropertyBuilder2.getName();
                        break;
                    }
                }
                if (var14_26 == null) continue;
                linkedHashMap.put(object2, var14_26);
            }
        }
        if (bl4) {
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            Iterator<Map.Entry<Object, Object>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Object, Object> entry = iterator.next();
                object2 = (POJOPropertyBuilder)entry.getValue();
                Integer n4 = ((POJOPropertyBuilder)object2).getMetadata().getIndex();
                if (n4 == null) continue;
                treeMap.put(n4, object2);
                iterator.remove();
            }
            for (Object object2 : treeMap.values()) {
                linkedHashMap.put(((POJOPropertyBuilder)object2).getName(), object2);
            }
        }
        if (this._creatorProperties != null && (!bl3 || this._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_FIRST))) {
            void var10_17;
            int n5 = n2 = bl3 && !this._config.isEnabled(MapperFeature.SORT_CREATOR_PROPERTIES_BY_DECLARATION_ORDER) ? 1 : 0;
            if (n2 != 0) {
                TreeMap<String, POJOPropertyBuilder> treeMap = new TreeMap<String, POJOPropertyBuilder>();
                for (POJOPropertyBuilder pOJOPropertyBuilder : this._creatorProperties) {
                    if (pOJOPropertyBuilder == null) continue;
                    treeMap.put(pOJOPropertyBuilder.getName(), pOJOPropertyBuilder);
                }
                Collection collection = treeMap.values();
            } else {
                List<POJOPropertyBuilder> list = this._creatorProperties;
            }
            for (Object object2 : var10_17) {
                String string;
                if (object2 == null || !map2.containsKey(string = ((POJOPropertyBuilder)object2).getName())) continue;
                linkedHashMap.put(string, object2);
            }
        }
        linkedHashMap.putAll(map2);
        map.clear();
        map.putAll(linkedHashMap);
    }

    private boolean _anyIndexed(Collection<POJOPropertyBuilder> collection) {
        for (POJOPropertyBuilder pOJOPropertyBuilder : collection) {
            if (!pOJOPropertyBuilder.getMetadata().hasIndex()) continue;
            return true;
        }
        return false;
    }

    protected boolean _resolveFieldVsGetter(List<AnnotatedMember> list) {
        do {
            AnnotatedMember annotatedMember = list.get(0);
            AnnotatedMember annotatedMember2 = list.get(1);
            if (annotatedMember instanceof AnnotatedField) {
                if (annotatedMember2 instanceof AnnotatedMethod) {
                    list.remove(0);
                    continue;
                }
            } else if (annotatedMember instanceof AnnotatedMethod && annotatedMember2 instanceof AnnotatedField) {
                list.remove(1);
                continue;
            }
            return false;
        } while (list.size() > 1);
        return true;
    }

    protected void reportProblem(String string, Object ... objectArray) {
        if (objectArray.length > 0) {
            string = String.format(string, objectArray);
        }
        throw new IllegalArgumentException("Problem with definition of " + this._classDef + ": " + string);
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, PropertyName propertyName) {
        String string = propertyName.getSimpleName();
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, propertyName);
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    protected POJOPropertyBuilder _property(Map<String, POJOPropertyBuilder> map, String string) {
        POJOPropertyBuilder pOJOPropertyBuilder = map.get(string);
        if (pOJOPropertyBuilder == null) {
            pOJOPropertyBuilder = new POJOPropertyBuilder(this._config, this._annotationIntrospector, this._forSerialization, PropertyName.construct(string));
            map.put(string, pOJOPropertyBuilder);
        }
        return pOJOPropertyBuilder;
    }

    private PropertyNamingStrategy _findNamingStrategy() {
        PropertyNamingStrategy propertyNamingStrategy;
        HandlerInstantiator handlerInstantiator;
        Class clazz;
        Object object = this._annotationIntrospector.findNamingStrategy(this._classDef);
        if (object == null) {
            return this._config.getPropertyNamingStrategy();
        }
        if (object instanceof PropertyNamingStrategy) {
            return (PropertyNamingStrategy)object;
        }
        if (!(object instanceof Class)) {
            this.reportProblem("AnnotationIntrospector returned PropertyNamingStrategy definition of type %s; expected type `PropertyNamingStrategy` or `Class<PropertyNamingStrategy>` instead", ClassUtil.classNameOf(object));
        }
        if ((clazz = (Class)object) == PropertyNamingStrategy.class) {
            return null;
        }
        if (!PropertyNamingStrategy.class.isAssignableFrom(clazz)) {
            this.reportProblem("AnnotationIntrospector returned Class %s; expected `Class<PropertyNamingStrategy>`", ClassUtil.classNameOf(clazz));
        }
        if ((handlerInstantiator = this._config.getHandlerInstantiator()) != null && (propertyNamingStrategy = handlerInstantiator.namingStrategyInstance(this._config, this._classDef, clazz)) != null) {
            return propertyNamingStrategy;
        }
        return (PropertyNamingStrategy)ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
    }

    protected boolean _replaceCreatorProperty(List<POJOPropertyBuilder> list, POJOPropertyBuilder pOJOPropertyBuilder) {
        AnnotatedParameter annotatedParameter = pOJOPropertyBuilder.getConstructorParameter();
        if (list != null && annotatedParameter != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                POJOPropertyBuilder pOJOPropertyBuilder2 = list.get(i2);
                if (pOJOPropertyBuilder2 == null || pOJOPropertyBuilder2.getConstructorParameter() != annotatedParameter) continue;
                list.set(i2, pOJOPropertyBuilder);
                return true;
            }
        }
        return false;
    }
}

