/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.VirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac.MacGlobalMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac.MacVirtualMemoryJNA;
import com.gradle.scan.plugin.internal.dep.oshi.jna.ByRef;
import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.mac.SysctlUtil;
import com.sun.jna.Native;
import com.sun.jna.platform.mac.SystemB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MacGlobalMemoryJNA
extends MacGlobalMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacGlobalMemoryJNA.class);

    MacGlobalMemoryJNA() {
    }

    @Override
    protected long queryVmStats() {
        try (Struct.CloseableVMStatistics closeableVMStatistics = new Struct.CloseableVMStatistics();){
            ByRef.CloseableIntByReference closeableIntByReference;
            block12: {
                closeableIntByReference = new ByRef.CloseableIntByReference(closeableVMStatistics.size() / SystemB.INT_SIZE);
                try {
                    if (0 == SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, closeableVMStatistics, closeableIntByReference)) break block12;
                    LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
                    long l2 = 0L;
                    closeableIntByReference.close();
                    return l2;
                }
                catch (Throwable throwable) {
                    try {
                        closeableIntByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l3 = (long)(closeableVMStatistics.free_count + closeableVMStatistics.inactive_count) * this.getPageSize();
            closeableIntByReference.close();
            return l3;
        }
    }

    @Override
    protected long sysctl(String string, long l2) {
        return SysctlUtil.sysctl(string, l2);
    }

    @Override
    protected long host_page_size() {
        try (ByRef.CloseableLongByReference closeableLongByReference = new ByRef.CloseableLongByReference();){
            if (0 == SystemB.INSTANCE.host_page_size(SystemB.INSTANCE.mach_host_self(), closeableLongByReference)) {
                long l2 = closeableLongByReference.getValue();
                return l2;
            }
        }
        return -1L;
    }

    @Override
    protected VirtualMemory createVirtualMemory() {
        return new MacVirtualMemoryJNA(this);
    }
}

