/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutorChooserFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultEventExecutorChooserFactory
implements EventExecutorChooserFactory {
    public static final DefaultEventExecutorChooserFactory INSTANCE = new DefaultEventExecutorChooserFactory();

    private DefaultEventExecutorChooserFactory() {
    }

    @Override
    public EventExecutorChooserFactory.EventExecutorChooser newChooser(EventExecutor[] eventExecutorArray) {
        if (DefaultEventExecutorChooserFactory.isPowerOfTwo(eventExecutorArray.length)) {
            return new PowerOfTwoEventExecutorChooser(eventExecutorArray);
        }
        return new GenericEventExecutorChooser(eventExecutorArray);
    }

    private static boolean isPowerOfTwo(int n2) {
        return (n2 & -n2) == n2;
    }

    private static final class GenericEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicLong idx = new AtomicLong();
        private final EventExecutor[] executors;

        GenericEventExecutorChooser(EventExecutor[] eventExecutorArray) {
            this.executors = eventExecutorArray;
        }

        @Override
        public EventExecutor next() {
            return this.executors[(int)Math.abs(this.idx.getAndIncrement() % (long)this.executors.length)];
        }
    }

    private static final class PowerOfTwoEventExecutorChooser
    implements EventExecutorChooserFactory.EventExecutorChooser {
        private final AtomicInteger idx = new AtomicInteger();
        private final EventExecutor[] executors;

        PowerOfTwoEventExecutorChooser(EventExecutor[] eventExecutorArray) {
            this.executors = eventExecutorArray;
        }

        @Override
        public EventExecutor next() {
            return this.executors[this.idx.getAndIncrement() & this.executors.length - 1];
        }
    }
}

