/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util;

import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import java.io.Closeable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class LeakPresenceDetector<T>
extends ResourceLeakDetector<T> {
    private static final boolean TRACK_CREATION_STACK = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.util.LeakPresenceDetector.trackCreationStack", false);
    private static final ResourceScope GLOBAL = new ResourceScope("global");
    private static int staticInitializerCount;

    private static boolean inStaticInitializerSlow(StackTraceElement[] stackTraceElementArray) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            if (!stackTraceElement.getMethodName().equals("<clinit>")) continue;
            return true;
        }
        return false;
    }

    private static boolean inStaticInitializerFast() {
        return staticInitializerCount != 0 && LeakPresenceDetector.inStaticInitializerSlow(Thread.currentThread().getStackTrace());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <R> R staticInitializer(Supplier<R> supplier) {
        if (!LeakPresenceDetector.inStaticInitializerSlow(Thread.currentThread().getStackTrace())) {
            throw new IllegalStateException("Not in static initializer.");
        }
        Class clazz = LeakPresenceDetector.class;
        synchronized (LeakPresenceDetector.class) {
            ++staticInitializerCount;
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            try {
                clazz = supplier.get();
                return (R)clazz;
            }
            finally {
                Class<LeakPresenceDetector> clazz2 = LeakPresenceDetector.class;
                synchronized (LeakPresenceDetector.class) {
                    --staticInitializerCount;
                    // ** MonitorExit[var2_3] (shouldn't be in output)
                }
            }
        }
    }

    protected ResourceScope currentScope() throws AllocationProhibitedException {
        return GLOBAL;
    }

    @Override
    public final ResourceLeakTracker<T> track(T t2) {
        if (LeakPresenceDetector.inStaticInitializerFast()) {
            return null;
        }
        return this.trackForcibly(t2);
    }

    @Override
    public final ResourceLeakTracker<T> trackForcibly(T t2) {
        return new PresenceTracker(this.currentScope());
    }

    @Override
    public final boolean isRecordEnabled() {
        return false;
    }

    public static final class AllocationProhibitedException
    extends IllegalStateException {
        public AllocationProhibitedException(String string) {
            super(string);
        }
    }

    private static final class LeakCreation
    extends Throwable {
        final Thread thread = Thread.currentThread();
        String message;

        private LeakCreation() {
        }

        @Override
        public synchronized String getMessage() {
            if (this.message == null) {
                this.message = LeakPresenceDetector.inStaticInitializerSlow(this.getStackTrace()) ? "Resource created in static initializer. Please wrap the static initializer in LeakPresenceDetector.staticInitializer so that this resource is excluded." : "Resource created outside static initializer on thread '" + this.thread.getName() + "' (" + (Object)((Object)this.thread.getState()) + "), likely leak.";
            }
            return this.message;
        }
    }

    public static final class ResourceScope
    implements Closeable {
        final String name;
        final LongAdder openResourceCounter = new LongAdder();
        final Map<PresenceTracker<?>, Throwable> creationStacks = LeakPresenceDetector.access$000() ? new ConcurrentHashMap() : null;
        boolean closed;

        public ResourceScope(String string) {
            this.name = string;
        }

        void checkOpen() {
            if (this.closed) {
                throw new AllocationProhibitedException("Resource scope '" + this.name + "' already closed");
            }
        }

        void check() {
            long l2 = this.openResourceCounter.sumThenReset();
            if (l2 != 0L) {
                StringBuilder stringBuilder = new StringBuilder("Possible memory leak detected for resource scope '").append(this.name).append("'. ");
                if (l2 < 0L) {
                    stringBuilder.append("Resource count was negative: A resource previously reported as a leak was released after all. Please ensure that that resource is released before its test finishes.");
                    throw new IllegalStateException(stringBuilder.toString());
                }
                if (TRACK_CREATION_STACK) {
                    stringBuilder.append("Creation stack traces:");
                    IllegalStateException illegalStateException = new IllegalStateException(stringBuilder.toString());
                    int n2 = 0;
                    for (Throwable throwable : this.creationStacks.values()) {
                        illegalStateException.addSuppressed(throwable);
                        if (n2++ <= 5) continue;
                        break;
                    }
                    this.creationStacks.clear();
                    throw illegalStateException;
                }
                stringBuilder.append("Please use paranoid leak detection to get more information, or set -Dio.netty.util.LeakPresenceDetector.trackCreationStack=true");
                throw new IllegalStateException(stringBuilder.toString());
            }
        }

        @Override
        public void close() {
            this.closed = true;
            this.check();
        }
    }

    private static final class PresenceTracker<T>
    extends AtomicBoolean
    implements ResourceLeakTracker<T> {
        private final ResourceScope scope;

        PresenceTracker(ResourceScope resourceScope) {
            super(false);
            this.scope = resourceScope;
            resourceScope.checkOpen();
            resourceScope.openResourceCounter.increment();
            if (TRACK_CREATION_STACK) {
                resourceScope.creationStacks.put(this, new LeakCreation());
            }
        }

        @Override
        public void record() {
        }

        @Override
        public void record(Object object) {
        }

        @Override
        public boolean close(Object object) {
            if (this.compareAndSet(false, true)) {
                this.scope.openResourceCounter.decrement();
                if (TRACK_CREATION_STACK) {
                    this.scope.creationStacks.remove(this);
                }
                this.scope.checkOpen();
                return true;
            }
            return false;
        }
    }
}

