/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ApplicationProtocolConfig;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteFilter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ClientAuth;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslClientSessionCache;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialManager;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslSessionTicketKey;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ResumptionController;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContextOption;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.CertificateCallback;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.CertificateVerifier;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLContext;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;

public final class ReferenceCountedOpenSslClientContext
extends ReferenceCountedOpenSslContext {
    private static final String[] SUPPORTED_KEY_TYPES = new String[]{"RSA", "DH_RSA", "EC", "EC_RSA", "EC_EC"};
    private final OpenSslSessionContext sessionContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReferenceCountedOpenSslClientContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, String[] stringArray, long l2, long l3, boolean bl2, String string2, String string3, List<SNIServerName> list, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) throws SSLException {
        super(iterable, cipherSuiteFilter, ReferenceCountedOpenSslClientContext.toNegotiator(applicationProtocolConfig), 0, x509CertificateArray2, ClientAuth.NONE, stringArray, false, string3, bl2, true, list, resumptionController, entryArray);
        boolean bl3 = false;
        try {
            this.sessionContext = ReferenceCountedOpenSslClientContext.newSessionContext(this, this.ctx, this.engines, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l2, l3, resumptionController, ReferenceCountedOpenSslClientContext.isJdkSignatureFallbackEnabled(entryArray));
            bl3 = true;
        }
        finally {
            if (!bl3) {
                this.release();
            }
        }
    }

    @Override
    public OpenSslSessionContext sessionContext() {
        return this.sessionContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OpenSslSessionContext newSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, long l2, Map<Long, ReferenceCountedOpenSslEngine> map, X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, String string2, long l3, long l4, ResumptionController resumptionController, boolean bl2) throws SSLException {
        if (privateKey == null && x509CertificateArray2 != null || privateKey != null && x509CertificateArray2 == null) {
            throw new IllegalArgumentException("Either both keyCertChain and key needs to be null or none of them");
        }
        OpenSslKeyMaterialProvider openSslKeyMaterialProvider = null;
        try {
            Object object;
            try {
                if (keyManagerFactory == null && privateKey != null && privateKey.getEncoded() == null) {
                    if (!bl2) {
                        throw new SSLException("Private key requiring alternative signature provider detected (such as hardware security key, smart card, or remote signing service) but alternative key fallback is disabled.");
                    }
                    openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.setupSecurityProviderSignatureSource(referenceCountedOpenSslContext, l2, x509CertificateArray2, privateKey, openSslKeyMaterialManager -> new OpenSslClientCertificateCallback(map, (OpenSslKeyMaterialManager)openSslKeyMaterialManager));
                } else if (!OpenSsl.useKeyManagerFactory()) {
                    if (keyManagerFactory != null) {
                        throw new IllegalArgumentException("KeyManagerFactory not supported");
                    }
                    if (x509CertificateArray2 != null) {
                        ReferenceCountedOpenSslClientContext.setKeyMaterial(l2, x509CertificateArray2, privateKey, string);
                    }
                } else {
                    if (keyManagerFactory == null && x509CertificateArray2 != null) {
                        keyManagerFactory = ReferenceCountedOpenSslClientContext.certChainToKeyManagerFactory(x509CertificateArray2, privateKey, string, string2);
                    }
                    if (keyManagerFactory != null) {
                        openSslKeyMaterialProvider = ReferenceCountedOpenSslClientContext.providerFor(keyManagerFactory, string);
                    }
                    if (openSslKeyMaterialProvider != null) {
                        object = new OpenSslKeyMaterialManager(openSslKeyMaterialProvider, referenceCountedOpenSslContext.hasTmpDhKeys);
                        SSLContext.setCertificateCallback((long)l2, (CertificateCallback)new OpenSslClientCertificateCallback(map, (OpenSslKeyMaterialManager)object));
                    }
                }
            }
            catch (Exception exception) {
                throw new SSLException("failed to set certificate and key", exception);
            }
            SSLContext.setVerify((long)l2, (int)1, (int)10);
            try {
                if (x509CertificateArray != null) {
                    trustManagerFactory = ReferenceCountedOpenSslClientContext.buildTrustManagerFactory(x509CertificateArray, trustManagerFactory, string2);
                } else if (trustManagerFactory == null) {
                    trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    trustManagerFactory.init((KeyStore)null);
                }
                object = ReferenceCountedOpenSslClientContext.chooseTrustManager(trustManagerFactory.getTrustManagers(), resumptionController);
                ReferenceCountedOpenSslClientContext.setVerifyCallback(l2, map, (X509TrustManager)object);
            }
            catch (Exception exception) {
                if (openSslKeyMaterialProvider != null) {
                    openSslKeyMaterialProvider.destroy();
                }
                throw new SSLException("unable to setup trustmanager", exception);
            }
            object = new OpenSslClientSessionContext(referenceCountedOpenSslContext, openSslKeyMaterialProvider);
            ((OpenSslSessionContext)object).setSessionCacheEnabled(CLIENT_ENABLE_SESSION_CACHE);
            if (l3 > 0L) {
                ((OpenSslSessionContext)object).setSessionCacheSize((int)Math.min(l3, Integer.MAX_VALUE));
            }
            if (l4 > 0L) {
                ((OpenSslSessionContext)object).setSessionTimeout((int)Math.min(l4, Integer.MAX_VALUE));
            }
            if (CLIENT_ENABLE_SESSION_TICKET) {
                ((OpenSslSessionContext)object).setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            openSslKeyMaterialProvider = null;
            Object object2 = object;
            return object2;
        }
        finally {
            if (openSslKeyMaterialProvider != null) {
                openSslKeyMaterialProvider.destroy();
            }
        }
    }

    private static void setVerifyCallback(long l2, Map<Long, ReferenceCountedOpenSslEngine> map, X509TrustManager x509TrustManager) {
        if (ReferenceCountedOpenSslClientContext.useExtendedTrustManager(x509TrustManager)) {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new ExtendedTrustManagerVerifyCallback(map, (X509ExtendedTrustManager)x509TrustManager));
        } else {
            SSLContext.setCertVerifyCallback((long)l2, (CertificateVerifier)new TrustManagerVerifyCallback(map, x509TrustManager));
        }
    }

    private static final class OpenSslClientCertificateCallback
    implements CertificateCallback {
        private final Map<Long, ReferenceCountedOpenSslEngine> engines;
        private final OpenSslKeyMaterialManager keyManagerHolder;

        OpenSslClientCertificateCallback(Map<Long, ReferenceCountedOpenSslEngine> map, OpenSslKeyMaterialManager openSslKeyMaterialManager) {
            this.engines = map;
            this.keyManagerHolder = openSslKeyMaterialManager;
        }
    }

    private static final class ExtendedTrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509ExtendedTrustManager manager;

        ExtendedTrustManagerVerifyCallback(Map<Long, ReferenceCountedOpenSslEngine> map, X509ExtendedTrustManager x509ExtendedTrustManager) {
            super(map);
            this.manager = x509ExtendedTrustManager;
        }
    }

    private static final class TrustManagerVerifyCallback
    extends ReferenceCountedOpenSslContext.AbstractCertificateVerifier {
        private final X509TrustManager manager;

        TrustManagerVerifyCallback(Map<Long, ReferenceCountedOpenSslEngine> map, X509TrustManager x509TrustManager) {
            super(map);
            this.manager = x509TrustManager;
        }
    }

    static final class OpenSslClientSessionContext
    extends OpenSslSessionContext {
        OpenSslClientSessionContext(ReferenceCountedOpenSslContext referenceCountedOpenSslContext, OpenSslKeyMaterialProvider openSslKeyMaterialProvider) {
            super(referenceCountedOpenSslContext, openSslKeyMaterialProvider, SSL.SSL_SESS_CACHE_CLIENT, new OpenSslClientSessionCache(referenceCountedOpenSslContext.engines));
        }
    }
}

