/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import javax.net.ssl.SSLParameters;

final class OpenSslParametersUtil {
    private static final MethodHandle GET_NAMED_GROUPS;
    private static final MethodHandle SET_NAMED_GROUPS;

    private static MethodHandle obtainHandle(MethodHandles.Lookup lookup, String string, MethodType methodType) {
        return AccessController.doPrivileged(() -> {
            try {
                return lookup.findVirtual(SSLParameters.class, string, methodType);
            }
            catch (IllegalAccessException | NoSuchMethodException | SecurityException | UnsupportedOperationException exception) {
                return null;
            }
        });
    }

    static String[] getNamesGroups(SSLParameters sSLParameters) {
        if (GET_NAMED_GROUPS == null) {
            return null;
        }
        try {
            return GET_NAMED_GROUPS.invoke(sSLParameters);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static void setNamesGroups(SSLParameters sSLParameters, String[] stringArray) {
        if (SET_NAMED_GROUPS == null) {
            return;
        }
        try {
            SET_NAMED_GROUPS.invoke(sSLParameters, stringArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        if (PlatformDependent.javaVersion() >= 20) {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            methodHandle = OpenSslParametersUtil.obtainHandle(lookup, "getNamedGroups", MethodType.methodType(String[].class));
            methodHandle2 = OpenSslParametersUtil.obtainHandle(lookup, "setNamedGroups", MethodType.methodType(Void.TYPE, String[].class));
        }
        GET_NAMED_GROUPS = methodHandle;
        SET_NAMED_GROUPS = methodHandle2;
    }
}

