/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnpooledByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.CipherSuiteConverter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.GroupsConverter;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSslEngine;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.PemPrivateKey;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslProvider;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.Buffer;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.Library;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSL;
import com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLContext;
import com.gradle.scan.plugin.internal.dep.io.netty.util.CharsetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.LeakPresenceDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCountUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ReferenceCounted;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.EmptyArrays;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.NativeLibraryLoader;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.ByteArrayInputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.security.cert.CertificateException;
import javax.security.cert.X509Certificate;

public final class OpenSsl {
    private static final InternalLogger logger;
    private static final Throwable UNAVAILABILITY_CAUSE;
    static final List<String> DEFAULT_CIPHERS;
    static final Set<String> AVAILABLE_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_OPENSSL_CIPHER_SUITES;
    private static final Set<String> AVAILABLE_JAVA_CIPHER_SUITES;
    private static final boolean SUPPORTS_KEYMANAGER_FACTORY;
    private static final boolean USE_KEYMANAGER_FACTORY;
    private static final boolean SUPPORTS_OCSP;
    private static final boolean TLSV13_SUPPORTED;
    private static final boolean IS_BORINGSSL;
    private static final boolean IS_AWSLC;
    private static final Set<String> CLIENT_DEFAULT_PROTOCOLS;
    private static final Set<String> SERVER_DEFAULT_PROTOCOLS;
    private static final int supportedProtocolsPacked;
    static final String[] EXTRA_SUPPORTED_TLS_1_3_CIPHERS;
    static final String EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING;
    static final String[] NAMED_GROUPS;
    static final boolean JAVAX_CERTIFICATE_CREATION_SUPPORTED;
    private static final String[] DEFAULT_NAMED_GROUPS;

    static String checkTls13Ciphers(InternalLogger internalLogger, String string) {
        if (IS_BORINGSSL && !string.isEmpty()) {
            assert (EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length > 0);
            HashSet hashSet = new HashSet(EXTRA_SUPPORTED_TLS_1_3_CIPHERS.length);
            Collections.addAll(hashSet, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
            boolean bl2 = false;
            for (String string2 : string.split(":")) {
                if (hashSet.isEmpty()) {
                    bl2 = true;
                    break;
                }
                if (hashSet.remove(string2) || hashSet.remove(CipherSuiteConverter.toJava(string2, "TLS"))) continue;
                bl2 = true;
                break;
            }
            if (bl2 |= !hashSet.isEmpty()) {
                if (internalLogger.isInfoEnabled()) {
                    StringBuilder stringBuilder = new StringBuilder(128);
                    for (String string3 : string.split(":")) {
                        stringBuilder.append(CipherSuiteConverter.toJava(string3, "TLS")).append(":");
                    }
                    stringBuilder.setLength(stringBuilder.length() - 1);
                    internalLogger.info("BoringSSL doesn't allow to enable or disable TLSv1.3 ciphers explicitly. Provided TLSv1.3 ciphers: '{}', default TLSv1.3 ciphers that will be used: '{}'.", (Object)stringBuilder, (Object)EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING);
                }
                return EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING;
            }
        }
        return string;
    }

    static java.security.cert.X509Certificate selfSignedCertificate() throws java.security.cert.CertificateException {
        return (java.security.cert.X509Certificate)SslContext.X509_CERT_FACTORY.generateCertificate(new ByteArrayInputStream("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doesSupportOcsp() {
        boolean bl2 = false;
        if ((long)OpenSsl.version() >= 0x10002000L) {
            long l2 = -1L;
            try {
                l2 = SSLContext.make((int)16, (int)1);
                SSLContext.enableOcsp((long)l2, (boolean)false);
                bl2 = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (l2 != -1L) {
                    SSLContext.free((long)l2);
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean doesSupportProtocol(int n2, int n3) {
        if (n3 == 0) {
            return false;
        }
        long l2 = -1L;
        try {
            l2 = SSLContext.make((int)n2, (int)2);
            boolean bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            if (l2 != -1L) {
                SSLContext.free((long)l2);
            }
        }
    }

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static boolean isOcspSupported() {
        return SUPPORTS_OCSP;
    }

    public static int version() {
        return OpenSsl.isAvailable() ? SSL.version() : -1;
    }

    public static String versionString() {
        return OpenSsl.isAvailable() ? SSL.versionString() : null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Set<String> availableJavaCipherSuites() {
        return AVAILABLE_JAVA_CIPHER_SUITES;
    }

    public static boolean isCipherSuiteAvailable(String string) {
        String string2 = CipherSuiteConverter.toOpenSsl(string, IS_BORINGSSL);
        if (string2 != null) {
            string = string2;
        }
        return AVAILABLE_OPENSSL_CIPHER_SUITES.contains(string);
    }

    static boolean useKeyManagerFactory() {
        return USE_KEYMANAGER_FACTORY;
    }

    static long memoryAddress(ByteBuf byteBuf) {
        assert (byteBuf.isDirect());
        if (byteBuf.hasMemoryAddress()) {
            return byteBuf.memoryAddress();
        }
        ByteBuffer byteBuffer = byteBuf.internalNioBuffer(0, byteBuf.readableBytes());
        return Buffer.address((ByteBuffer)byteBuffer) + (long)byteBuffer.position();
    }

    private OpenSsl() {
    }

    private static void loadTcNative() throws Exception {
        String string = PlatformDependent.normalizedOs();
        String string2 = PlatformDependent.normalizedArch();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(5);
        String string3 = "netty_tcnative";
        if ("linux".equals(string)) {
            Set<String> set = PlatformDependent.normalizedLinuxClassifiers();
            for (String string4 : set) {
                linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_" + string4);
            }
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
            linkedHashSet.add(string3 + "_" + string + '_' + string2 + "_fedora");
        } else {
            linkedHashSet.add(string3 + "_" + string + '_' + string2);
        }
        linkedHashSet.add(string3 + "_" + string2);
        linkedHashSet.add(string3);
        NativeLibraryLoader.loadFirstAvailable(PlatformDependent.getClassLoader(SSLContext.class), linkedHashSet.toArray(EmptyArrays.EMPTY_STRINGS));
    }

    private static boolean initializeTcNative(String string) throws Exception {
        return Library.initialize((String)"provided", (String)string);
    }

    static void releaseIfNeeded(ReferenceCounted referenceCounted) {
        if (referenceCounted.refCnt() > 0) {
            ReferenceCountUtil.safeRelease(referenceCounted);
        }
    }

    static boolean isTlsv13Supported() {
        return TLSV13_SUPPORTED;
    }

    private static Set<String> defaultProtocols(String string) {
        String string2 = SystemPropertyUtil.get(string, null);
        HashSet<String> hashSet = new HashSet<String>();
        if (string2 != null) {
            for (String string3 : string2.split(",")) {
                String string4 = string3.trim();
                hashSet.add(string4);
            }
        } else {
            hashSet.add("TLSv1.2");
            hashSet.add("TLSv1.3");
        }
        return hashSet;
    }

    static String[] defaultProtocols(boolean bl2) {
        Set<String> set;
        Set<String> set2 = set = bl2 ? CLIENT_DEFAULT_PROTOCOLS : SERVER_DEFAULT_PROTOCOLS;
        assert (set != null);
        ArrayList<String> arrayList = new ArrayList<String>(set.size());
        for (String string : set) {
            if (!OpenSsl.isProtocolSupported(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(EmptyArrays.EMPTY_STRINGS);
    }

    static boolean isProtocolSupported(String string) {
        int n2 = OpenSsl.getProtocolBit(string);
        return n2 != -1 && (supportedProtocolsPacked & n2) != 0;
    }

    private static int getProtocolBit(String string) {
        if (string == null) {
            return -1;
        }
        switch (string) {
            case "SSLv2Hello": {
                return 1;
            }
            case "SSLv2": {
                return 2;
            }
            case "SSLv3": {
                return 4;
            }
            case "TLSv1": {
                return 8;
            }
            case "TLSv1.1": {
                return 16;
            }
            case "TLSv1.2": {
                return 32;
            }
            case "TLSv1.3": {
                return 64;
            }
        }
        return -1;
    }

    static List<String> unpackSupportedProtocols() {
        ArrayList<String> arrayList = new ArrayList<String>(7);
        if ((supportedProtocolsPacked & 1) != 0) {
            arrayList.add("SSLv2Hello");
        }
        if ((supportedProtocolsPacked & 2) != 0) {
            arrayList.add("SSLv2");
        }
        if ((supportedProtocolsPacked & 4) != 0) {
            arrayList.add("SSLv3");
        }
        if ((supportedProtocolsPacked & 8) != 0) {
            arrayList.add("TLSv1");
        }
        if ((supportedProtocolsPacked & 0x10) != 0) {
            arrayList.add("TLSv1.1");
        }
        if ((supportedProtocolsPacked & 0x20) != 0) {
            arrayList.add("TLSv1.2");
        }
        if ((supportedProtocolsPacked & 0x40) != 0) {
            arrayList.add("TLSv1.3");
        }
        return arrayList;
    }

    static boolean isBoringSSL() {
        return IS_BORINGSSL;
    }

    static boolean isAWSLC() {
        return IS_AWSLC;
    }

    private static /* synthetic */ Long lambda$static$0(java.security.cert.X509Certificate x509Certificate) {
        try {
            return ReferenceCountedOpenSslContext.toBIO(ByteBufAllocator.DEFAULT, x509Certificate);
        }
        catch (Exception exception) {
            PlatformDependent.throwException(exception);
            throw new AssertionError((Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Object object;
        logger = InternalLoggerFactory.getInstance(OpenSsl.class);
        DEFAULT_NAMED_GROUPS = new String[]{"x25519", "secp256r1", "secp384r1", "secp521r1"};
        Throwable throwable = null;
        if (SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.noOpenSsl", false)) {
            throwable = new UnsupportedOperationException("OpenSSL was explicit disabled with -Dio.netty.handler.ssl.noOpenSsl=true");
            logger.debug("netty-tcnative explicit disabled; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.", throwable);
        } else {
            try {
                Class.forName("com.gradle.scan.plugin.internal.dep.io.netty.internal.tcnative.SSLContext", false, PlatformDependent.getClassLoader(OpenSsl.class));
            }
            catch (ClassNotFoundException classNotFoundException) {
                throwable = classNotFoundException;
                logger.debug("netty-tcnative not in the classpath; " + OpenSslEngine.class.getSimpleName() + " will be unavailable.");
            }
            if (throwable == null) {
                try {
                    OpenSsl.loadTcNative();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    logger.debug("Failed to load netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable, unless the application has already loaded the symbols by some other means. See https://netty.io/wiki/forked-tomcat-native.html for more information.", throwable2);
                }
                try {
                    object = SystemPropertyUtil.get("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.engine", null);
                    if (object == null) {
                        logger.debug("Initialize netty-tcnative using engine: 'default'");
                    } else {
                        logger.debug("Initialize netty-tcnative using engine: '{}'", object);
                    }
                    OpenSsl.initializeTcNative((String)object);
                    throwable = null;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    }
                    logger.debug("Failed to initialize netty-tcnative; " + OpenSslEngine.class.getSimpleName() + " will be unavailable. See https://netty.io/wiki/forked-tomcat-native.html for more information.", throwable3);
                }
            }
        }
        UNAVAILABILITY_CAUSE = throwable;
        CLIENT_DEFAULT_PROTOCOLS = OpenSsl.defaultProtocols("jdk.tls.client.protocols");
        SERVER_DEFAULT_PROTOCOLS = OpenSsl.defaultProtocols("jdk.tls.server.protocols");
        if (throwable == null) {
            boolean bl2;
            logger.debug("netty-tcnative using native library: {}", (Object)SSL.versionString());
            object = new ArrayList();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(128);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            String[] stringArray = DEFAULT_NAMED_GROUPS;
            String string = OpenSsl.versionString();
            IS_BORINGSSL = "BoringSSL".equals(string);
            IS_AWSLC = string != null && string.startsWith("AWS-LC");
            LinkedHashSet<String> linkedHashSet2 = new LinkedHashSet<String>(stringArray.length);
            if (IS_BORINGSSL || IS_AWSLC) {
                linkedHashSet2.add("X25519MLKEM768");
            }
            for (String string2 : stringArray) {
                linkedHashSet2.add(GroupsConverter.toOpenSsl(string2));
            }
            if (IS_BORINGSSL) {
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS = new String[]{"TLS_AES_128_GCM_SHA256", "TLS_AES_256_GCM_SHA384", "TLS_CHACHA20_POLY1305_SHA256"};
                StringBuilder stringBuilder = new StringBuilder(128);
                for (String string3 : EXTRA_SUPPORTED_TLS_1_3_CIPHERS) {
                    stringBuilder.append(string3).append(':');
                }
                stringBuilder.setLength(stringBuilder.length() - 1);
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = stringBuilder.toString();
            } else {
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
                EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = "";
            }
            try {
                long l2 = SSLContext.make((int)63, (int)1);
                Iterator iterator = linkedHashSet2.iterator();
                while (iterator.hasNext()) {
                    if (SSLContext.setCurvesList((long)l2, (String[])new String[]{(String)iterator.next()})) continue;
                    iterator.remove();
                    SSL.clearError();
                }
                stringArray = linkedHashSet2.toArray(EmptyArrays.EMPTY_STRINGS);
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                try {
                    Object[] objectArray;
                    if (SslProvider.isTlsv13Supported(SslProvider.JDK)) {
                        try {
                            StringBuilder stringBuilder = new StringBuilder();
                            for (String object22 : SslUtils.TLSV13_CIPHERS) {
                                String exception = CipherSuiteConverter.toOpenSsl(object22, IS_BORINGSSL);
                                if (exception == null) continue;
                                stringBuilder.append(exception).append(':');
                            }
                            if (stringBuilder.length() == 0) {
                                bl5 = false;
                            } else {
                                stringBuilder.setLength(stringBuilder.length() - 1);
                                SSLContext.setCipherSuite((long)l2, (String)stringBuilder.toString(), (boolean)true);
                                bl5 = true;
                            }
                        }
                        catch (Exception exception) {
                            bl5 = false;
                            SSL.clearError();
                        }
                    }
                    SSLContext.setCipherSuite((long)l2, (String)"ALL", (boolean)false);
                    long l7 = SSL.newSSL((long)l2, (boolean)true);
                    try {
                        for (String string2 : SSL.getCiphers((long)l7)) {
                            if (string2 == null || string2.isEmpty() || linkedHashSet.contains(string2) || !bl5 && SslUtils.isTLSv13Cipher(string2)) continue;
                            linkedHashSet.add(string2);
                        }
                        if (IS_BORINGSSL) {
                            Collections.addAll(linkedHashSet, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
                            Collections.addAll(linkedHashSet, "AEAD-AES128-GCM-SHA256", "AEAD-AES256-GCM-SHA384", "AEAD-CHACHA20-POLY1305-SHA256");
                        }
                        PemPrivateKey pemPrivateKey = PemPrivateKey.valueOf("-----BEGIN PRIVATE KEY-----\nMIIEvQIBADANBgkqhkiG9w0BAQEFAASCBKcwggSjAgEAAoIBAQCCBtayYNDrM3NFnkBbwTd6gaWp\na84ENvkWzWgFGtVAe5iZUChqrAPNdgnQs7Brb3cCBYRDWOlxtnaGmhhDOoRkFMucWEyuFEWUfops\nk0PxjfeRn+JJUEEO4Zt1JslKGUz7hbBD0gCyjgxni9bdLWK/l8YakuBu1dGYF/9FTyiY3QaKOW9a\nUtYdaKMs3zFC3JIW4FDuyxbxFwoBqvLelSbpRRAH4KjqWd+2LRPNqDw+COEAmrZnfBuwZGc/ZhK9\nihorqrOYddFiWn8/GuMEBkCaQsmzhhOb9cUX5+R5jHiL3OodvKid7nJ6tGJuwdpdlYudQv6sWh4x\n0q+vRVLewaaFAgMBAAECggEAP8tPJvFtTxhNJAkCloHz0D0vpDHqQBMgntlkgayqmBqLwhyb18pR\ni0qwgh7HHc7wWqOOQuSqlEnrWRrdcI6TSe8R/sErzfTQNoznKWIPYcI/hskk4sdnQ//Yn9/Jvnsv\nU/BBjOTJxtD+sQbhAl80JcA3R+5sArURQkfzzHOL/YMqzAsn5hTzp7HZCxUqBk3KaHRxV7NefeOE\nxlZuWSmxYWfbFIs4kx19/1t7h8CHQWezw+G60G2VBtSBBxDnhBWvqG6R/wpzJ3nEhPLLY9T+XIHe\nipzdMOOOUZorfIg7M+pyYPji+ZIZxIpY5OjrOzXHciAjRtr5Y7l99K1CG1LguQKBgQDrQfIMxxtZ\nvxU/1cRmUV9l7pt5bjV5R6byXq178LxPKVYNjdZ840Q0/OpZEVqaT1xKVi35ohP1QfNjxPLlHD+K\niDAR9z6zkwjIrbwPCnb5kuXy4lpwPcmmmkva25fI7qlpHtbcuQdoBdCfr/KkKaUCMPyY89LCXgEw\n5KTDj64UywKBgQCNfbO+eZLGzhiHhtNJurresCsIGWlInv322gL8CSfBMYl6eNfUTZvUDdFhPISL\nUljKWzXDrjw0ujFSPR0XhUGtiq89H+HUTuPPYv25gVXO+HTgBFZEPl4PpA+BUsSVZy0NddneyqLk\n42Wey9omY9Q8WsdNQS5cbUvy0uG6WFoX7wKBgQDZ1jpW8pa0x2bZsQsm4vo+3G5CRnZlUp+XlWt2\ndDcp5dC0xD1zbs1dc0NcLeGDOTDv9FSl7hok42iHXXq8AygjEm/QcuwwQ1nC2HxmQP5holAiUs4D\nWHM8PWs3wFYPzE459EBoKTxeaeP/uWAn+he8q7d5uWvSZlEcANs/6e77eQKBgD21Ar0hfFfj7mK8\n9E0FeRZBsqK3omkfnhcYgZC11Xa2SgT1yvs2Va2n0RcdM5kncr3eBZav2GYOhhAdwyBM55XuE/sO\neokDVutNeuZ6d5fqV96TRaRBpvgfTvvRwxZ9hvKF4Vz+9wfn/JvCwANaKmegF6ejs7pvmF3whq2k\ndrZVAoGAX5YxQ5XMTD0QbMAl7/6qp6S58xNoVdfCkmkj1ZLKaHKIjS/benkKGlySVQVPexPfnkZx\np/Vv9yyphBoudiTBS9Uog66ueLYZqpgxlM/6OhYg86Gm3U2ycvMxYjBM1NFiyze21AqAhI+HX+Ot\nmraV2/guSgDgZAhukRZzeQ2RucI=\n-----END PRIVATE KEY-----".getBytes(CharsetUtil.US_ASCII));
                        try {
                            SSLContext.setCertificateCallback((long)l2, null);
                            objectArray = OpenSsl.selfSignedCertificate();
                            l3 = LeakPresenceDetector.staticInitializer(() -> OpenSsl.lambda$static$0((java.security.cert.X509Certificate)objectArray));
                            l5 = SSL.parseX509Chain((long)l3);
                            l4 = LeakPresenceDetector.staticInitializer(() -> {
                                try {
                                    return ReferenceCountedOpenSslContext.toBIO((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, pemPrivateKey.retain());
                                }
                                catch (Exception exception) {
                                    PlatformDependent.throwException(exception);
                                    throw new AssertionError((Object)exception);
                                }
                            });
                            l6 = SSL.parsePrivateKey((long)l4, null);
                            SSL.setKeyMaterial((long)l7, (long)l5, (long)l6);
                            bl3 = true;
                            try {
                                int n2 = SystemPropertyUtil.contains("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.useKeyManagerFactory") ? 1 : 0;
                                if (!IS_BORINGSSL && !IS_AWSLC) {
                                    bl4 = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.openssl.useKeyManagerFactory", true);
                                    if (n2 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and so will be ignored in the future");
                                    }
                                } else {
                                    bl4 = true;
                                    if (n2 != 0) {
                                        logger.info("System property 'io.netty.handler.ssl.openssl.useKeyManagerFactory' is deprecated and will be ignored when using BoringSSL or AWS-LC");
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                logger.debug("Failed to get useKeyManagerFactory system property.");
                            }
                        }
                        catch (Exception exception) {
                            logger.debug("KeyManagerFactory not supported", exception);
                            SSL.clearError();
                        }
                        finally {
                            pemPrivateKey.release();
                        }
                    }
                    finally {
                        SSL.freeSSL((long)l7);
                        if (l3 != 0L) {
                            SSL.freeBIO((long)l3);
                        }
                        if (l4 != 0L) {
                            SSL.freeBIO((long)l4);
                        }
                        if (l5 != 0L) {
                            SSL.freeX509Chain((long)l5);
                        }
                        if (l6 != 0L) {
                            SSL.freePrivateKey((long)l6);
                        }
                    }
                    String string3 = SystemPropertyUtil.get("jdk.tls.namedGroups", null);
                    if (string3 != null) {
                        objectArray = string3.split(",");
                        LinkedHashSet<String> linkedHashSet3 = new LinkedHashSet<String>(objectArray.length);
                        LinkedHashSet<String> linkedHashSet4 = new LinkedHashSet<String>(objectArray.length);
                        LinkedHashSet<String> linkedHashSet5 = new LinkedHashSet<String>();
                        for (String string4 : objectArray) {
                            String string5 = GroupsConverter.toOpenSsl(string4);
                            if (SSLContext.setCurvesList((long)l2, (String[])new String[]{string5})) {
                                linkedHashSet4.add(string5);
                                linkedHashSet3.add(string4);
                                continue;
                            }
                            linkedHashSet5.add(string4);
                            SSL.clearError();
                        }
                        if (linkedHashSet3.isEmpty()) {
                            stringArray = linkedHashSet2.toArray(EmptyArrays.EMPTY_STRINGS);
                            logger.info("All configured namedGroups are not supported: {}. Use default: {}.", (Object)Arrays.toString(linkedHashSet5.toArray(EmptyArrays.EMPTY_STRINGS)), (Object)Arrays.toString(DEFAULT_NAMED_GROUPS));
                        } else {
                            Object[] objectArray2 = linkedHashSet3.toArray(EmptyArrays.EMPTY_STRINGS);
                            if (linkedHashSet5.isEmpty()) {
                                logger.info("Using configured namedGroups -D 'jdk.tls.namedGroup': {} ", (Object)Arrays.toString(objectArray2));
                            } else {
                                logger.info("Using supported configured namedGroups: {}. Unsupported namedGroups: {}. ", (Object)Arrays.toString(objectArray2), (Object)Arrays.toString(linkedHashSet5.toArray(EmptyArrays.EMPTY_STRINGS)));
                            }
                            stringArray = linkedHashSet4.toArray(EmptyArrays.EMPTY_STRINGS);
                        }
                    } else {
                        stringArray = linkedHashSet2.toArray(EmptyArrays.EMPTY_STRINGS);
                    }
                }
                finally {
                    SSLContext.free((long)l2);
                }
            }
            catch (Exception exception) {
                logger.warn("Failed to get the list of available OpenSSL cipher suites.", exception);
            }
            NAMED_GROUPS = stringArray;
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet);
            LinkedHashSet<String> linkedHashSet5 = new LinkedHashSet<String>(AVAILABLE_OPENSSL_CIPHER_SUITES.size() * 2);
            for (String string7 : AVAILABLE_OPENSSL_CIPHER_SUITES) {
                if (!SslUtils.isTLSv13Cipher(string7)) {
                    String string3;
                    String string8 = CipherSuiteConverter.toJava(string7, "TLS");
                    if (string8 != null) {
                        linkedHashSet5.add(string8);
                    }
                    if ((string3 = CipherSuiteConverter.toJava(string7, "SSL")) == null) continue;
                    linkedHashSet5.add(string3);
                    continue;
                }
                linkedHashSet5.add(string7);
            }
            SslUtils.addIfSupported(linkedHashSet5, (List<String>)object, SslUtils.DEFAULT_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet5, (List<String>)object, SslUtils.TLSV13_CIPHER_SUITES);
            SslUtils.addIfSupported(linkedHashSet5, (List<String>)object, EXTRA_SUPPORTED_TLS_1_3_CIPHERS);
            SslUtils.useFallbackCiphersIfDefaultIsEmpty((List<String>)object, linkedHashSet5);
            DEFAULT_CIPHERS = Collections.unmodifiableList(object);
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.unmodifiableSet(linkedHashSet5);
            LinkedHashSet linkedHashSet6 = new LinkedHashSet(AVAILABLE_OPENSSL_CIPHER_SUITES.size() + AVAILABLE_JAVA_CIPHER_SUITES.size());
            linkedHashSet6.addAll(AVAILABLE_OPENSSL_CIPHER_SUITES);
            linkedHashSet6.addAll(AVAILABLE_JAVA_CIPHER_SUITES);
            AVAILABLE_CIPHER_SUITES = linkedHashSet6;
            SUPPORTS_KEYMANAGER_FACTORY = bl3;
            USE_KEYMANAGER_FACTORY = bl4;
            int n3 = 0;
            n3 |= 1;
            if (OpenSsl.doesSupportProtocol(1, SSL.SSL_OP_NO_SSLv2)) {
                n3 |= 2;
            }
            if (OpenSsl.doesSupportProtocol(2, SSL.SSL_OP_NO_SSLv3)) {
                n3 |= 4;
            }
            if (OpenSsl.doesSupportProtocol(4, SSL.SSL_OP_NO_TLSv1)) {
                n3 |= 8;
            }
            if (OpenSsl.doesSupportProtocol(8, SSL.SSL_OP_NO_TLSv1_1)) {
                n3 |= 0x10;
            }
            if (OpenSsl.doesSupportProtocol(16, SSL.SSL_OP_NO_TLSv1_2)) {
                n3 |= 0x20;
            }
            if (bl5 && OpenSsl.doesSupportProtocol(32, SSL.SSL_OP_NO_TLSv1_3)) {
                n3 |= 0x40;
                TLSV13_SUPPORTED = true;
            } else {
                TLSV13_SUPPORTED = false;
            }
            supportedProtocolsPacked = n3;
            SUPPORTS_OCSP = OpenSsl.doesSupportOcsp();
            if (logger.isDebugEnabled()) {
                logger.debug("Supported protocols (OpenSSL): {} ", (Object)OpenSsl.unpackSupportedProtocols());
                logger.debug("Default cipher suites (OpenSSL): {}", (Object)DEFAULT_CIPHERS);
            }
            try {
                X509Certificate.getInstance("-----BEGIN CERTIFICATE-----\nMIICrjCCAZagAwIBAgIIdSvQPv1QAZQwDQYJKoZIhvcNAQELBQAwFjEUMBIGA1UEAxMLZXhhbXBs\nZS5jb20wIBcNMTgwNDA2MjIwNjU5WhgPOTk5OTEyMzEyMzU5NTlaMBYxFDASBgNVBAMTC2V4YW1w\nbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAggbWsmDQ6zNzRZ5AW8E3eoGl\nqWvOBDb5Fs1oBRrVQHuYmVAoaqwDzXYJ0LOwa293AgWEQ1jpcbZ2hpoYQzqEZBTLnFhMrhRFlH6K\nbJND8Y33kZ/iSVBBDuGbdSbJShlM+4WwQ9IAso4MZ4vW3S1iv5fGGpLgbtXRmBf/RU8omN0Gijlv\nWlLWHWijLN8xQtySFuBQ7ssW8RcKAary3pUm6UUQB+Co6lnfti0Tzag8PgjhAJq2Z3wbsGRnP2YS\nvYoaK6qzmHXRYlp/PxrjBAZAmkLJs4YTm/XFF+fkeYx4i9zqHbyone5yerRibsHaXZWLnUL+rFoe\nMdKvr0VS3sGmhQIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQADQi441pKmXf9FvUV5EHU4v8nJT9Iq\nyqwsKwXnr7AsUlDGHBD7jGrjAXnG5rGxuNKBQ35wRxJATKrUtyaquFUL6H8O6aGQehiFTk6zmPbe\n12Gu44vqqTgIUxnv3JQJiox8S2hMxsSddpeCmSdvmalvD6WG4NthH6B9ZaBEiep1+0s0RUaBYn73\nI7CCUaAtbjfR6pcJjrFk5ei7uwdQZFSJtkP2z8r7zfeANJddAKFlkaMWn7u+OIVuB4XPooWicObk\nNAHFtP65bocUYnDpTVdiyvn8DdqyZ/EO8n1bBKBzuSLplk2msW4pdgaFgY7Vw/0wzcFXfUXmL1uy\nG8sQD/wx\n-----END CERTIFICATE-----".getBytes(CharsetUtil.US_ASCII));
                bl2 = true;
            }
            catch (CertificateException certificateException) {
                bl2 = false;
            }
            JAVAX_CERTIFICATE_CREATION_SUPPORTED = bl2;
        } else {
            DEFAULT_CIPHERS = Collections.emptyList();
            AVAILABLE_OPENSSL_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_JAVA_CIPHER_SUITES = Collections.emptySet();
            AVAILABLE_CIPHER_SUITES = Collections.emptySet();
            SUPPORTS_KEYMANAGER_FACTORY = false;
            USE_KEYMANAGER_FACTORY = false;
            SUPPORTS_OCSP = false;
            TLSV13_SUPPORTED = false;
            supportedProtocolsPacked = 0;
            IS_BORINGSSL = false;
            IS_AWSLC = false;
            EXTRA_SUPPORTED_TLS_1_3_CIPHERS = EmptyArrays.EMPTY_STRINGS;
            EXTRA_SUPPORTED_TLS_1_3_CIPHERS_STRING = "";
            NAMED_GROUPS = DEFAULT_NAMED_GROUPS;
            JAVAX_CERTIFICATE_CREATION_SUPPORTED = false;
        }
    }
}

