/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultHttpMessage;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMessageUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;

public class DefaultHttpRequest
extends DefaultHttpMessage
implements HttpRequest {
    private HttpMethod method;
    private String uri;

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string) {
        this(httpVersion, httpMethod, string, DefaultHttpHeadersFactory.headersFactory().newHeaders());
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeaders httpHeaders) {
        this(httpVersion, httpMethod, string, httpHeaders, true);
    }

    public DefaultHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, HttpHeaders httpHeaders, boolean bl2) {
        super(httpVersion, httpHeaders);
        this.method = ObjectUtil.checkNotNull(httpMethod, "method");
        this.uri = ObjectUtil.checkNotNull(string, "uri");
        if (bl2) {
            HttpUtil.validateRequestLineTokens(httpMethod, string);
        }
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + this.method.hashCode();
        n2 = 31 * n2 + this.uri.hashCode();
        n2 = 31 * n2 + super.hashCode();
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultHttpRequest)) {
            return false;
        }
        DefaultHttpRequest defaultHttpRequest = (DefaultHttpRequest)object;
        return this.method().equals(defaultHttpRequest.method()) && this.uri().equalsIgnoreCase(defaultHttpRequest.uri()) && super.equals(object);
    }

    public String toString() {
        return HttpMessageUtil.appendRequest(new StringBuilder(256), this).toString();
    }
}

