/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.DefaultHttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.FullHttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeadersFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMessageUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpMethod;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;

public class DefaultFullHttpRequest
extends DefaultHttpRequest
implements FullHttpRequest {
    private final ByteBuf content;
    private final HttpHeaders trailingHeader;
    private int hash;

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf) {
        this(httpVersion, httpMethod, string, byteBuf, DefaultHttpHeadersFactory.headersFactory(), DefaultHttpHeadersFactory.trailersFactory());
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, HttpHeadersFactory httpHeadersFactory, HttpHeadersFactory httpHeadersFactory2) {
        this(httpVersion, httpMethod, string, byteBuf, httpHeadersFactory.newHeaders(), httpHeadersFactory2.newHeaders());
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2) {
        this(httpVersion, httpMethod, string, byteBuf, httpHeaders, httpHeaders2, true);
    }

    public DefaultFullHttpRequest(HttpVersion httpVersion, HttpMethod httpMethod, String string, ByteBuf byteBuf, HttpHeaders httpHeaders, HttpHeaders httpHeaders2, boolean bl2) {
        super(httpVersion, httpMethod, string, httpHeaders, bl2);
        this.content = ObjectUtil.checkNotNull(byteBuf, "content");
        this.trailingHeader = ObjectUtil.checkNotNull(httpHeaders2, "trailingHeader");
    }

    @Override
    public HttpHeaders trailingHeaders() {
        return this.trailingHeader;
    }

    @Override
    public ByteBuf content() {
        return this.content;
    }

    @Override
    public int refCnt() {
        return this.content.refCnt();
    }

    @Override
    public FullHttpRequest retain() {
        this.content.retain();
        return this;
    }

    @Override
    public FullHttpRequest touch() {
        this.content.touch();
        return this;
    }

    @Override
    public FullHttpRequest touch(Object object) {
        this.content.touch(object);
        return this;
    }

    @Override
    public boolean release() {
        return this.content.release();
    }

    @Override
    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            if (ByteBufUtil.isAccessible(this.content())) {
                try {
                    n2 = 31 + this.content().hashCode();
                }
                catch (IllegalReferenceCountException illegalReferenceCountException) {
                    n2 = 31;
                }
            } else {
                n2 = 31;
            }
            n2 = 31 * n2 + this.trailingHeaders().hashCode();
            this.hash = n2 = 31 * n2 + super.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DefaultFullHttpRequest)) {
            return false;
        }
        DefaultFullHttpRequest defaultFullHttpRequest = (DefaultFullHttpRequest)object;
        return super.equals(defaultFullHttpRequest) && this.content().equals(defaultFullHttpRequest.content()) && this.trailingHeaders().equals(defaultFullHttpRequest.trailingHeaders());
    }

    @Override
    public String toString() {
        return HttpMessageUtil.appendFullRequest(new StringBuilder(256), this).toString();
    }
}

