/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ByteBufChecksum;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.DecompressionException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZlibDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.compression.ZlibWrapper;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class JdkZlibDecoder
extends ZlibDecoder {
    private Inflater inflater;
    private final byte[] dictionary;
    private final ByteBufChecksum crc;
    private final boolean decompressConcatenated;
    private GzipState gzipState = GzipState.HEADER_START;
    private int flags = -1;
    private int xlen = -1;
    private boolean needsRead;
    private volatile boolean finished;
    private boolean decideZlibOrNone;

    @Deprecated
    public JdkZlibDecoder() {
        this(ZlibWrapper.ZLIB, null, false, 0);
    }

    public JdkZlibDecoder(ZlibWrapper zlibWrapper, boolean bl2, int n2) {
        this(zlibWrapper, null, bl2, n2);
    }

    private JdkZlibDecoder(ZlibWrapper zlibWrapper, byte[] byArray, boolean bl2, int n2) {
        super(n2);
        ObjectUtil.checkNotNull(zlibWrapper, "wrapper");
        this.decompressConcatenated = bl2;
        switch (zlibWrapper) {
            case GZIP: {
                this.inflater = new Inflater(true);
                this.crc = ByteBufChecksum.wrapChecksum(new CRC32());
                break;
            }
            case NONE: {
                this.inflater = new Inflater(true);
                this.crc = null;
                break;
            }
            case ZLIB: {
                this.inflater = new Inflater();
                this.crc = null;
                break;
            }
            case ZLIB_OR_NONE: {
                this.decideZlibOrNone = true;
                this.crc = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only GZIP or ZLIB is supported, but you used " + (Object)((Object)zlibWrapper));
            }
        }
        this.dictionary = byArray;
    }

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) throws Exception {
        this.needsRead = true;
        if (this.finished) {
            byteBuf.skipBytes(byteBuf.readableBytes());
            return;
        }
        int n2 = byteBuf.readableBytes();
        if (n2 == 0) {
            return;
        }
        if (this.decideZlibOrNone) {
            if (n2 < 2) {
                return;
            }
            boolean bl2 = !JdkZlibDecoder.looksLikeZlib(byteBuf.getShort(byteBuf.readerIndex()));
            this.inflater = new Inflater(bl2);
            this.decideZlibOrNone = false;
        }
        if (this.crc != null && this.gzipState != GzipState.HEADER_END) {
            if (this.gzipState == GzipState.FOOTER_START) {
                if (!this.handleGzipFooter(byteBuf)) {
                    return;
                }
                assert (this.gzipState == GzipState.HEADER_START);
            }
            if (!this.readGZIPHeader(byteBuf)) {
                return;
            }
            n2 = byteBuf.readableBytes();
            if (n2 == 0) {
                return;
            }
        }
        if (this.inflater.needsInput()) {
            if (byteBuf.hasArray()) {
                this.inflater.setInput(byteBuf.array(), byteBuf.arrayOffset() + byteBuf.readerIndex(), n2);
            } else {
                byte[] byArray = new byte[n2];
                byteBuf.getBytes(byteBuf.readerIndex(), byArray);
                this.inflater.setInput(byArray);
            }
        }
        ByteBuf byteBuf2 = this.prepareDecompressBuffer(channelHandlerContext, null, this.inflater.getRemaining() << 1);
        try {
            boolean bl3 = false;
            while (!this.inflater.needsInput()) {
                int n3;
                byte[] byArray = byteBuf2.array();
                int n4 = byteBuf2.writerIndex();
                int n5 = byteBuf2.arrayOffset() + n4;
                int n6 = this.inflater.inflate(byArray, n5, n3 = byteBuf2.writableBytes());
                if (n6 > 0) {
                    byteBuf2.writerIndex(n4 + n6);
                    if (this.crc != null) {
                        this.crc.update(byArray, n5, n6);
                    }
                    if (this.maxAllocation == 0) {
                        ByteBuf byteBuf3 = byteBuf2;
                        byteBuf2 = null;
                        this.needsRead = false;
                        channelHandlerContext.fireChannelRead(byteBuf3);
                    }
                } else if (this.inflater.needsDictionary()) {
                    if (this.dictionary == null) {
                        throw new DecompressionException("decompression failure, unable to set dictionary as non was specified");
                    }
                    this.inflater.setDictionary(this.dictionary);
                }
                if (this.inflater.finished()) {
                    if (this.crc == null) {
                        this.finished = true;
                        break;
                    }
                    bl3 = true;
                    break;
                }
                byteBuf2 = this.prepareDecompressBuffer(channelHandlerContext, byteBuf2, this.inflater.getRemaining() << 1);
            }
            byteBuf.skipBytes(n2 - this.inflater.getRemaining());
            if (bl3) {
                this.gzipState = GzipState.FOOTER_START;
                this.handleGzipFooter(byteBuf);
            }
        }
        catch (DataFormatException dataFormatException) {
            throw new DecompressionException("decompression failure", dataFormatException);
        }
        finally {
            if (byteBuf2 != null) {
                if (byteBuf2.isReadable()) {
                    this.needsRead = false;
                    channelHandlerContext.fireChannelRead(byteBuf2);
                } else {
                    byteBuf2.release();
                }
            }
        }
    }

    private boolean handleGzipFooter(ByteBuf byteBuf) {
        if (this.readGZIPFooter(byteBuf)) {
            boolean bl2 = this.finished = !this.decompressConcatenated;
            if (!this.finished) {
                this.inflater.reset();
                this.crc.reset();
                this.gzipState = GzipState.HEADER_START;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void decompressionBufferExhausted(ByteBuf byteBuf) {
        this.finished = true;
    }

    @Override
    protected void handlerRemoved0(ChannelHandlerContext channelHandlerContext) throws Exception {
        super.handlerRemoved0(channelHandlerContext);
        if (this.inflater != null) {
            this.inflater.end();
        }
    }

    private boolean readGZIPHeader(ByteBuf byteBuf) {
        switch (this.gzipState) {
            case HEADER_START: {
                if (byteBuf.readableBytes() < 10) {
                    return false;
                }
                byte by2 = byteBuf.readByte();
                byte by3 = byteBuf.readByte();
                if (by2 != 31) {
                    throw new DecompressionException("Input is not in the GZIP format");
                }
                this.crc.update(by2);
                this.crc.update(by3);
                short s2 = byteBuf.readUnsignedByte();
                if (s2 != 8) {
                    throw new DecompressionException("Unsupported compression method " + s2 + " in the GZIP header");
                }
                this.crc.update(s2);
                this.flags = byteBuf.readUnsignedByte();
                this.crc.update(this.flags);
                if ((this.flags & 0xE0) != 0) {
                    throw new DecompressionException("Reserved flags are set in the GZIP header");
                }
                this.crc.update(byteBuf, byteBuf.readerIndex(), 4);
                byteBuf.skipBytes(4);
                this.crc.update(byteBuf.readUnsignedByte());
                this.crc.update(byteBuf.readUnsignedByte());
                this.gzipState = GzipState.FLG_READ;
            }
            case FLG_READ: {
                if ((this.flags & 4) != 0) {
                    if (byteBuf.readableBytes() < 2) {
                        return false;
                    }
                    short s3 = byteBuf.readUnsignedByte();
                    short s4 = byteBuf.readUnsignedByte();
                    this.crc.update(s3);
                    this.crc.update(s4);
                    this.xlen |= s3 << 8 | s4;
                }
                this.gzipState = GzipState.XLEN_READ;
            }
            case XLEN_READ: {
                if (this.xlen != -1) {
                    if (byteBuf.readableBytes() < this.xlen) {
                        return false;
                    }
                    this.crc.update(byteBuf, byteBuf.readerIndex(), this.xlen);
                    byteBuf.skipBytes(this.xlen);
                }
                this.gzipState = GzipState.SKIP_FNAME;
            }
            case SKIP_FNAME: {
                if (!this.skipIfNeeded(byteBuf, 8)) {
                    return false;
                }
                this.gzipState = GzipState.SKIP_COMMENT;
            }
            case SKIP_COMMENT: {
                if (!this.skipIfNeeded(byteBuf, 16)) {
                    return false;
                }
                this.gzipState = GzipState.PROCESS_FHCRC;
            }
            case PROCESS_FHCRC: {
                if ((this.flags & 2) != 0 && !this.verifyCrc16(byteBuf)) {
                    return false;
                }
                this.crc.reset();
                this.gzipState = GzipState.HEADER_END;
            }
            case HEADER_END: {
                return true;
            }
        }
        throw new IllegalStateException();
    }

    private boolean skipIfNeeded(ByteBuf byteBuf, int n2) {
        block2: {
            short s2;
            if ((this.flags & n2) == 0) break block2;
            do {
                if (!byteBuf.isReadable()) {
                    return false;
                }
                s2 = byteBuf.readUnsignedByte();
                this.crc.update(s2);
            } while (s2 != 0);
        }
        return true;
    }

    private boolean readGZIPFooter(ByteBuf byteBuf) {
        int n2;
        if (byteBuf.readableBytes() < 8) {
            return false;
        }
        boolean bl2 = this.verifyCrc(byteBuf);
        assert (bl2);
        int n3 = byteBuf.readIntLE();
        if (n3 != (n2 = this.inflater.getTotalOut())) {
            throw new DecompressionException("Number of bytes mismatch. Expected: " + n3 + ", Got: " + n2);
        }
        return true;
    }

    private boolean verifyCrc(ByteBuf byteBuf) {
        long l2;
        if (byteBuf.readableBytes() < 4) {
            return false;
        }
        long l3 = byteBuf.readUnsignedIntLE();
        if (l3 != (l2 = this.crc.getValue())) {
            throw new DecompressionException("CRC value mismatch. Expected: " + l3 + ", Got: " + l2);
        }
        return true;
    }

    private boolean verifyCrc16(ByteBuf byteBuf) {
        int n2;
        if (byteBuf.readableBytes() < 2) {
            return false;
        }
        int n3 = byteBuf.readUnsignedShortLE();
        if (n3 != (n2 = (int)(this.crc.getValue() & 0xFFFFL))) {
            throw new DecompressionException("CRC16 value mismatch. Expected: " + n3 + ", Got: " + n2);
        }
        return true;
    }

    private static boolean looksLikeZlib(short s2) {
        return (s2 & 0x7800) == 30720 && s2 % 31 == 0;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) throws Exception {
        this.discardSomeReadBytes();
        if (this.needsRead && !channelHandlerContext.channel().config().isAutoRead()) {
            channelHandlerContext.read();
        }
        channelHandlerContext.fireChannelReadComplete();
    }

    private static enum GzipState {
        HEADER_START,
        HEADER_END,
        FLG_READ,
        XLEN_READ,
        SKIP_FNAME,
        SKIP_COMMENT,
        PROCESS_FHCRC,
        FOOTER_START;

    }
}

