/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.channel.nio;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelException;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.DefaultSelectStrategyFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoHandle;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoHandler;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoHandlerFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoOps;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.IoRegistration;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.SelectStrategy;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.SelectStrategyFactory;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.NioIoHandle;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.NioIoOps;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.SelectedSelectionKeySet;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.nio.SelectedSelectionKeySetSelector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.IntSupplier;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ThreadAwareExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ReflectionUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NioIoHandler
implements IoHandler {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(NioIoHandler.class);
    private static final boolean DISABLE_KEY_SET_OPTIMIZATION = SystemPropertyUtil.getBoolean("com.gradle.scan.plugin.internal.dep.io.netty.noKeySetOptimization", false);
    private static final int SELECTOR_AUTO_REBUILD_THRESHOLD;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return NioIoHandler.this.selectNow();
        }
    };
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final SelectorProvider provider;
    private final AtomicBoolean wakenUp = new AtomicBoolean();
    private final SelectStrategy selectStrategy;
    private final ThreadAwareExecutor executor;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    private NioIoHandler(ThreadAwareExecutor threadAwareExecutor, SelectorProvider selectorProvider, SelectStrategy selectStrategy) {
        this.executor = ObjectUtil.checkNotNull(threadAwareExecutor, "executionContext");
        this.provider = ObjectUtil.checkNotNull(selectorProvider, "selectorProvider");
        this.selectStrategy = ObjectUtil.checkNotNull(selectStrategy, "selectStrategy");
        SelectorTuple selectorTuple = this.openSelector();
        this.selector = selectorTuple.selector;
        this.unwrappedSelector = selectorTuple.unwrappedSelector;
    }

    private SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.provider.openSelector();
        }
        catch (IOException iOException) {
            throw new ChannelException("failed to open a new selector", iOException);
        }
        if (DISABLE_KEY_SET_OPTIMIZATION) {
            return new SelectorTuple(abstractSelector);
        }
        Object object = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    return Class.forName("sun.nio.ch.SelectorImpl", false, PlatformDependent.getSystemClassLoader());
                }
                catch (Throwable throwable) {
                    return throwable;
                }
            }
        });
        if (!(object instanceof Class) || !((Class)object).isAssignableFrom(abstractSelector.getClass())) {
            if (object instanceof Throwable) {
                Throwable throwable = (Throwable)object;
                logger.trace("failed to instrument a special java.util.Set into: {}", abstractSelector, throwable);
            }
            return new SelectorTuple(abstractSelector);
        }
        final Class clazz = (Class)object;
        final SelectedSelectionKeySet selectedSelectionKeySet = new SelectedSelectionKeySet();
        Object object2 = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Throwable throwable;
                    Field field = clazz.getDeclaredField("selectedKeys");
                    Field field2 = clazz.getDeclaredField("publicSelectedKeys");
                    if (PlatformDependent.javaVersion() >= 9 && PlatformDependent.hasUnsafe()) {
                        long l2 = PlatformDependent.objectFieldOffset(field);
                        long l3 = PlatformDependent.objectFieldOffset(field2);
                        if (l2 != -1L && l3 != -1L) {
                            PlatformDependent.putObject(abstractSelector, l2, selectedSelectionKeySet);
                            PlatformDependent.putObject(abstractSelector, l3, selectedSelectionKeySet);
                            return null;
                        }
                    }
                    if ((throwable = ReflectionUtil.trySetAccessible(field, true)) != null) {
                        return throwable;
                    }
                    throwable = ReflectionUtil.trySetAccessible(field2, true);
                    if (throwable != null) {
                        return throwable;
                    }
                    field.set(abstractSelector, selectedSelectionKeySet);
                    field2.set(abstractSelector, selectedSelectionKeySet);
                    return null;
                }
                catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                    return reflectiveOperationException;
                }
            }
        });
        if (object2 instanceof Exception) {
            this.selectedKeys = null;
            Exception exception = (Exception)object2;
            logger.trace("failed to instrument a special java.util.Set into: {}", abstractSelector, exception);
            return new SelectorTuple(abstractSelector);
        }
        this.selectedKeys = selectedSelectionKeySet;
        logger.trace("instrumented a special java.util.Set into: {}", abstractSelector);
        return new SelectorTuple(abstractSelector, new SelectedSelectionKeySetSelector(abstractSelector, selectedSelectionKeySet));
    }

    void rebuildSelector0() {
        int n2;
        block9: {
            SelectorTuple selectorTuple;
            Selector selector = this.selector;
            if (selector == null) {
                return;
            }
            try {
                selectorTuple = this.openSelector();
            }
            catch (Exception exception) {
                logger.warn("Failed to create a new Selector.", exception);
                return;
            }
            n2 = 0;
            for (SelectionKey selectionKey : selector.keys()) {
                DefaultNioRegistration defaultNioRegistration = (DefaultNioRegistration)selectionKey.attachment();
                try {
                    if (!selectionKey.isValid() || selectionKey.channel().keyFor(selectorTuple.unwrappedSelector) != null) continue;
                    defaultNioRegistration.register(selectorTuple.unwrappedSelector);
                    ++n2;
                }
                catch (Exception exception) {
                    logger.warn("Failed to re-register a NioHandle to the new Selector.", exception);
                    defaultNioRegistration.cancel();
                }
            }
            this.selector = selectorTuple.selector;
            this.unwrappedSelector = selectorTuple.unwrappedSelector;
            try {
                selector.close();
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block9;
                logger.warn("Failed to close the old Selector.", throwable);
            }
        }
        if (logger.isInfoEnabled()) {
            logger.info("Migrated " + n2 + " channel(s) to the new Selector.");
        }
    }

    private static NioIoHandle nioHandle(IoHandle ioHandle) {
        if (ioHandle instanceof NioIoHandle) {
            return (NioIoHandle)ioHandle;
        }
        throw new IllegalArgumentException("IoHandle of type " + StringUtil.simpleClassName(ioHandle) + " not supported");
    }

    private static NioIoOps cast(IoOps ioOps) {
        if (ioOps instanceof NioIoOps) {
            return (NioIoOps)ioOps;
        }
        throw new IllegalArgumentException("IoOps of type " + StringUtil.simpleClassName(ioOps) + " not supported");
    }

    @Override
    public IoRegistration register(IoHandle ioHandle) throws Exception {
        NioIoHandle nioIoHandle = NioIoHandler.nioHandle(ioHandle);
        NioIoOps nioIoOps = NioIoOps.NONE;
        boolean bl2 = false;
        while (true) {
            try {
                DefaultNioRegistration defaultNioRegistration = new DefaultNioRegistration(this.executor, nioIoHandle, nioIoOps, this.unwrappedSelector());
                ioHandle.registered();
                return defaultNioRegistration;
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!bl2) {
                    this.selectNow();
                    bl2 = true;
                    continue;
                }
                throw cancelledKeyException;
            }
            break;
        }
    }

    @Override
    public int run(IoHandlerContext ioHandlerContext) {
        int n2 = 0;
        try {
            try {
                switch (this.selectStrategy.calculateStrategy(this.selectNowSupplier, !ioHandlerContext.canBlock())) {
                    case -2: {
                        if (ioHandlerContext.shouldReportActiveIoTime()) {
                            ioHandlerContext.reportActiveIoTime(0L);
                        }
                        return 0;
                    }
                    case -3: 
                    case -1: {
                        this.select(ioHandlerContext, this.wakenUp.getAndSet(false));
                        if (!this.wakenUp.get()) break;
                        this.selector.wakeup();
                    }
                }
            }
            catch (IOException iOException) {
                this.rebuildSelector0();
                NioIoHandler.handleLoopException(iOException);
                return 0;
            }
            this.cancelledKeys = 0;
            this.needsToSelectAgain = false;
            if (ioHandlerContext.shouldReportActiveIoTime()) {
                long l2 = System.nanoTime();
                n2 = this.processSelectedKeys();
                long l3 = System.nanoTime();
                ioHandlerContext.reportActiveIoTime(l3 - l2);
            } else {
                n2 = this.processSelectedKeys();
            }
        }
        catch (Error error) {
            throw error;
        }
        catch (Throwable throwable) {
            NioIoHandler.handleLoopException(throwable);
        }
        return n2;
    }

    private static void handleLoopException(Throwable throwable) {
        logger.warn("Unexpected exception in the selector loop.", throwable);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private int processSelectedKeys() {
        if (this.selectedKeys != null) {
            return this.processSelectedKeysOptimized();
        }
        return this.processSelectedKeysPlain(this.selector.selectedKeys());
    }

    @Override
    public void destroy() {
        try {
            this.selector.close();
        }
        catch (IOException iOException) {
            logger.warn("Failed to close a selector.", iOException);
        }
    }

    private int processSelectedKeysPlain(Set<SelectionKey> set) {
        if (set.isEmpty()) {
            return 0;
        }
        Iterator<SelectionKey> iterator = set.iterator();
        int n2 = 0;
        while (true) {
            SelectionKey selectionKey = iterator.next();
            iterator.remove();
            this.processSelectedKey(selectionKey);
            ++n2;
            if (!iterator.hasNext()) break;
            if (!this.needsToSelectAgain) continue;
            this.selectAgain();
            set = this.selector.selectedKeys();
            if (set.isEmpty()) break;
            iterator = set.iterator();
        }
        return n2;
    }

    private int processSelectedKeysOptimized() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.selectedKeys.size; ++i2) {
            SelectionKey selectionKey = this.selectedKeys.keys[i2];
            this.selectedKeys.keys[i2] = null;
            this.processSelectedKey(selectionKey);
            ++n2;
            if (!this.needsToSelectAgain) continue;
            this.selectedKeys.reset(i2 + 1);
            this.selectAgain();
            i2 = -1;
        }
        return n2;
    }

    private void processSelectedKey(SelectionKey selectionKey) {
        DefaultNioRegistration defaultNioRegistration = (DefaultNioRegistration)selectionKey.attachment();
        if (!defaultNioRegistration.isValid()) {
            try {
                defaultNioRegistration.handle.close();
            }
            catch (Exception exception) {
                logger.debug("Exception during closing " + defaultNioRegistration.handle, exception);
            }
            return;
        }
        defaultNioRegistration.handle(selectionKey.readyOps());
    }

    @Override
    public void prepareToDestroy() {
        this.selectAgain();
        Set<SelectionKey> set = this.selector.keys();
        ArrayList<DefaultNioRegistration> arrayList = new ArrayList<DefaultNioRegistration>(set.size());
        for (SelectionKey object : set) {
            DefaultNioRegistration defaultNioRegistration = (DefaultNioRegistration)object.attachment();
            arrayList.add(defaultNioRegistration);
        }
        for (DefaultNioRegistration defaultNioRegistration : arrayList) {
            defaultNioRegistration.close();
        }
    }

    @Override
    public void wakeup() {
        if (!this.executor.isExecutorThread(Thread.currentThread()) && this.wakenUp.compareAndSet(false, true)) {
            this.selector.wakeup();
        }
    }

    @Override
    public boolean isCompatible(Class<? extends IoHandle> clazz) {
        return NioIoHandle.class.isAssignableFrom(clazz);
    }

    Selector unwrappedSelector() {
        return this.unwrappedSelector;
    }

    private void select(IoHandlerContext ioHandlerContext, boolean bl2) throws IOException {
        block14: {
            Selector selector = this.selector;
            try {
                int n2 = 0;
                long l2 = System.nanoTime();
                long l3 = ioHandlerContext.delayNanos(l2);
                long l4 = Long.MAX_VALUE;
                if (l3 != Long.MAX_VALUE) {
                    l4 = l2 + ioHandlerContext.delayNanos(l2);
                }
                while (true) {
                    long l5;
                    if (l3 != Long.MAX_VALUE) {
                        long l6 = NioIoHandler.millisBeforeDeadline(l4, l2);
                        if (l6 <= 0L) {
                            if (n2 != 0) break;
                            selector.selectNow();
                            n2 = 1;
                            break;
                        }
                        l5 = l6;
                    } else {
                        l5 = 0L;
                    }
                    if (!ioHandlerContext.canBlock() && this.wakenUp.compareAndSet(false, true)) {
                        selector.selectNow();
                        n2 = 1;
                        break;
                    }
                    int n3 = selector.select(l5);
                    ++n2;
                    if (n3 != 0 || bl2 || this.wakenUp.get() || !ioHandlerContext.canBlock()) break;
                    if (Thread.interrupted()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Selector.select() returned prematurely because Thread.currentThread().interrupt() was called. Use NioHandler.shutdownGracefully() to shutdown the NioHandler.");
                        }
                        n2 = 1;
                        break;
                    }
                    long l7 = System.nanoTime();
                    if (l7 - TimeUnit.MILLISECONDS.toNanos(l5) >= l2) {
                        n2 = 1;
                    } else if (SELECTOR_AUTO_REBUILD_THRESHOLD > 0 && n2 >= SELECTOR_AUTO_REBUILD_THRESHOLD) {
                        selector = this.selectRebuildSelector(n2);
                        n2 = 1;
                        break;
                    }
                    l2 = l7;
                }
                if (n2 > 3 && logger.isDebugEnabled()) {
                    logger.debug("Selector.select() returned prematurely {} times in a row for Selector {}.", (Object)(n2 - 1), (Object)selector);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                if (!logger.isDebugEnabled()) break block14;
                logger.debug(CancelledKeyException.class.getSimpleName() + " raised by a Selector {} - JDK bug?", (Object)selector, (Object)cancelledKeyException);
            }
        }
    }

    private static long millisBeforeDeadline(long l2, long l3) {
        assert (l2 != Long.MAX_VALUE);
        long l4 = l2 - l3;
        if (l4 >= 9223372036854275807L) {
            return 9223372036854L;
        }
        return (l4 + 500000L) / 1000000L;
    }

    int selectNow() throws IOException {
        try {
            int n2 = this.selector.selectNow();
            return n2;
        }
        finally {
            if (this.wakenUp.get()) {
                this.selector.wakeup();
            }
        }
    }

    private Selector selectRebuildSelector(int n2) throws IOException {
        logger.warn("Selector.select() returned prematurely {} times in a row; rebuilding Selector {}.", (Object)n2, (Object)this.selector);
        this.rebuildSelector0();
        Selector selector = this.selector;
        selector.selectNow();
        return selector;
    }

    private void selectAgain() {
        this.needsToSelectAgain = false;
        try {
            this.selector.selectNow();
        }
        catch (Throwable throwable) {
            logger.warn("Failed to update SelectionKeys.", throwable);
        }
    }

    public static IoHandlerFactory newFactory() {
        return NioIoHandler.newFactory(SelectorProvider.provider(), DefaultSelectStrategyFactory.INSTANCE);
    }

    public static IoHandlerFactory newFactory(final SelectorProvider selectorProvider, final SelectStrategyFactory selectStrategyFactory) {
        ObjectUtil.checkNotNull(selectorProvider, "selectorProvider");
        ObjectUtil.checkNotNull(selectStrategyFactory, "selectStrategyFactory");
        return new IoHandlerFactory(){

            @Override
            public IoHandler newHandler(ThreadAwareExecutor threadAwareExecutor) {
                return new NioIoHandler(threadAwareExecutor, selectorProvider, selectStrategyFactory.newSelectStrategy());
            }

            @Override
            public boolean isChangingThreadSupported() {
                return true;
            }
        };
    }

    static {
        int n2 = SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.selectorAutoRebuildThreshold", 512);
        if (n2 < 3) {
            n2 = 0;
        }
        SELECTOR_AUTO_REBUILD_THRESHOLD = n2;
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.noKeySetOptimization: {}", (Object)DISABLE_KEY_SET_OPTIMIZATION);
            logger.debug("-Dio.netty.selectorAutoRebuildThreshold: {}", (Object)SELECTOR_AUTO_REBUILD_THRESHOLD);
        }
    }

    final class DefaultNioRegistration
    implements IoRegistration {
        private final AtomicBoolean canceled = new AtomicBoolean();
        private final NioIoHandle handle;
        private volatile SelectionKey key;

        DefaultNioRegistration(ThreadAwareExecutor threadAwareExecutor, NioIoHandle nioIoHandle, NioIoOps nioIoOps, Selector selector) throws IOException {
            this.handle = nioIoHandle;
            this.key = nioIoHandle.selectableChannel().register(selector, nioIoOps.value, this);
        }

        void register(Selector selector) throws IOException {
            SelectionKey selectionKey = this.handle.selectableChannel().register(selector, this.key.interestOps(), this);
            this.key.cancel();
            this.key = selectionKey;
        }

        @Override
        public <T> T attachment() {
            return (T)this.key;
        }

        @Override
        public boolean isValid() {
            return !this.canceled.get() && this.key.isValid();
        }

        @Override
        public long submit(IoOps ioOps) {
            if (!this.isValid()) {
                return -1L;
            }
            int n2 = NioIoHandler.cast((IoOps)ioOps).value;
            this.key.interestOps(n2);
            return n2;
        }

        @Override
        public boolean cancel() {
            if (!this.canceled.compareAndSet(false, true)) {
                return false;
            }
            this.key.cancel();
            NioIoHandler.this.cancelledKeys++;
            if (NioIoHandler.this.cancelledKeys >= 256) {
                NioIoHandler.this.cancelledKeys = 0;
                NioIoHandler.this.needsToSelectAgain = true;
            }
            this.handle.unregistered();
            return true;
        }

        void close() {
            this.cancel();
            try {
                this.handle.close();
            }
            catch (Exception exception) {
                logger.debug("Exception during closing " + this.handle, exception);
            }
        }

        void handle(int n2) {
            if (!this.isValid()) {
                return;
            }
            this.handle.handle(this, NioIoOps.eventOf(n2));
        }
    }

    private static final class SelectorTuple {
        final Selector unwrappedSelector;
        final Selector selector;

        SelectorTuple(Selector selector) {
            this.unwrappedSelector = selector;
            this.selector = selector;
        }

        SelectorTuple(Selector selector, Selector selector2) {
            this.unwrappedSelector = selector;
            this.selector = selector2;
        }
    }
}

