/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.VarHandleByteBufferAccess;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;

final class HeapByteBufUtil {
    static byte getByte(byte[] byArray, int n2) {
        return byArray[n2];
    }

    static short getShort(byte[] byArray, int n2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getShortBE(byArray, n2);
        }
        return HeapByteBufUtil.getShort0(byArray, n2);
    }

    private static short getShort0(byte[] byArray, int n2) {
        return (short)(byArray[n2] << 8 | byArray[n2 + 1] & 0xFF);
    }

    static short getShortLE(byte[] byArray, int n2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getShortLE(byArray, n2);
        }
        return (short)(byArray[n2] & 0xFF | byArray[n2 + 1] << 8);
    }

    static int getUnsignedMedium(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 16 | (byArray[n2 + 1] & 0xFF) << 8 | byArray[n2 + 2] & 0xFF;
    }

    static int getUnsignedMediumLE(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16;
    }

    static int getInt(byte[] byArray, int n2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getIntBE(byArray, n2);
        }
        return HeapByteBufUtil.getInt0(byArray, n2);
    }

    private static int getInt0(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static int getIntLE(byte[] byArray, int n2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getIntLE(byArray, n2);
        }
        return HeapByteBufUtil.getIntLE0(byArray, n2);
    }

    private static int getIntLE0(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24;
    }

    static long getLong(byte[] byArray, int n2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getLongBE(byArray, n2);
        }
        return HeapByteBufUtil.getLong0(byArray, n2);
    }

    private static long getLong0(byte[] byArray, int n2) {
        return ((long)byArray[n2] & 0xFFL) << 56 | ((long)byArray[n2 + 1] & 0xFFL) << 48 | ((long)byArray[n2 + 2] & 0xFFL) << 40 | ((long)byArray[n2 + 3] & 0xFFL) << 32 | ((long)byArray[n2 + 4] & 0xFFL) << 24 | ((long)byArray[n2 + 5] & 0xFFL) << 16 | ((long)byArray[n2 + 6] & 0xFFL) << 8 | (long)byArray[n2 + 7] & 0xFFL;
    }

    static long getLongLE(byte[] byArray, int n2) {
        if (PlatformDependent.hasVarHandle()) {
            return VarHandleByteBufferAccess.getLongLE(byArray, n2);
        }
        return HeapByteBufUtil.getLongLE0(byArray, n2);
    }

    private static long getLongLE0(byte[] byArray, int n2) {
        return (long)byArray[n2] & 0xFFL | ((long)byArray[n2 + 1] & 0xFFL) << 8 | ((long)byArray[n2 + 2] & 0xFFL) << 16 | ((long)byArray[n2 + 3] & 0xFFL) << 24 | ((long)byArray[n2 + 4] & 0xFFL) << 32 | ((long)byArray[n2 + 5] & 0xFFL) << 40 | ((long)byArray[n2 + 6] & 0xFFL) << 48 | ((long)byArray[n2 + 7] & 0xFFL) << 56;
    }

    static void setByte(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 & 0xFF);
    }

    static void setShort(byte[] byArray, int n2, int n3) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setShortBE(byArray, n2, n3);
            return;
        }
        byArray[n2] = (byte)(n3 >>> 8);
        byArray[n2 + 1] = (byte)n3;
    }

    static void setMedium(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >>> 16);
        byArray[n2 + 1] = (byte)(n3 >>> 8);
        byArray[n2 + 2] = (byte)n3;
    }

    static void setInt(byte[] byArray, int n2, int n3) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setIntBE(byArray, n2, n3);
            return;
        }
        HeapByteBufUtil.setInt0(byArray, n2, n3);
    }

    private static void setInt0(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >>> 24);
        byArray[n2 + 1] = (byte)(n3 >>> 16);
        byArray[n2 + 2] = (byte)(n3 >>> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    static void setLong(byte[] byArray, int n2, long l2) {
        if (PlatformDependent.hasVarHandle()) {
            VarHandleByteBufferAccess.setLongBE(byArray, n2, l2);
            return;
        }
        HeapByteBufUtil.setLong0(byArray, n2, l2);
    }

    private static void setLong0(byte[] byArray, int n2, long l2) {
        byArray[n2] = (byte)(l2 >>> 56);
        byArray[n2 + 1] = (byte)(l2 >>> 48);
        byArray[n2 + 2] = (byte)(l2 >>> 40);
        byArray[n2 + 3] = (byte)(l2 >>> 32);
        byArray[n2 + 4] = (byte)(l2 >>> 24);
        byArray[n2 + 5] = (byte)(l2 >>> 16);
        byArray[n2 + 6] = (byte)(l2 >>> 8);
        byArray[n2 + 7] = (byte)l2;
    }
}

