/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AdvancedLeakAwareByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AdvancedLeakAwareCompositeByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBufAllocator;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.CompositeByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.EmptyByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.SimpleLeakAwareByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.SimpleLeakAwareCompositeByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakDetector;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.MathUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;

public abstract class AbstractByteBufAllocator
implements ByteBufAllocator {
    private final boolean directByDefault;
    private final ByteBuf emptyBuf;

    protected static ByteBuf toLeakAwareBuffer(ByteBuf byteBuf) {
        ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(byteBuf);
        if (resourceLeakTracker != null) {
            byteBuf = AbstractByteBuf.leakDetector.isRecordEnabled() ? new AdvancedLeakAwareByteBuf(byteBuf, resourceLeakTracker) : new SimpleLeakAwareByteBuf(byteBuf, resourceLeakTracker);
        }
        return byteBuf;
    }

    protected static CompositeByteBuf toLeakAwareBuffer(CompositeByteBuf compositeByteBuf) {
        ResourceLeakTracker<ByteBuf> resourceLeakTracker = AbstractByteBuf.leakDetector.track(compositeByteBuf);
        if (resourceLeakTracker != null) {
            compositeByteBuf = AbstractByteBuf.leakDetector.isRecordEnabled() ? new AdvancedLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeakTracker) : new SimpleLeakAwareCompositeByteBuf(compositeByteBuf, resourceLeakTracker);
        }
        return compositeByteBuf;
    }

    protected AbstractByteBufAllocator() {
        this(false);
    }

    protected AbstractByteBufAllocator(boolean bl2) {
        this.directByDefault = bl2 && PlatformDependent.canReliabilyFreeDirectBuffers();
        this.emptyBuf = new EmptyByteBuf(this);
    }

    @Override
    public ByteBuf buffer() {
        if (this.directByDefault) {
            return this.directBuffer();
        }
        return this.heapBuffer();
    }

    @Override
    public ByteBuf buffer(int n2) {
        if (this.directByDefault) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public ByteBuf buffer(int n2, int n3) {
        if (this.directByDefault) {
            return this.directBuffer(n2, n3);
        }
        return this.heapBuffer(n2, n3);
    }

    @Override
    public ByteBuf ioBuffer() {
        if (PlatformDependent.canReliabilyFreeDirectBuffers() || this.isDirectBufferPooled()) {
            return this.directBuffer(256);
        }
        return this.heapBuffer(256);
    }

    @Override
    public ByteBuf ioBuffer(int n2) {
        if (PlatformDependent.canReliabilyFreeDirectBuffers() || this.isDirectBufferPooled()) {
            return this.directBuffer(n2);
        }
        return this.heapBuffer(n2);
    }

    @Override
    public ByteBuf heapBuffer() {
        return this.heapBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n2) {
        return this.heapBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf heapBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n2, n3);
        return this.newHeapBuffer(n2, n3);
    }

    public ByteBuf directBuffer() {
        return this.directBuffer(256, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n2) {
        return this.directBuffer(n2, Integer.MAX_VALUE);
    }

    @Override
    public ByteBuf directBuffer(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return this.emptyBuf;
        }
        AbstractByteBufAllocator.validate(n2, n3);
        return this.newDirectBuffer(n2, n3);
    }

    @Override
    public CompositeByteBuf compositeBuffer(int n2) {
        if (this.directByDefault) {
            return this.compositeDirectBuffer(n2);
        }
        return this.compositeHeapBuffer(n2);
    }

    public CompositeByteBuf compositeHeapBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, false, n2));
    }

    public CompositeByteBuf compositeDirectBuffer(int n2) {
        return AbstractByteBufAllocator.toLeakAwareBuffer(new CompositeByteBuf(this, true, n2));
    }

    private static void validate(int n2, int n3) {
        ObjectUtil.checkPositiveOrZero(n2, "initialCapacity");
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("initialCapacity: %d (expected: not greater than maxCapacity(%d)", n2, n3));
        }
    }

    protected abstract ByteBuf newHeapBuffer(int var1, int var2);

    protected abstract ByteBuf newDirectBuffer(int var1, int var2);

    public String toString() {
        return StringUtil.simpleClassName(this) + "(directByDefault: " + this.directByDefault + ')';
    }

    @Override
    public int calculateNewCapacity(int n2, int n3) {
        ObjectUtil.checkPositiveOrZero(n2, "minNewCapacity");
        if (n2 > n3) {
            throw new IllegalArgumentException(String.format("minNewCapacity: %d (expected: not greater than maxCapacity(%d)", n2, n3));
        }
        int n4 = 0x400000;
        if (n2 == 0x400000) {
            return 0x400000;
        }
        if (n2 > 0x400000) {
            int n5 = n2 / 0x400000 * 0x400000;
            n5 = n5 > n3 - 0x400000 ? n3 : (n5 += 0x400000);
            return n5;
        }
        int n6 = MathUtil.findNextPositivePowerOfTwo(Math.max(n2, 64));
        return Math.min(n6, n3);
    }

    static {
        ResourceLeakDetector.addExclusions(AbstractByteBufAllocator.class, "toLeakAwareBuffer");
    }
}

