/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac;

import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac.MacGlobalMemoryJNA;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.mac.MacVirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.jna.ByRef;
import com.gradle.scan.plugin.internal.dep.oshi.jna.Struct;
import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.mac.SystemB;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.platform.mac.SysctlUtil;
import com.gradle.scan.plugin.internal.dep.oshi.util.tuples.Pair;
import com.sun.jna.Native;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class MacVirtualMemoryJNA
extends MacVirtualMemory {
    private static final Logger LOG = LoggerFactory.getLogger(MacVirtualMemoryJNA.class);

    MacVirtualMemoryJNA(MacGlobalMemoryJNA macGlobalMemoryJNA) {
        super(macGlobalMemoryJNA);
    }

    @Override
    protected Pair<Long, Long> querySwapUsage() {
        long l2 = 0L;
        long l3 = 0L;
        try (Struct.CloseableXswUsage closeableXswUsage = new Struct.CloseableXswUsage();){
            if (SysctlUtil.sysctl("vm.swapusage", closeableXswUsage)) {
                l2 = closeableXswUsage.xsu_used;
                l3 = closeableXswUsage.xsu_total;
            }
        }
        return new Pair<Long, Long>(l2, l3);
    }

    @Override
    protected Pair<Long, Long> queryVmStat() {
        long l2 = 0L;
        long l3 = 0L;
        try (Struct.CloseableVMStatistics closeableVMStatistics = new Struct.CloseableVMStatistics();
             ByRef.CloseableIntByReference closeableIntByReference = new ByRef.CloseableIntByReference(closeableVMStatistics.size() / SystemB.INT_SIZE);){
            if (0 == SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, closeableVMStatistics, closeableIntByReference)) {
                l2 = ParseUtil.unsignedIntToLong(closeableVMStatistics.pageins);
                l3 = ParseUtil.unsignedIntToLong(closeableVMStatistics.pageouts);
            } else {
                LOG.error("Failed to get host VM info. Error code: {}", (Object)Native.getLastError());
            }
        }
        return new Pair<Long, Long>(l2, l3);
    }
}

