/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.AbstractPooledDerivedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.SwappedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.WrappedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.IllegalReferenceCountException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.ResourceLeakTracker;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.nio.ByteOrder;

class SimpleLeakAwareByteBuf
extends WrappedByteBuf {
    private final ByteBuf trackedByteBuf;
    final ResourceLeakTracker<ByteBuf> leak;

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        super(byteBuf);
        this.trackedByteBuf = ObjectUtil.checkNotNull(byteBuf2, "trackedByteBuf");
        this.leak = ObjectUtil.checkNotNull(resourceLeakTracker, "leak");
    }

    SimpleLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        this(byteBuf, byteBuf, resourceLeakTracker);
    }

    @Override
    public ByteBuf slice() {
        return this.newSharedLeakAwareByteBuf(super.slice());
    }

    @Override
    public ByteBuf retainedSlice() {
        return this.unwrappedDerived(super.retainedSlice());
    }

    @Override
    public ByteBuf retainedDuplicate() {
        return this.unwrappedDerived(super.retainedDuplicate());
    }

    @Override
    public ByteBuf readRetainedSlice(int n2) {
        return this.unwrappedDerived(super.readRetainedSlice(n2));
    }

    @Override
    public ByteBuf slice(int n2, int n3) {
        return this.newSharedLeakAwareByteBuf(super.slice(n2, n3));
    }

    @Override
    public ByteBuf duplicate() {
        return this.newSharedLeakAwareByteBuf(super.duplicate());
    }

    @Override
    public ByteBuf readSlice(int n2) {
        return this.newSharedLeakAwareByteBuf(super.readSlice(n2));
    }

    @Override
    public ByteBuf asReadOnly() {
        return this.newSharedLeakAwareByteBuf(super.asReadOnly());
    }

    @Override
    public ByteBuf touch() {
        return this;
    }

    @Override
    public ByteBuf touch(Object object) {
        return this;
    }

    @Override
    public boolean release() {
        try {
            if (super.release()) {
                this.closeLeak();
                return true;
            }
            return false;
        }
        catch (IllegalReferenceCountException illegalReferenceCountException) {
            Throwable throwable = this.leak.getCloseStackTraceIfAny();
            if (throwable != null) {
                illegalReferenceCountException.addSuppressed(throwable);
            }
            throw illegalReferenceCountException;
        }
    }

    private void closeLeak() {
        boolean bl2 = this.leak.close(this.trackedByteBuf);
        assert (bl2);
    }

    @Override
    public ByteBuf order(ByteOrder byteOrder) {
        if (this.order() == byteOrder) {
            return this;
        }
        return this.newSharedLeakAwareByteBuf(super.order(byteOrder));
    }

    private ByteBuf unwrappedDerived(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = SimpleLeakAwareByteBuf.unwrapSwapped(byteBuf);
        if (byteBuf2 instanceof AbstractPooledDerivedByteBuf) {
            ((AbstractPooledDerivedByteBuf)byteBuf2).parent(this);
            return this.newLeakAwareByteBuf(byteBuf, AbstractByteBuf.leakDetector.trackForcibly(byteBuf));
        }
        return this.newSharedLeakAwareByteBuf(byteBuf);
    }

    private static ByteBuf unwrapSwapped(ByteBuf byteBuf) {
        if (byteBuf instanceof SwappedByteBuf) {
            while ((byteBuf = byteBuf.unwrap()) instanceof SwappedByteBuf) {
            }
            return byteBuf;
        }
        return byteBuf;
    }

    private SimpleLeakAwareByteBuf newSharedLeakAwareByteBuf(ByteBuf byteBuf) {
        return this.newLeakAwareByteBuf(byteBuf, this.trackedByteBuf, this.leak);
    }

    private SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return this.newLeakAwareByteBuf(byteBuf, byteBuf, resourceLeakTracker);
    }

    protected SimpleLeakAwareByteBuf newLeakAwareByteBuf(ByteBuf byteBuf, ByteBuf byteBuf2, ResourceLeakTracker<ByteBuf> resourceLeakTracker) {
        return new SimpleLeakAwareByteBuf(byteBuf, byteBuf2, resourceLeakTracker);
    }
}

