/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.driver.windows.registry;

import com.gradle.scan.plugin.internal.dep.oshi.software.os.ApplicationInfo;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APITypeMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstalledAppsData {
    private static final Logger LOG = LoggerFactory.getLogger(InstalledAppsData.class);
    private static final Advapi32 ADV = Advapi32.INSTANCE;
    private static final Map<WinReg.HKEY, List<String>> REGISTRY_PATHS = new HashMap<WinReg.HKEY, List<String>>();
    private static final int[] ACCESS_FLAGS = new int[]{256, 512};

    private InstalledAppsData() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        LinkedHashSet<ApplicationInfo> linkedHashSet = new LinkedHashSet<ApplicationInfo>();
        for (Map.Entry<WinReg.HKEY, List<String>> entry : REGISTRY_PATHS.entrySet()) {
            WinReg.HKEY hKEY = entry.getKey();
            List<String> list = entry.getValue();
            for (String string : list) {
                for (int n2 : ACCESS_FLAGS) {
                    try {
                        String[] stringArray;
                        for (String string2 : stringArray = Advapi32Util.registryGetKeys(hKEY, string, n2)) {
                            String string3 = string + "\\" + string2;
                            try {
                                String string4 = InstalledAppsData.registryValueToString(InstalledAppsData.getRegistryValueOrNull(hKEY, string3, "DisplayName", n2));
                                if (string4 == null) continue;
                                String string5 = InstalledAppsData.registryValueToString(InstalledAppsData.getRegistryValueOrNull(hKEY, string3, "DisplayVersion", n2));
                                String string6 = InstalledAppsData.registryValueToString(InstalledAppsData.getRegistryValueOrNull(hKEY, string3, "Publisher", n2));
                                long l2 = InstalledAppsData.registryValueToLong(InstalledAppsData.getRegistryValueOrNull(hKEY, string3, "InstallDate", n2));
                                String string7 = InstalledAppsData.registryValueToString(InstalledAppsData.getRegistryValueOrNull(hKEY, string3, "InstallLocation", n2));
                                String string8 = InstalledAppsData.registryValueToString(InstalledAppsData.getRegistryValueOrNull(hKEY, string3, "InstallSource", n2));
                                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                                linkedHashMap.put("installLocation", string7);
                                linkedHashMap.put("installSource", string8);
                                ApplicationInfo applicationInfo = new ApplicationInfo(string4, string5, string6, l2, linkedHashMap);
                                linkedHashSet.add(applicationInfo);
                            }
                            catch (Win32Exception win32Exception) {
                                // empty catch block
                            }
                        }
                    }
                    catch (Win32Exception win32Exception) {
                        // empty catch block
                    }
                }
            }
        }
        return new ArrayList<ApplicationInfo>(linkedHashSet);
    }

    private static String registryValueToString(Object object) {
        if (object instanceof Integer) {
            return Integer.toString((Integer)object);
        }
        return (String)object;
    }

    private static long registryValueToLong(Object object) {
        if (object == null) {
            return 0L;
        }
        long l2 = System.currentTimeMillis() / 1000L;
        long l3 = l2 - 946080000L;
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            if ((long)n2 > l3 && (long)n2 < l2) {
                return (long)n2 * 1000L;
            }
            return n2;
        }
        if (object instanceof String) {
            String string = ((String)object).trim();
            long l4 = ParseUtil.parseDateToEpoch(string, "yyyyMMdd");
            if (l4 == 0L) {
                l4 = ParseUtil.parseDateToEpoch(string, "MM/dd/yyyy");
            }
            return l4;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getRegistryValueOrNull(WinReg.HKEY hKEY, String string, String string2, int n2) {
        block6: {
            WinReg.HKEY hKEY2 = null;
            try {
                hKEY2 = InstalledAppsData.getRegistryHKey(hKEY, string, n2);
                Object object = InstalledAppsData.registryGetValue(hKEY2, string2);
                if (object instanceof Integer || object instanceof String && !((String)object).trim().isEmpty()) {
                    Object object2 = object;
                    return object2;
                }
            }
            catch (Win32Exception win32Exception) {
                LOG.trace("Unable to access " + string + " with flag " + n2 + ": " + win32Exception.getMessage());
            }
            finally {
                int n3;
                if (hKEY2 == null || (n3 = ADV.RegCloseKey(hKEY2)) == 0) break block6;
                throw new Win32Exception(n3);
            }
        }
        return null;
    }

    private static WinReg.HKEY getRegistryHKey(WinReg.HKEY hKEY, String string, int n2) {
        WinReg.HKEYByReference hKEYByReference = new WinReg.HKEYByReference();
        int n3 = ADV.RegOpenKeyEx(hKEY, string, 0, 0x20019 | n2, hKEYByReference);
        if (n3 != 0) {
            throw new Win32Exception(n3);
        }
        return hKEYByReference.getValue();
    }

    private static Object registryGetValue(WinReg.HKEY hKEY, String string) {
        IntByReference intByReference = new IntByReference();
        IntByReference intByReference2 = new IntByReference();
        int n2 = ADV.RegQueryValueEx(hKEY, string, 0, intByReference, (Pointer)null, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        int n3 = intByReference.getValue();
        switch (n3) {
            case 1: 
            case 2: {
                return InstalledAppsData.registryGetString(hKEY, string, intByReference, intByReference2);
            }
            case 4: {
                return InstalledAppsData.registryGetDword(hKEY, string, intByReference, intByReference2);
            }
        }
        LOG.warn("Unsupported registry data type {} for {}", (Object)n3, (Object)string);
        return null;
    }

    private static String registryGetString(WinReg.HKEY hKEY, String string, IntByReference intByReference, IntByReference intByReference2) {
        if (intByReference2.getValue() == 0) {
            return "";
        }
        Memory memory = new Memory(intByReference2.getValue() + Native.WCHAR_SIZE);
        memory.clear();
        int n2 = ADV.RegQueryValueEx(hKEY, string, 0, intByReference, memory, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        if (W32APITypeMapper.DEFAULT == W32APITypeMapper.UNICODE) {
            return memory.getWideString(0L);
        }
        return memory.getString(0L);
    }

    private static int registryGetDword(WinReg.HKEY hKEY, String string, IntByReference intByReference, IntByReference intByReference2) {
        IntByReference intByReference3 = new IntByReference();
        int n2 = ADV.RegQueryValueEx(hKEY, string, 0, intByReference, intByReference3, intByReference2);
        if (n2 != 0 && n2 != 122) {
            throw new Win32Exception(n2);
        }
        return intByReference3.getValue();
    }

    static {
        REGISTRY_PATHS.put(WinReg.HKEY_LOCAL_MACHINE, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall", "SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
        REGISTRY_PATHS.put(WinReg.HKEY_CURRENT_USER, Arrays.asList("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall"));
    }
}

