/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.aix;

import com.gradle.scan.plugin.internal.dep.oshi.driver.unix.aix.perfstat.PerfstatMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.VirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.common.AbstractGlobalMemory;
import com.gradle.scan.plugin.internal.dep.oshi.hardware.platform.unix.aix.AixVirtualMemory;
import com.gradle.scan.plugin.internal.dep.oshi.util.Memoizer;
import com.sun.jna.platform.unix.aix.Perfstat;
import java.util.List;
import java.util.function.Supplier;

final class AixGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Perfstat.perfstat_memory_total_t> perfstatMem = Memoizer.memoize(AixGlobalMemory::queryPerfstat, Memoizer.defaultExpiration());
    private final Supplier<List<String>> lscfg;
    private final Supplier<VirtualMemory> vm = Memoizer.memoize(this::createVirtualMemory);

    AixGlobalMemory(Supplier<List<String>> supplier) {
        this.lscfg = supplier;
    }

    @Override
    public long getAvailable() {
        return this.perfstatMem.get().real_avail * 4096L;
    }

    @Override
    public long getTotal() {
        return this.perfstatMem.get().real_total * 4096L;
    }

    private static Perfstat.perfstat_memory_total_t queryPerfstat() {
        return PerfstatMemory.queryMemoryTotal();
    }

    private VirtualMemory createVirtualMemory() {
        return new AixVirtualMemory(this.perfstatMem);
    }
}

