/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslUtils;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class CipherSuiteConverter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(CipherSuiteConverter.class);
    private static final Pattern JAVA_CIPHERSUITE_PATTERN = Pattern.compile("^(?:TLS|SSL)_((?:(?!_WITH_).)+)_WITH_(.*)_(.*)$");
    private static final Pattern OPENSSL_CIPHERSUITE_PATTERN = Pattern.compile("^(?:((?:(?:EXP-)?(?:(?:DHE|EDH|ECDH|ECDHE|SRP|RSA)-(?:DSS|RSA|ECDSA|PSK)|(?:ADH|AECDH|KRB5|PSK|SRP)))|EXP)-)?(.*)-(.*)$");
    private static final Pattern JAVA_AES_CBC_PATTERN = Pattern.compile("^(AES)_([0-9]+)_CBC$");
    private static final Pattern JAVA_AES_PATTERN = Pattern.compile("^(AES)_([0-9]+)_(.*)$");
    private static final Pattern OPENSSL_AES_CBC_PATTERN = Pattern.compile("^(AES)([0-9]+)$");
    private static final Pattern OPENSSL_AES_PATTERN = Pattern.compile("^(AES)([0-9]+)-(.*)$");
    private static final ConcurrentMap<String, CachedValue> j2o = new ConcurrentHashMap<String, CachedValue>();
    private static final ConcurrentMap<String, Map<String, String>> o2j = new ConcurrentHashMap<String, Map<String, String>>();
    private static final Map<String, String> j2oTls13;
    private static final Map<String, Map<String, String>> o2jTls13;

    public static String toOpenSsl(String string, boolean bl2) {
        CachedValue cachedValue = (CachedValue)j2o.get(string);
        if (cachedValue != null) {
            return cachedValue.value;
        }
        return CipherSuiteConverter.cacheFromJava(string, bl2);
    }

    private static String cacheFromJava(String string, boolean bl2) {
        String string2 = j2oTls13.get(string);
        if (string2 != null) {
            return bl2 ? string2 : string;
        }
        String string3 = CipherSuiteConverter.toOpenSslUncached(string, bl2);
        j2o.putIfAbsent(string, CachedValue.of(string3));
        if (string3 == null) {
            return null;
        }
        String string4 = string.substring(4);
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("", string4);
        hashMap.put("SSL", "SSL_" + string4);
        hashMap.put("TLS", "TLS_" + string4);
        o2j.put(string3, hashMap);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string, (Object)string3);
        return string3;
    }

    static String toOpenSslUncached(String string, boolean bl2) {
        String string2 = j2oTls13.get(string);
        if (string2 != null) {
            return bl2 ? string2 : string;
        }
        Matcher matcher = JAVA_CIPHERSUITE_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string3 = CipherSuiteConverter.toOpenSslHandshakeAlgo(matcher.group(1));
        String string4 = CipherSuiteConverter.toOpenSslBulkCipher(matcher.group(2));
        String string5 = CipherSuiteConverter.toOpenSslHmacAlgo(matcher.group(3));
        if (string3.isEmpty()) {
            return string4 + '-' + string5;
        }
        if (string4.contains("CHACHA20")) {
            return string3 + '-' + string4;
        }
        return string3 + '-' + string4 + '-' + string5;
    }

    private static String toOpenSslHandshakeAlgo(String string) {
        boolean bl2 = string.endsWith("_EXPORT");
        if (bl2) {
            string = string.substring(0, string.length() - 7);
        }
        if ("RSA".equals(string)) {
            string = "";
        } else if (string.endsWith("_anon")) {
            string = 'A' + string.substring(0, string.length() - 5);
        }
        if (bl2) {
            string = string.isEmpty() ? "EXP" : "EXP-" + string;
        }
        return string.replace('_', '-');
    }

    private static String toOpenSslBulkCipher(String string) {
        if (string.startsWith("AES_")) {
            Matcher matcher = JAVA_AES_CBC_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1$2");
            }
            matcher = JAVA_AES_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1$2-$3");
            }
        }
        if ("3DES_EDE_CBC".equals(string)) {
            return "DES-CBC3";
        }
        if ("RC4_128".equals(string) || "RC4_40".equals(string)) {
            return "RC4";
        }
        if ("DES40_CBC".equals(string) || "DES_CBC_40".equals(string)) {
            return "DES-CBC";
        }
        if ("RC2_CBC_40".equals(string)) {
            return "RC2-CBC";
        }
        return string.replace('_', '-');
    }

    private static String toOpenSslHmacAlgo(String string) {
        return string;
    }

    public static String toJava(String string, String string2) {
        Map<String, String> map = (Map<String, String>)o2j.get(string);
        if (map == null && (map = CipherSuiteConverter.cacheFromOpenSsl(string)) == null) {
            return null;
        }
        String string3 = map.get(string2);
        if (string3 == null) {
            String string4 = map.get("");
            if (string4 == null) {
                return null;
            }
            string3 = string2 + '_' + string4;
        }
        return string3;
    }

    private static Map<String, String> cacheFromOpenSsl(String string) {
        Map<String, String> map = o2jTls13.get(string);
        if (map != null) {
            return map;
        }
        String string2 = CipherSuiteConverter.toJavaUncached0(string, false);
        if (string2 == null) {
            return null;
        }
        String string3 = "SSL_" + string2;
        String string4 = "TLS_" + string2;
        HashMap<String, String> hashMap = new HashMap<String, String>(4);
        hashMap.put("", string2);
        hashMap.put("SSL", string3);
        hashMap.put("TLS", string4);
        o2j.putIfAbsent(string, hashMap);
        CachedValue cachedValue = CachedValue.of(string);
        j2o.putIfAbsent(string4, cachedValue);
        j2o.putIfAbsent(string3, cachedValue);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string4, (Object)string);
        logger.debug("Cipher suite mapping: {} => {}", (Object)string3, (Object)string);
        return hashMap;
    }

    private static String toJavaUncached0(String string, boolean bl2) {
        boolean bl3;
        Object object;
        if (bl2 && (object = o2jTls13.get(string)) != null) {
            return (String)object.get("TLS");
        }
        object = OPENSSL_CIPHERSUITE_PATTERN.matcher(string);
        if (!((Matcher)object).matches()) {
            return null;
        }
        String string2 = ((Matcher)object).group(1);
        if (string2 == null) {
            string2 = "";
            bl3 = false;
        } else if (string2.startsWith("EXP-")) {
            string2 = string2.substring(4);
            bl3 = true;
        } else if ("EXP".equals(string2)) {
            string2 = "";
            bl3 = true;
        } else {
            bl3 = false;
        }
        string2 = CipherSuiteConverter.toJavaHandshakeAlgo(string2, bl3);
        String string3 = CipherSuiteConverter.toJavaBulkCipher(((Matcher)object).group(2), bl3);
        String string4 = CipherSuiteConverter.toJavaHmacAlgo(((Matcher)object).group(3));
        String string5 = string2 + "_WITH_" + string3 + '_' + string4;
        return string3.contains("CHACHA20") ? string5 + "_SHA256" : string5;
    }

    private static String toJavaHandshakeAlgo(String string, boolean bl2) {
        if (string.isEmpty()) {
            string = "RSA";
        } else if ("ADH".equals(string)) {
            string = "DH_anon";
        } else if ("AECDH".equals(string)) {
            string = "ECDH_anon";
        }
        string = string.replace('-', '_');
        if (bl2) {
            return string + "_EXPORT";
        }
        return string;
    }

    private static String toJavaBulkCipher(String string, boolean bl2) {
        if (string.startsWith("AES")) {
            Matcher matcher = OPENSSL_AES_CBC_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1_$2_CBC");
            }
            matcher = OPENSSL_AES_PATTERN.matcher(string);
            if (matcher.matches()) {
                return matcher.replaceFirst("$1_$2_$3");
            }
        }
        if ("DES-CBC3".equals(string)) {
            return "3DES_EDE_CBC";
        }
        if ("RC4".equals(string)) {
            if (bl2) {
                return "RC4_40";
            }
            return "RC4_128";
        }
        if ("DES-CBC".equals(string)) {
            if (bl2) {
                return "DES_CBC_40";
            }
            return "DES_CBC";
        }
        if ("RC2-CBC".equals(string)) {
            if (bl2) {
                return "RC2_CBC_40";
            }
            return "RC2_CBC";
        }
        return string.replace('-', '_');
    }

    private static String toJavaHmacAlgo(String string) {
        return string;
    }

    static void convertToCipherStrings(Iterable<String> iterable, StringBuilder stringBuilder, StringBuilder stringBuilder2, boolean bl2) {
        for (String string : iterable) {
            if (string == null) break;
            String string2 = CipherSuiteConverter.toOpenSsl(string, bl2);
            if (string2 == null) {
                string2 = string;
            }
            if (!OpenSsl.isCipherSuiteAvailable(string2)) {
                throw new IllegalArgumentException("unsupported cipher suite: " + string + '(' + string2 + ')');
            }
            if (SslUtils.isTLSv13Cipher(string2) || SslUtils.isTLSv13Cipher(string)) {
                stringBuilder2.append(string2);
                stringBuilder2.append(':');
                continue;
            }
            stringBuilder.append(string2);
            stringBuilder.append(':');
        }
        if (stringBuilder.length() == 0 && stringBuilder2.length() == 0) {
            throw new IllegalArgumentException("empty cipher suites");
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2.setLength(stringBuilder2.length() - 1);
        }
    }

    private CipherSuiteConverter() {
    }

    static {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TLS_AES_128_GCM_SHA256", "AEAD-AES128-GCM-SHA256");
        hashMap.put("TLS_AES_256_GCM_SHA384", "AEAD-AES256-GCM-SHA384");
        hashMap.put("TLS_CHACHA20_POLY1305_SHA256", "AEAD-CHACHA20-POLY1305-SHA256");
        j2oTls13 = Collections.unmodifiableMap(hashMap);
        HashMap<String, Map<String, String>> hashMap2 = new HashMap<String, Map<String, String>>();
        hashMap2.put("TLS_AES_128_GCM_SHA256", Collections.singletonMap("TLS", "TLS_AES_128_GCM_SHA256"));
        hashMap2.put("TLS_AES_256_GCM_SHA384", Collections.singletonMap("TLS", "TLS_AES_256_GCM_SHA384"));
        hashMap2.put("TLS_CHACHA20_POLY1305_SHA256", Collections.singletonMap("TLS", "TLS_CHACHA20_POLY1305_SHA256"));
        hashMap2.put("AEAD-AES128-GCM-SHA256", Collections.singletonMap("TLS", "TLS_AES_128_GCM_SHA256"));
        hashMap2.put("AEAD-AES256-GCM-SHA384", Collections.singletonMap("TLS", "TLS_AES_256_GCM_SHA384"));
        hashMap2.put("AEAD-CHACHA20-POLY1305-SHA256", Collections.singletonMap("TLS", "TLS_CHACHA20_POLY1305_SHA256"));
        o2jTls13 = Collections.unmodifiableMap(hashMap2);
    }

    private static final class CachedValue {
        private static final CachedValue NULL = new CachedValue(null);
        final String value;

        static CachedValue of(String string) {
            return string != null ? new CachedValue(string) : NULL;
        }

        private CachedValue(String string) {
            this.value = string;
        }
    }
}

