/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.execchain;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.Log;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.scan.plugin.internal.dep.org.apache.http.Header;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.ServiceUnavailableRetryStrategy;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.methods.CloseableHttpResponse;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.methods.HttpExecutionAware;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.methods.HttpRequestWrapper;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.protocol.HttpClientContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.conn.routing.HttpRoute;
import com.gradle.scan.plugin.internal.dep.org.apache.http.impl.execchain.ClientExecChain;
import com.gradle.scan.plugin.internal.dep.org.apache.http.impl.execchain.RequestEntityProxy;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.io.IOException;
import java.io.InterruptedIOException;

public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain clientExecChain, ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        Args.notNull(clientExecChain, "HTTP request executor");
        Args.notNull(serviceUnavailableRetryStrategy, "Retry strategy");
        this.requestExecutor = clientExecChain;
        this.retryStrategy = serviceUnavailableRetryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute httpRoute, HttpRequestWrapper httpRequestWrapper, HttpClientContext httpClientContext, HttpExecutionAware httpExecutionAware) throws IOException, HttpException {
        Header[] headerArray = httpRequestWrapper.getAllHeaders();
        int n2 = 1;
        while (true) {
            CloseableHttpResponse closeableHttpResponse = this.requestExecutor.execute(httpRoute, httpRequestWrapper, httpClientContext, httpExecutionAware);
            try {
                if (this.retryStrategy.retryRequest(closeableHttpResponse, n2, httpClientContext) && RequestEntityProxy.isRepeatable(httpRequestWrapper)) {
                    closeableHttpResponse.close();
                    long l2 = this.retryStrategy.getRetryInterval();
                    if (l2 > 0L) {
                        try {
                            this.log.trace("Wait for " + l2);
                            Thread.sleep(l2);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return closeableHttpResponse;
                }
                httpRequestWrapper.setHeaders(headerArray);
            }
            catch (RuntimeException runtimeException) {
                closeableHttpResponse.close();
                throw runtimeException;
            }
            ++n2;
        }
    }
}

