/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent;

import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.AbstractFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.BlockingOperationException;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.DefaultFutureListeners;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.EventExecutor;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Future;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GenericFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.GenericProgressiveFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.ProgressiveFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.util.concurrent.Promise;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.InternalThreadLocalMap;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.StringUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.SystemPropertyUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ThrowableUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLogger;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class DefaultPromise<V>
extends AbstractFuture<V>
implements Promise<V> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultPromise.class);
    private static final InternalLogger rejectedExecutionLogger = InternalLoggerFactory.getInstance(DefaultPromise.class.getName() + ".rejectedExecution");
    private static final int MAX_LISTENER_STACK_DEPTH = Math.min(8, SystemPropertyUtil.getInt("com.gradle.scan.plugin.internal.dep.io.netty.defaultPromise.maxListenerStackDepth", 8));
    private static final AtomicReferenceFieldUpdater<DefaultPromise, Object> RESULT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultPromise.class, Object.class, "result");
    private static final Object SUCCESS = new Object();
    private static final Object UNCANCELLABLE = new Object();
    private static final CauseHolder CANCELLATION_CAUSE_HOLDER = new CauseHolder(StacklessCancellationException.newInstance(DefaultPromise.class, "cancel(...)"));
    private static final StackTraceElement[] CANCELLATION_STACK = DefaultPromise.CANCELLATION_CAUSE_HOLDER.cause.getStackTrace();
    private volatile Object result;
    private final EventExecutor executor;
    private GenericFutureListener<? extends Future<?>> listener;
    private DefaultFutureListeners listeners;
    private short waiters;
    private boolean notifyingListeners;

    public DefaultPromise(EventExecutor eventExecutor) {
        this.executor = ObjectUtil.checkNotNull(eventExecutor, "executor");
    }

    protected DefaultPromise() {
        this.executor = null;
    }

    @Override
    public Promise<V> setSuccess(V v2) {
        if (this.setSuccess0(v2)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this);
    }

    @Override
    public boolean trySuccess(V v2) {
        return this.setSuccess0(v2);
    }

    @Override
    public Promise<V> setFailure(Throwable throwable) {
        if (this.setFailure0(throwable)) {
            return this;
        }
        throw new IllegalStateException("complete already: " + this, throwable);
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        return this.setFailure0(throwable);
    }

    @Override
    public boolean setUncancellable() {
        if (RESULT_UPDATER.compareAndSet(this, null, UNCANCELLABLE)) {
            return true;
        }
        Object object = this.result;
        return !DefaultPromise.isDone0(object) || !DefaultPromise.isCancelled0(object);
    }

    @Override
    public boolean isSuccess() {
        Object object = this.result;
        return object != null && object != UNCANCELLABLE && !(object instanceof CauseHolder);
    }

    @Override
    public Throwable cause() {
        return this.cause0(this.result);
    }

    private Throwable cause0(Object object) {
        if (!(object instanceof CauseHolder)) {
            return null;
        }
        if (object == CANCELLATION_CAUSE_HOLDER) {
            LeanCancellationException leanCancellationException = new LeanCancellationException();
            if (RESULT_UPDATER.compareAndSet(this, CANCELLATION_CAUSE_HOLDER, new CauseHolder(leanCancellationException))) {
                return leanCancellationException;
            }
            object = this.result;
        }
        return ((CauseHolder)object).cause;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> addListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        ObjectUtil.checkNotNull(genericFutureListener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.addListener0(genericFutureListener);
        }
        if (this.isDone()) {
            this.notifyListeners();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> removeListener(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        ObjectUtil.checkNotNull(genericFutureListener, "listener");
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            this.removeListener0(genericFutureListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Promise<V> await() throws InterruptedException {
        if (this.isDone()) {
            return this;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Promise<V> awaitUninterruptibly() {
        if (this.isDone()) {
            return this;
        }
        this.checkDeadLock();
        boolean bl2 = false;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            while (!this.isDone()) {
                this.incWaiters();
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                finally {
                    this.decWaiters();
                }
            }
        }
        if (bl2) {
            Thread.currentThread().interrupt();
        }
        return this;
    }

    @Override
    public boolean await(long l2, TimeUnit timeUnit) throws InterruptedException {
        return this.await0(timeUnit.toNanos(l2), true);
    }

    @Override
    public V getNow() {
        Object object = this.result;
        if (object instanceof CauseHolder || object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        return (V)object;
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        Object object = this.result;
        if (!DefaultPromise.isDone0(object)) {
            this.await();
            object = this.result;
        }
        if (object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        Throwable throwable = this.cause0(object);
        if (throwable == null) {
            return (V)object;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        throw new ExecutionException(throwable);
    }

    @Override
    public V get(long l2, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        Object object = this.result;
        if (!DefaultPromise.isDone0(object)) {
            if (!this.await(l2, timeUnit)) {
                throw new TimeoutException();
            }
            object = this.result;
        }
        if (object == SUCCESS || object == UNCANCELLABLE) {
            return null;
        }
        Throwable throwable = this.cause0(object);
        if (throwable == null) {
            return (V)object;
        }
        if (throwable instanceof CancellationException) {
            throw (CancellationException)throwable;
        }
        throw new ExecutionException(throwable);
    }

    @Override
    public boolean cancel(boolean bl2) {
        if (RESULT_UPDATER.compareAndSet(this, null, CANCELLATION_CAUSE_HOLDER)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCancelled() {
        return DefaultPromise.isCancelled0(this.result);
    }

    @Override
    public boolean isDone() {
        return DefaultPromise.isDone0(this.result);
    }

    @Override
    public Promise<V> syncUninterruptibly() {
        this.awaitUninterruptibly();
        this.rethrowIfFailed();
        return this;
    }

    public String toString() {
        return this.toStringBuilder().toString();
    }

    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = new StringBuilder(64).append(StringUtil.simpleClassName(this)).append('@').append(Integer.toHexString(this.hashCode()));
        Object object = this.result;
        if (object == SUCCESS) {
            stringBuilder.append("(success)");
        } else if (object == UNCANCELLABLE) {
            stringBuilder.append("(uncancellable)");
        } else if (object instanceof CauseHolder) {
            stringBuilder.append("(failure: ").append(((CauseHolder)object).cause).append(')');
        } else if (object != null) {
            stringBuilder.append("(success: ").append(object).append(')');
        } else {
            stringBuilder.append("(incomplete)");
        }
        return stringBuilder;
    }

    protected EventExecutor executor() {
        return this.executor;
    }

    protected void checkDeadLock() {
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor != null && eventExecutor.inEventLoop()) {
            throw new BlockingOperationException(this.toString());
        }
    }

    protected static void notifyListener(EventExecutor eventExecutor, Future<?> future, GenericFutureListener<?> genericFutureListener) {
        DefaultPromise.notifyListenerWithStackOverFlowProtection(ObjectUtil.checkNotNull(eventExecutor, "eventExecutor"), ObjectUtil.checkNotNull(future, "future"), ObjectUtil.checkNotNull(genericFutureListener, "listener"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        InternalThreadLocalMap internalThreadLocalMap;
        int n2;
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor.inEventLoop() && (n2 = (internalThreadLocalMap = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            internalThreadLocalMap.setFutureListenerStackDepth(n2 + 1);
            try {
                this.notifyListenersNow();
            }
            finally {
                internalThreadLocalMap.setFutureListenerStackDepth(n2);
            }
            return;
        }
        DefaultPromise.safeExecute(eventExecutor, new Runnable(){

            @Override
            public void run() {
                DefaultPromise.this.notifyListenersNow();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListenerWithStackOverFlowProtection(EventExecutor eventExecutor, final Future<?> future, final GenericFutureListener<?> genericFutureListener) {
        InternalThreadLocalMap internalThreadLocalMap;
        int n2;
        if (eventExecutor.inEventLoop() && (n2 = (internalThreadLocalMap = InternalThreadLocalMap.get()).futureListenerStackDepth()) < MAX_LISTENER_STACK_DEPTH) {
            internalThreadLocalMap.setFutureListenerStackDepth(n2 + 1);
            try {
                DefaultPromise.notifyListener0(future, genericFutureListener);
            }
            finally {
                internalThreadLocalMap.setFutureListenerStackDepth(n2);
            }
            return;
        }
        DefaultPromise.safeExecute(eventExecutor, new Runnable(){

            @Override
            public void run() {
                DefaultPromise.notifyListener0(future, genericFutureListener);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListenersNow() {
        DefaultFutureListeners defaultFutureListeners;
        GenericFutureListener<? extends Future<?>> genericFutureListener;
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            genericFutureListener = this.listener;
            defaultFutureListeners = this.listeners;
            if (this.notifyingListeners || genericFutureListener == null && defaultFutureListeners == null) {
                return;
            }
            this.notifyingListeners = true;
            if (genericFutureListener != null) {
                this.listener = null;
            } else {
                this.listeners = null;
            }
        }
        while (true) {
            if (genericFutureListener != null) {
                DefaultPromise.notifyListener0(this, genericFutureListener);
            } else {
                this.notifyListeners0(defaultFutureListeners);
            }
            defaultPromise = this;
            synchronized (defaultPromise) {
                if (this.listener == null && this.listeners == null) {
                    this.notifyingListeners = false;
                    return;
                }
                genericFutureListener = this.listener;
                defaultFutureListeners = this.listeners;
                if (genericFutureListener != null) {
                    this.listener = null;
                } else {
                    this.listeners = null;
                }
            }
        }
    }

    private void notifyListeners0(DefaultFutureListeners defaultFutureListeners) {
        GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = defaultFutureListeners.listeners();
        int n2 = defaultFutureListeners.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            DefaultPromise.notifyListener0(this, genericFutureListenerArray[i2]);
        }
    }

    private static void notifyListener0(Future future, GenericFutureListener genericFutureListener) {
        block2: {
            try {
                genericFutureListener.operationComplete(future);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + genericFutureListener.getClass().getName() + ".operationComplete()", throwable);
            }
        }
    }

    private void addListener0(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        if (this.listener == null) {
            if (this.listeners == null) {
                this.listener = genericFutureListener;
            } else {
                this.listeners.add(genericFutureListener);
            }
        } else {
            assert (this.listeners == null);
            this.listeners = new DefaultFutureListeners(this.listener, genericFutureListener);
            this.listener = null;
        }
    }

    private void removeListener0(GenericFutureListener<? extends Future<? super V>> genericFutureListener) {
        if (this.listener == genericFutureListener) {
            this.listener = null;
        } else if (this.listeners != null) {
            this.listeners.remove(genericFutureListener);
            if (this.listeners.size() == 0) {
                this.listeners = null;
            }
        }
    }

    private boolean setSuccess0(V v2) {
        return this.setValue0(v2 == null ? SUCCESS : v2);
    }

    private boolean setFailure0(Throwable throwable) {
        return this.setValue0(new CauseHolder(ObjectUtil.checkNotNull(throwable, "cause")));
    }

    private boolean setValue0(Object object) {
        if (RESULT_UPDATER.compareAndSet(this, null, object) || RESULT_UPDATER.compareAndSet(this, UNCANCELLABLE, object)) {
            if (this.checkNotifyWaiters()) {
                this.notifyListeners();
            }
            return true;
        }
        return false;
    }

    private synchronized boolean checkNotifyWaiters() {
        if (this.waiters > 0) {
            this.notifyAll();
        }
        return this.listener != null || this.listeners != null;
    }

    private void incWaiters() {
        if (this.waiters == Short.MAX_VALUE) {
            throw new IllegalStateException("too many waiters: " + this);
        }
        this.waiters = (short)(this.waiters + 1);
    }

    private void decWaiters() {
        this.waiters = (short)(this.waiters - 1);
    }

    private void rethrowIfFailed() {
        Throwable throwable = this.cause();
        if (throwable == null) {
            return;
        }
        PlatformDependent.throwException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long l2, boolean bl2) throws InterruptedException {
        if (this.isDone()) {
            return true;
        }
        if (l2 <= 0L) {
            return this.isDone();
        }
        if (bl2 && Thread.interrupted()) {
            throw new InterruptedException(this.toString());
        }
        this.checkDeadLock();
        long l3 = System.nanoTime();
        DefaultPromise defaultPromise = this;
        synchronized (defaultPromise) {
            boolean bl3 = false;
            try {
                long l4 = l2;
                while (!this.isDone() && l4 > 0L) {
                    this.incWaiters();
                    try {
                        this.wait(l4 / 1000000L, (int)(l4 % 1000000L));
                    }
                    catch (InterruptedException interruptedException) {
                        if (bl2) {
                            throw interruptedException;
                        }
                        bl3 = true;
                    }
                    finally {
                        this.decWaiters();
                    }
                    if (this.isDone()) {
                        boolean bl4 = true;
                        return bl4;
                    }
                    l4 = l2 - (System.nanoTime() - l3);
                }
                boolean bl5 = this.isDone();
                return bl5;
            }
            finally {
                if (bl3) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    void notifyProgressiveListeners(final long l2, final long l3) {
        Object object = this.progressiveListeners();
        if (object == null) {
            return;
        }
        final ProgressiveFuture progressiveFuture = (ProgressiveFuture)((Object)this);
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor.inEventLoop()) {
            if (object instanceof GenericProgressiveFutureListener[]) {
                DefaultPromise.notifyProgressiveListeners0(progressiveFuture, (GenericProgressiveFutureListener[])object, l2, l3);
            } else {
                DefaultPromise.notifyProgressiveListener0(progressiveFuture, (GenericProgressiveFutureListener)object, l2, l3);
            }
        } else if (object instanceof GenericProgressiveFutureListener[]) {
            final GenericProgressiveFutureListener[] genericProgressiveFutureListenerArray = (GenericProgressiveFutureListener[])object;
            DefaultPromise.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    DefaultPromise.notifyProgressiveListeners0(progressiveFuture, genericProgressiveFutureListenerArray, l2, l3);
                }
            });
        } else {
            final GenericProgressiveFutureListener genericProgressiveFutureListener = (GenericProgressiveFutureListener)object;
            DefaultPromise.safeExecute(eventExecutor, new Runnable(){

                @Override
                public void run() {
                    DefaultPromise.notifyProgressiveListener0(progressiveFuture, genericProgressiveFutureListener, l2, l3);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private synchronized Object progressiveListeners() {
        GenericFutureListener<? extends Future<?>> genericFutureListener = this.listener;
        DefaultFutureListeners defaultFutureListeners = this.listeners;
        if (genericFutureListener == null && defaultFutureListeners == null) {
            return null;
        }
        if (defaultFutureListeners != null) {
            void var8_13;
            DefaultFutureListeners defaultFutureListeners2 = defaultFutureListeners;
            int n2 = defaultFutureListeners2.progressiveSize();
            switch (n2) {
                case 0: {
                    return null;
                }
                case 1: {
                    for (GenericFutureListener<Future<?>> genericFutureListener2 : defaultFutureListeners2.listeners()) {
                        if (!(genericFutureListener2 instanceof GenericProgressiveFutureListener)) continue;
                        return genericFutureListener2;
                    }
                    return null;
                }
            }
            GenericFutureListener<? extends Future<?>>[] genericFutureListenerArray = defaultFutureListeners2.listeners();
            GenericProgressiveFutureListener[] genericProgressiveFutureListenerArray = new GenericProgressiveFutureListener[n2];
            int n3 = 0;
            boolean n4 = false;
            while (var8_13 < n2) {
                GenericFutureListener<Future<?>> genericFutureListener2 = genericFutureListenerArray[n3];
                if (genericFutureListener2 instanceof GenericProgressiveFutureListener) {
                    genericProgressiveFutureListenerArray[++var8_13] = (GenericProgressiveFutureListener)genericFutureListener2;
                }
                ++n3;
            }
            return genericProgressiveFutureListenerArray;
        }
        if (genericFutureListener instanceof GenericProgressiveFutureListener) {
            return genericFutureListener;
        }
        return null;
    }

    private static void notifyProgressiveListeners0(ProgressiveFuture<?> progressiveFuture, GenericProgressiveFutureListener<?>[] genericProgressiveFutureListenerArray, long l2, long l3) {
        for (GenericProgressiveFutureListener<?> genericProgressiveFutureListener : genericProgressiveFutureListenerArray) {
            if (genericProgressiveFutureListener == null) break;
            DefaultPromise.notifyProgressiveListener0(progressiveFuture, genericProgressiveFutureListener, l2, l3);
        }
    }

    private static void notifyProgressiveListener0(ProgressiveFuture progressiveFuture, GenericProgressiveFutureListener genericProgressiveFutureListener, long l2, long l3) {
        block2: {
            try {
                genericProgressiveFutureListener.operationProgressed(progressiveFuture, l2, l3);
            }
            catch (Throwable throwable) {
                if (!logger.isWarnEnabled()) break block2;
                logger.warn("An exception was thrown by " + genericProgressiveFutureListener.getClass().getName() + ".operationProgressed()", throwable);
            }
        }
    }

    private static boolean isCancelled0(Object object) {
        return object instanceof CauseHolder && ((CauseHolder)object).cause instanceof CancellationException;
    }

    private static boolean isDone0(Object object) {
        return object != null && object != UNCANCELLABLE;
    }

    private static void safeExecute(EventExecutor eventExecutor, Runnable runnable) {
        try {
            eventExecutor.execute(runnable);
        }
        catch (Throwable throwable) {
            rejectedExecutionLogger.error("Failed to submit a listener notification task. Event loop shut down?", throwable);
        }
    }

    private static final class StacklessCancellationException
    extends CancellationException {
        private StacklessCancellationException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }

        static StacklessCancellationException newInstance(Class<?> clazz, String string) {
            return ThrowableUtil.unknownStackTrace(new StacklessCancellationException(), clazz, string);
        }
    }

    private static final class CauseHolder {
        final Throwable cause;

        CauseHolder(Throwable throwable) {
            this.cause = throwable;
        }
    }

    private static final class LeanCancellationException
    extends CancellationException {
        private LeanCancellationException() {
        }

        @Override
        public Throwable fillInStackTrace() {
            this.setStackTrace(CANCELLATION_STACK);
            return this;
        }

        @Override
        public String toString() {
            return CancellationException.class.getName();
        }
    }
}

