/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.buffer;

import com.gradle.scan.plugin.internal.dep.io.netty.buffer.ByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.PooledHeapByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.SwappedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnsafeByteBufUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.buffer.UnsafeHeapSwappedByteBuf;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectPool;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.PlatformDependent;

final class PooledUnsafeHeapByteBuf
extends PooledHeapByteBuf {
    private static final ObjectPool<PooledUnsafeHeapByteBuf> RECYCLER = ObjectPool.newPool(new ObjectPool.ObjectCreator<PooledUnsafeHeapByteBuf>(){

        @Override
        public PooledUnsafeHeapByteBuf newObject(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle) {
            return new PooledUnsafeHeapByteBuf(handle, 0);
        }
    });

    static PooledUnsafeHeapByteBuf newUnsafeInstance(int n2) {
        PooledUnsafeHeapByteBuf pooledUnsafeHeapByteBuf = RECYCLER.get();
        pooledUnsafeHeapByteBuf.reuse(n2);
        return pooledUnsafeHeapByteBuf;
    }

    private PooledUnsafeHeapByteBuf(ObjectPool.Handle<PooledUnsafeHeapByteBuf> handle, int n2) {
        super((ObjectPool.Handle<? extends PooledHeapByteBuf>)handle, n2);
    }

    @Override
    protected byte _getByte(int n2) {
        return UnsafeByteBufUtil.getByte((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShort(int n2) {
        return UnsafeByteBufUtil.getShort((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected short _getShortLE(int n2) {
        return UnsafeByteBufUtil.getShortLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMedium(int n2) {
        return UnsafeByteBufUtil.getUnsignedMedium((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getUnsignedMediumLE(int n2) {
        return UnsafeByteBufUtil.getUnsignedMediumLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getInt(int n2) {
        return UnsafeByteBufUtil.getInt((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected int _getIntLE(int n2) {
        return UnsafeByteBufUtil.getIntLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLong(int n2) {
        return UnsafeByteBufUtil.getLong((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected long _getLongLE(int n2) {
        return UnsafeByteBufUtil.getLongLE((byte[])this.memory, this.idx(n2));
    }

    @Override
    protected void _setByte(int n2, int n3) {
        UnsafeByteBufUtil.setByte((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setShort(int n2, int n3) {
        UnsafeByteBufUtil.setShort((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setMedium(int n2, int n3) {
        UnsafeByteBufUtil.setMedium((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setInt(int n2, int n3) {
        UnsafeByteBufUtil.setInt((byte[])this.memory, this.idx(n2), n3);
    }

    @Override
    protected void _setLong(int n2, long l2) {
        UnsafeByteBufUtil.setLong((byte[])this.memory, this.idx(n2), l2);
    }

    @Override
    public ByteBuf setZero(int n2, int n3) {
        if (PlatformDependent.javaVersion() >= 7) {
            this.checkIndex(n2, n3);
            UnsafeByteBufUtil.setZero((byte[])this.memory, this.idx(n2), n3);
            return this;
        }
        return super.setZero(n2, n3);
    }

    @Override
    @Deprecated
    protected SwappedByteBuf newSwappedByteBuf() {
        if (PlatformDependent.isUnaligned()) {
            return new UnsafeHeapSwappedByteBuf(this);
        }
        return super.newSwappedByteBuf();
    }
}

