/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.cfg.CoercionAction;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.type.LogicalType;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jdk8.BaseScalarOptionalDeserializer;
import java.io.IOException;
import java.util.OptionalInt;

public class OptionalIntDeserializer
extends BaseScalarOptionalDeserializer<OptionalInt> {
    static final OptionalIntDeserializer INSTANCE = new OptionalIntDeserializer();

    public OptionalIntDeserializer() {
        super(OptionalInt.class, OptionalInt.empty());
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Integer;
    }

    @Override
    public OptionalInt deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
            return OptionalInt.of(jsonParser.getIntValue());
        }
        switch (jsonParser.currentTokenId()) {
            case 6: {
                String string = jsonParser.getText();
                CoercionAction coercionAction = this._checkFromStringCoercion(deserializationContext, string);
                if (coercionAction == CoercionAction.AsNull || coercionAction == CoercionAction.AsEmpty) {
                    return (OptionalInt)this._empty;
                }
                string = string.trim();
                return OptionalInt.of(this._parseIntPrimitive(deserializationContext, string));
            }
            case 8: {
                CoercionAction coercionAction = this._checkFloatToIntCoercion(jsonParser, deserializationContext, this._valueClass);
                if (coercionAction == CoercionAction.AsNull || coercionAction == CoercionAction.AsEmpty) {
                    return (OptionalInt)this._empty;
                }
                return OptionalInt.of(jsonParser.getValueAsInt());
            }
            case 11: {
                return (OptionalInt)this._empty;
            }
            case 3: {
                return (OptionalInt)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (OptionalInt)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }
}

