/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.commons.io.filefilter;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.file.PathVisitor;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.io.filefilter.IOFileFilter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Objects;

public abstract class AbstractFileFilter
implements PathVisitor,
IOFileFilter {
    static FileVisitResult toDefaultFileVisitResult(boolean bl2) {
        return bl2 ? FileVisitResult.CONTINUE : FileVisitResult.TERMINATE;
    }

    @Override
    public boolean accept(File file) {
        Objects.requireNonNull(file, "file");
        return this.accept(file.getParentFile(), file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        Objects.requireNonNull(string, "name");
        return this.accept(new File(file, string));
    }

    public FileVisitResult postVisitDirectory(Path path, IOException iOException) throws IOException {
        return FileVisitResult.CONTINUE;
    }

    public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.accept(path, basicFileAttributes);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
        return this.accept(path, basicFileAttributes);
    }

    public FileVisitResult visitFileFailed(Path path, IOException iOException) throws IOException {
        return FileVisitResult.CONTINUE;
    }
}

