/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.client;

import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.Log;
import com.gradle.scan.plugin.internal.dep.org.apache.commons.logging.LogFactory;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpEntity;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpHost;
import com.gradle.scan.plugin.internal.dep.org.apache.http.HttpRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.ClientProtocolException;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.ResponseHandler;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.methods.CloseableHttpResponse;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.methods.HttpUriRequest;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.utils.URIUtils;
import com.gradle.scan.plugin.internal.dep.org.apache.http.protocol.HttpContext;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.EntityUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;

public abstract class CloseableHttpClient
implements Closeable {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    public CloseableHttpResponse execute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.doExecute(httpHost, httpRequest, httpContext);
    }

    public CloseableHttpResponse execute(HttpUriRequest httpUriRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        Args.notNull(httpUriRequest, "HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(httpUriRequest), httpUriRequest, httpContext);
    }

    private static HttpHost determineTarget(HttpUriRequest httpUriRequest) throws ClientProtocolException {
        HttpHost httpHost = null;
        URI uRI = httpUriRequest.getURI();
        if (uRI.isAbsolute() && (httpHost = URIUtils.extractHost(uRI)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + uRI);
        }
        return httpHost;
    }

    public CloseableHttpResponse execute(HttpUriRequest httpUriRequest) throws IOException, ClientProtocolException {
        return this.execute(httpUriRequest, (HttpContext)null);
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        return this.execute(httpUriRequest, responseHandler, null);
    }

    public <T> T execute(HttpUriRequest httpUriRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        HttpHost httpHost = CloseableHttpClient.determineTarget(httpUriRequest);
        return this.execute(httpHost, httpUriRequest, responseHandler, httpContext);
    }

    public <T> T execute(HttpHost httpHost, HttpRequest httpRequest, ResponseHandler<? extends T> responseHandler, HttpContext httpContext) throws IOException, ClientProtocolException {
        Args.notNull(responseHandler, "Response handler");
        CloseableHttpResponse closeableHttpResponse = this.execute(httpHost, httpRequest, httpContext);
        try {
            T t2 = responseHandler.handleResponse(closeableHttpResponse);
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            EntityUtils.consume(httpEntity);
            T t3 = t2;
            return t3;
        }
        catch (ClientProtocolException clientProtocolException) {
            HttpEntity httpEntity = closeableHttpResponse.getEntity();
            try {
                EntityUtils.consume(httpEntity);
            }
            catch (Exception exception) {
                this.log.warn("Error consuming content after an exception.", exception);
            }
            throw clientProtocolException;
        }
        finally {
            closeableHttpResponse.close();
        }
    }
}

