/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser;

import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.annotation.JsonFormat;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonParser;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.core.JsonToken;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationContext;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.databind.DeserializationFeature;
import com.gradle.scan.plugin.internal.dep.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.YearMonth;
import java.time.format.DateTimeFormatter;

public class YearMonthDeserializer
extends JSR310DateTimeDeserializerBase<YearMonth> {
    public static final YearMonthDeserializer INSTANCE = new YearMonthDeserializer();

    public YearMonthDeserializer() {
        this(DateTimeFormatter.ofPattern("u-MM"));
    }

    public YearMonthDeserializer(DateTimeFormatter dateTimeFormatter) {
        super(YearMonth.class, dateTimeFormatter);
    }

    protected YearMonthDeserializer(YearMonthDeserializer yearMonthDeserializer, Boolean bl2) {
        super(yearMonthDeserializer, bl2);
    }

    public YearMonthDeserializer(YearMonthDeserializer yearMonthDeserializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        super(yearMonthDeserializer, bl2, dateTimeFormatter, shape);
    }

    protected YearMonthDeserializer withDateFormat(DateTimeFormatter dateTimeFormatter) {
        return new YearMonthDeserializer(this, (Boolean)this._isLenient, dateTimeFormatter, this._shape);
    }

    protected YearMonthDeserializer withLeniency(Boolean bl2) {
        return new YearMonthDeserializer(this, bl2);
    }

    @Override
    public YearMonth deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(jsonParser, deserializationContext, jsonParser.getText());
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            return this._fromString(jsonParser, deserializationContext, deserializationContext.extractScalarFromObject(jsonParser, this, this.handledType()));
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken = jsonParser.nextToken();
            if (jsonToken == JsonToken.END_ARRAY) {
                return null;
            }
            if ((jsonToken == JsonToken.VALUE_STRING || jsonToken == JsonToken.VALUE_EMBEDDED_OBJECT) && deserializationContext.isEnabled(DeserializationFeature.UNWRAP_SINGLE_VALUE_ARRAYS)) {
                YearMonth yearMonth = this.deserialize(jsonParser, deserializationContext);
                if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                    this.handleMissingEndArrayForSingle(jsonParser, deserializationContext);
                }
                return yearMonth;
            }
            if (jsonToken != JsonToken.VALUE_NUMBER_INT) {
                this._reportWrongToken(deserializationContext, JsonToken.VALUE_NUMBER_INT, "years");
            }
            int n2 = jsonParser.getIntValue();
            int n3 = jsonParser.nextIntValue(-1);
            if (n3 == -1) {
                if (!jsonParser.hasToken(JsonToken.VALUE_NUMBER_INT)) {
                    this._reportWrongToken(deserializationContext, JsonToken.VALUE_NUMBER_INT, "months");
                }
                n3 = jsonParser.getIntValue();
            }
            if (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                throw deserializationContext.wrongTokenException(jsonParser, this.handledType(), JsonToken.END_ARRAY, "Expected array to end");
            }
            return YearMonth.of(n2, n3);
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            return (YearMonth)jsonParser.getEmbeddedObject();
        }
        return (YearMonth)this._handleUnexpectedToken(deserializationContext, jsonParser, JsonToken.VALUE_STRING, JsonToken.START_ARRAY);
    }

    protected YearMonth _fromString(JsonParser jsonParser, DeserializationContext deserializationContext, String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() == 0) {
            return (YearMonth)this._fromEmptyString(jsonParser, deserializationContext, string2);
        }
        try {
            return YearMonth.parse(string2, this._formatter);
        }
        catch (DateTimeException dateTimeException) {
            return (YearMonth)this._handleDateTimeException(deserializationContext, dateTimeException, string2);
        }
    }
}

