/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm;

import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ByteVector;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ClassReader;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ClassWriter;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.ConstantDynamic;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Handle;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Label;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Symbol;
import com.gradle.scan.plugin.internal.dep.org.gradle.testretry.org.objectweb.asm.Type;

final class SymbolTable {
    final ClassWriter classWriter;
    private final ClassReader sourceClassReader;
    private int majorVersion;
    private String className;
    private int entryCount;
    private Entry[] entries;
    private int constantPoolCount;
    private ByteVector constantPool;
    private int bootstrapMethodCount;
    private ByteVector bootstrapMethods;
    private int typeCount;
    private Entry[] typeTable;
    private int labelCount;
    private LabelEntry[] labelTable;
    private LabelEntry[] labelEntries;

    ClassReader getSource() {
        return this.sourceClassReader;
    }

    int getMajorVersion() {
        return this.majorVersion;
    }

    String getClassName() {
        return this.className;
    }

    int setMajorVersionAndClassName(int n2, String string) {
        this.majorVersion = n2;
        this.className = string;
        return this.addConstantClass((String)string).index;
    }

    private Entry get(int n2) {
        return this.entries[n2 % this.entries.length];
    }

    private Entry put(Entry entry) {
        int n2;
        if (this.entryCount > this.entries.length * 3 / 4) {
            n2 = this.entries.length;
            int n3 = n2 * 2 + 1;
            Entry[] entryArray = new Entry[n3];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                Entry entry2 = this.entries[i2];
                while (entry2 != null) {
                    int n4 = entry2.hashCode % n3;
                    Entry entry3 = entry2.next;
                    entry2.next = entryArray[n4];
                    entryArray[n4] = entry2;
                    entry2 = entry3;
                }
            }
            this.entries = entryArray;
        }
        ++this.entryCount;
        n2 = entry.hashCode % this.entries.length;
        entry.next = this.entries[n2];
        this.entries[n2] = entry;
        return this.entries[n2];
    }

    Symbol addConstant(Object object) {
        if (object instanceof Integer) {
            return this.addConstantInteger((Integer)object);
        }
        if (object instanceof Byte) {
            return this.addConstantInteger(((Byte)object).intValue());
        }
        if (object instanceof Character) {
            return this.addConstantInteger(((Character)object).charValue());
        }
        if (object instanceof Short) {
            return this.addConstantInteger(((Short)object).intValue());
        }
        if (object instanceof Boolean) {
            return this.addConstantInteger((Boolean)object != false ? 1 : 0);
        }
        if (object instanceof Float) {
            return this.addConstantFloat(((Float)object).floatValue());
        }
        if (object instanceof Long) {
            return this.addConstantLong((Long)object);
        }
        if (object instanceof Double) {
            return this.addConstantDouble((Double)object);
        }
        if (object instanceof String) {
            return this.addConstantString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            int n2 = type.getSort();
            if (n2 == 10) {
                return this.addConstantClass(type.getInternalName());
            }
            if (n2 == 11) {
                return this.addConstantMethodType(type.getDescriptor());
            }
            return this.addConstantClass(type.getDescriptor());
        }
        if (object instanceof Handle) {
            Handle handle = (Handle)object;
            return this.addConstantMethodHandle(handle.getTag(), handle.getOwner(), handle.getName(), handle.getDesc(), handle.isInterface());
        }
        if (object instanceof ConstantDynamic) {
            ConstantDynamic constantDynamic = (ConstantDynamic)object;
            return this.addConstantDynamic(constantDynamic.getName(), constantDynamic.getDescriptor(), constantDynamic.getBootstrapMethod(), constantDynamic.getBootstrapMethodArgumentsUnsafe());
        }
        throw new IllegalArgumentException(SymbolTable.stringConcat$0(object));
    }

    private static /* synthetic */ String stringConcat$0(Object object) {
        return "value " + object;
    }

    Symbol addConstantClass(String string) {
        return this.addConstantUtf8Reference(7, string);
    }

    Symbol addConstantFieldref(String string, String string2, String string3) {
        return this.addConstantMemberReference(9, string, string2, string3);
    }

    Symbol addConstantMethodref(String string, String string2, String string3, boolean bl2) {
        int n2 = bl2 ? 11 : 10;
        return this.addConstantMemberReference(n2, string, string2, string3);
    }

    private Entry addConstantMemberReference(int n2, String string, String string2, String string3) {
        int n3 = SymbolTable.hash(n2, string, string2, string3);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n3 && entry.owner.equals(string) && entry.name.equals(string2) && entry.value.equals(string3)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(n2, this.addConstantClass((String)string).index, this.addConstantNameAndType(string2, string3));
        return this.put(new Entry(this.constantPoolCount++, n2, string, string2, string3, 0L, n3));
    }

    Symbol addConstantString(String string) {
        return this.addConstantUtf8Reference(8, string);
    }

    Symbol addConstantInteger(int n2) {
        return this.addConstantIntegerOrFloat(3, n2);
    }

    Symbol addConstantFloat(float f2) {
        return this.addConstantIntegerOrFloat(4, Float.floatToRawIntBits(f2));
    }

    private Symbol addConstantIntegerOrFloat(int n2, int n3) {
        int n4 = SymbolTable.hash(n2, n3);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n4 && entry.data == (long)n3) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(n2).putInt(n3);
        return this.put(new Entry(this.constantPoolCount++, n2, n3, n4));
    }

    Symbol addConstantLong(long l2) {
        return this.addConstantLongOrDouble(5, l2);
    }

    Symbol addConstantDouble(double d2) {
        return this.addConstantLongOrDouble(6, Double.doubleToRawLongBits(d2));
    }

    private Symbol addConstantLongOrDouble(int n2, long l2) {
        int n3 = SymbolTable.hash(n2, l2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n3 && entry.data == l2) {
                return entry;
            }
            entry = entry.next;
        }
        int n4 = this.constantPoolCount;
        this.constantPool.putByte(n2).putLong(l2);
        this.constantPoolCount += 2;
        return this.put(new Entry(n4, n2, l2, n3));
    }

    int addConstantNameAndType(String string, String string2) {
        int n2 = 12;
        int n3 = SymbolTable.hash(12, string, string2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == 12 && entry.hashCode == n3 && entry.name.equals(string) && entry.value.equals(string2)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.put122(12, this.addConstantUtf8(string), this.addConstantUtf8(string2));
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)12, (String)string, (String)string2, (int)n3)).index;
    }

    int addConstantUtf8(String string) {
        int n2 = SymbolTable.hash(1, string);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 1 && entry.hashCode == n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        this.constantPool.putByte(1).putUTF8(string);
        return this.put((Entry)new Entry((int)this.constantPoolCount++, (int)1, (String)string, (int)n2)).index;
    }

    Symbol addConstantMethodHandle(int n2, String string, String string2, String string3, boolean bl2) {
        int n3 = 15;
        int n4 = SymbolTable.hash(15, string, string2, string3, n2);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == 15 && entry.hashCode == n4 && entry.data == (long)n2 && entry.owner.equals(string) && entry.name.equals(string2) && entry.value.equals(string3)) {
                return entry;
            }
            entry = entry.next;
        }
        if (n2 <= 4) {
            this.constantPool.put112(15, n2, this.addConstantFieldref((String)string, (String)string2, (String)string3).index);
        } else {
            this.constantPool.put112(15, n2, this.addConstantMethodref((String)string, (String)string2, (String)string3, (boolean)bl2).index);
        }
        return this.put(new Entry(this.constantPoolCount++, 15, string, string2, string3, n2, n4));
    }

    Symbol addConstantMethodType(String string) {
        return this.addConstantUtf8Reference(16, string);
    }

    Symbol addConstantDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantDynamicOrInvokeDynamicReference(17, string, string2, symbol.index);
    }

    Symbol addConstantInvokeDynamic(String string, String string2, Handle handle, Object ... objectArray) {
        Symbol symbol = this.addBootstrapMethod(handle, objectArray);
        return this.addConstantDynamicOrInvokeDynamicReference(18, string, string2, symbol.index);
    }

    private Symbol addConstantDynamicOrInvokeDynamicReference(int n2, String string, String string2, int n3) {
        int n4 = SymbolTable.hash(n2, string, string2, n3);
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n4 && entry.data == (long)n3 && entry.name.equals(string) && entry.value.equals(string2)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put122(n2, n3, this.addConstantNameAndType(string, string2));
        return this.put(new Entry(this.constantPoolCount++, n2, null, string, string2, n3, n4));
    }

    Symbol addConstantModule(String string) {
        return this.addConstantUtf8Reference(19, string);
    }

    Symbol addConstantPackage(String string) {
        return this.addConstantUtf8Reference(20, string);
    }

    private Symbol addConstantUtf8Reference(int n2, String string) {
        int n3 = SymbolTable.hash(n2, string);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == n2 && entry.hashCode == n3 && entry.value.equals(string)) {
                return entry;
            }
            entry = entry.next;
        }
        this.constantPool.put12(n2, this.addConstantUtf8(string));
        return this.put(new Entry(this.constantPoolCount++, n2, string, n3));
    }

    Symbol addBootstrapMethod(Handle handle, Object ... objectArray) {
        int n2;
        int n3;
        ByteVector byteVector = this.bootstrapMethods;
        if (byteVector == null) {
            byteVector = this.bootstrapMethods = new ByteVector();
        }
        int n4 = objectArray.length;
        int[] nArray = new int[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            nArray[n3] = this.addConstant((Object)objectArray[n3]).index;
        }
        n3 = byteVector.length;
        byteVector.putShort(this.addConstantMethodHandle((int)handle.getTag(), (String)handle.getOwner(), (String)handle.getName(), (String)handle.getDesc(), (boolean)handle.isInterface()).index);
        byteVector.putShort(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            byteVector.putShort(nArray[n2]);
        }
        n2 = byteVector.length - n3;
        int n5 = handle.hashCode();
        for (Object object : objectArray) {
            n5 ^= object.hashCode();
        }
        return this.addBootstrapMethod(n3, n2, n5 &= Integer.MAX_VALUE);
    }

    private Symbol addBootstrapMethod(int n2, int n3, int n4) {
        byte[] byArray = this.bootstrapMethods.data;
        Entry entry = this.get(n4);
        while (entry != null) {
            if (entry.tag == 64 && entry.hashCode == n4) {
                int n5 = (int)entry.data;
                boolean bl2 = true;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (byArray[n2 + i2] == byArray[n5 + i2]) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    this.bootstrapMethods.length = n2;
                    return entry;
                }
            }
            entry = entry.next;
        }
        return this.put(new Entry(this.bootstrapMethodCount++, 64, n2, n4));
    }

    Symbol getType(int n2) {
        return this.typeTable[n2];
    }

    Label getForwardUninitializedLabel(int n2) {
        return this.labelTable[(int)this.typeTable[n2].data].label;
    }

    int addType(String string) {
        int n2 = SymbolTable.hash(128, string);
        Entry entry = this.get(n2);
        while (entry != null) {
            if (entry.tag == 128 && entry.hashCode == n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 128, string, n2));
    }

    int addUninitializedType(String string, int n2) {
        int n3 = SymbolTable.hash(129, string, n2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == 129 && entry.hashCode == n3 && entry.data == (long)n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 129, string, n2, n3));
    }

    int addForwardUninitializedType(String string, Label label) {
        int n2 = this.getOrAddLabelEntry((Label)label).index;
        int n3 = SymbolTable.hash(130, string, n2);
        Entry entry = this.get(n3);
        while (entry != null) {
            if (entry.tag == 130 && entry.hashCode == n3 && entry.data == (long)n2 && entry.value.equals(string)) {
                return entry.index;
            }
            entry = entry.next;
        }
        return this.addTypeInternal(new Entry(this.typeCount, 130, string, n2, n3));
    }

    int addMergedType(int n2, int n3) {
        int n4;
        long l2 = n2 < n3 ? (long)n2 | (long)n3 << 32 : (long)n3 | (long)n2 << 32;
        int n5 = SymbolTable.hash(131, n2 + n3);
        Entry entry = this.get(n5);
        while (entry != null) {
            if (entry.tag == 131 && entry.hashCode == n5 && entry.data == l2) {
                return entry.info;
            }
            entry = entry.next;
        }
        String string = this.typeTable[n2].value;
        String string2 = this.typeTable[n3].value;
        this.put((Entry)new Entry((int)this.typeCount, (int)131, (long)l2, (int)n5)).info = n4 = this.addType(this.classWriter.getCommonSuperClass(string, string2));
        return n4;
    }

    private int addTypeInternal(Entry entry) {
        if (this.typeTable == null) {
            this.typeTable = new Entry[16];
        }
        if (this.typeCount == this.typeTable.length) {
            Entry[] entryArray = new Entry[2 * this.typeTable.length];
            System.arraycopy(this.typeTable, 0, entryArray, 0, this.typeTable.length);
            this.typeTable = entryArray;
        }
        this.typeTable[this.typeCount++] = entry;
        return this.put((Entry)entry).index;
    }

    private LabelEntry getOrAddLabelEntry(Label label) {
        int n2;
        if (this.labelEntries == null) {
            this.labelEntries = new LabelEntry[16];
            this.labelTable = new LabelEntry[16];
        }
        int n3 = System.identityHashCode(label);
        LabelEntry labelEntry = this.labelEntries[n3 % this.labelEntries.length];
        while (labelEntry != null && labelEntry.label != label) {
            labelEntry = labelEntry.next;
        }
        if (labelEntry != null) {
            return labelEntry;
        }
        if (this.labelCount > this.labelEntries.length * 3 / 4) {
            n2 = this.labelEntries.length;
            int n4 = n2 * 2 + 1;
            LabelEntry[] labelEntryArray = new LabelEntry[n4];
            for (int i2 = n2 - 1; i2 >= 0; --i2) {
                LabelEntry labelEntry2 = this.labelEntries[i2];
                while (labelEntry2 != null) {
                    int n5 = System.identityHashCode(labelEntry2.label) % n4;
                    LabelEntry labelEntry3 = labelEntry2.next;
                    labelEntry2.next = labelEntryArray[n5];
                    labelEntryArray[n5] = labelEntry2;
                    labelEntry2 = labelEntry3;
                }
            }
            this.labelEntries = labelEntryArray;
        }
        if (this.labelCount == this.labelTable.length) {
            LabelEntry[] labelEntryArray = new LabelEntry[2 * this.labelTable.length];
            System.arraycopy(this.labelTable, 0, labelEntryArray, 0, this.labelTable.length);
            this.labelTable = labelEntryArray;
        }
        labelEntry = new LabelEntry(this.labelCount, label);
        n2 = n3 % this.labelEntries.length;
        labelEntry.next = this.labelEntries[n2];
        this.labelEntries[n2] = labelEntry;
        this.labelTable[this.labelCount++] = labelEntry;
        return labelEntry;
    }

    private static int hash(int n2, int n3) {
        return Integer.MAX_VALUE & n2 + n3;
    }

    private static int hash(int n2, long l2) {
        return Integer.MAX_VALUE & n2 + (int)l2 + (int)(l2 >>> 32);
    }

    private static int hash(int n2, String string) {
        return Integer.MAX_VALUE & n2 + string.hashCode();
    }

    private static int hash(int n2, String string, int n3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() + n3;
    }

    private static int hash(int n2, String string, String string2) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode();
    }

    private static int hash(int n2, String string, String string2, int n3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode() * (n3 + 1);
    }

    private static int hash(int n2, String string, String string2, String string3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode() * string3.hashCode();
    }

    private static int hash(int n2, String string, String string2, String string3, int n3) {
        return Integer.MAX_VALUE & n2 + string.hashCode() * string2.hashCode() * string3.hashCode() * n3;
    }

    private static final class Entry
    extends Symbol {
        final int hashCode;
        Entry next;

        Entry(int n2, int n3, String string, String string2, String string3, long l2, int n4) {
            super(n2, n3, string, string2, string3, l2);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, String string, int n4) {
            super(n2, n3, null, null, string, 0L);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, String string, long l2, int n4) {
            super(n2, n3, null, null, string, l2);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, String string, String string2, int n4) {
            super(n2, n3, null, string, string2, 0L);
            this.hashCode = n4;
        }

        Entry(int n2, int n3, long l2, int n4) {
            super(n2, n3, null, null, null, l2);
            this.hashCode = n4;
        }
    }

    private static final class LabelEntry {
        final int index;
        final Label label;
        LabelEntry next;

        LabelEntry(int n2, Label label) {
            this.index = n2;
            this.label = label;
        }
    }
}

