/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.org.apache.http.impl.client;

import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.AuthScope;
import com.gradle.scan.plugin.internal.dep.org.apache.http.auth.Credentials;
import com.gradle.scan.plugin.internal.dep.org.apache.http.client.CredentialsProvider;
import com.gradle.scan.plugin.internal.dep.org.apache.http.util.Args;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class BasicCredentialsProvider
implements CredentialsProvider {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    @Override
    public void setCredentials(AuthScope authScope, Credentials credentials) {
        Args.notNull(authScope, "Authentication scope");
        this.credMap.put(authScope, credentials);
    }

    private static Credentials matchCredentials(Map<AuthScope, Credentials> map, AuthScope authScope) {
        Credentials credentials = map.get(authScope);
        if (credentials == null) {
            int n2 = -1;
            AuthScope authScope2 = null;
            for (AuthScope authScope3 : map.keySet()) {
                int n3 = authScope.match(authScope3);
                if (n3 <= n2) continue;
                n2 = n3;
                authScope2 = authScope3;
            }
            if (authScope2 != null) {
                credentials = map.get(authScope2);
            }
        }
        return credentials;
    }

    @Override
    public Credentials getCredentials(AuthScope authScope) {
        Args.notNull(authScope, "Authentication scope");
        return BasicCredentialsProvider.matchCredentials(this.credMap, authScope);
    }

    public String toString() {
        return this.credMap.toString();
    }
}

