/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl;

import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.OpenSsl;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.ssl.SslUtils;
import java.security.Provider;

public enum SslProvider {
    JDK,
    OPENSSL,
    OPENSSL_REFCNT;


    public static boolean isTlsv13Supported(SslProvider sslProvider) {
        return SslProvider.isTlsv13Supported(sslProvider, null);
    }

    public static boolean isTlsv13Supported(SslProvider sslProvider, Provider provider) {
        switch (sslProvider) {
            case JDK: {
                return SslUtils.isTLSv13SupportedByJDK(provider);
            }
            case OPENSSL: 
            case OPENSSL_REFCNT: {
                return OpenSsl.isTlsv13Supported();
            }
        }
        throw new Error("Unknown SslProvider: " + (Object)((Object)sslProvider));
    }
}

