/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx;

import com.gradle.scan.plugin.internal.dep.io.netty.channel.Channel;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFuture;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelFutureListener;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelHandlerContext;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPipeline;
import com.gradle.scan.plugin.internal.dep.io.netty.channel.ChannelPromise;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.FullHttpRequest;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.FullHttpResponse;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpClientCodec;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpContentDecompressor;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaderNames;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpHeaders;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpObjectAggregator;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpRequestEncoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpResponseDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.HttpScheme;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakeException;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameDecoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketFrameEncoder;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketScheme;
import com.gradle.scan.plugin.internal.dep.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import com.gradle.scan.plugin.internal.dep.io.netty.util.NetUtil;
import com.gradle.scan.plugin.internal.dep.io.netty.util.internal.ObjectUtil;
import java.net.URI;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public abstract class WebSocketClientHandshaker {
    private static final String HTTP_SCHEME_PREFIX = HttpScheme.HTTP + "://";
    private static final String HTTPS_SCHEME_PREFIX = HttpScheme.HTTPS + "://";
    private final URI uri;
    private final WebSocketVersion version;
    private volatile boolean handshakeComplete;
    private volatile long forceCloseTimeoutMillis = 10000L;
    private volatile int forceCloseInit;
    private static final AtomicIntegerFieldUpdater<WebSocketClientHandshaker> FORCE_CLOSE_INIT_UPDATER = AtomicIntegerFieldUpdater.newUpdater(WebSocketClientHandshaker.class, "forceCloseInit");
    private final String expectedSubprotocol;
    private volatile String actualSubprotocol;
    protected final HttpHeaders customHeaders;
    private final int maxFramePayloadLength;
    private final boolean absoluteUpgradeUrl;
    protected final boolean generateOriginHeader;

    protected WebSocketClientHandshaker(URI uRI, WebSocketVersion webSocketVersion, String string, HttpHeaders httpHeaders, int n2, long l2, boolean bl2, boolean bl3) {
        this.uri = uRI;
        this.version = webSocketVersion;
        this.expectedSubprotocol = string;
        this.customHeaders = httpHeaders;
        this.maxFramePayloadLength = n2;
        this.forceCloseTimeoutMillis = l2;
        this.absoluteUpgradeUrl = bl2;
        this.generateOriginHeader = bl3;
    }

    public URI uri() {
        return this.uri;
    }

    public WebSocketVersion version() {
        return this.version;
    }

    public int maxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    private void setHandshakeComplete() {
        this.handshakeComplete = true;
    }

    public String expectedSubprotocol() {
        return this.expectedSubprotocol;
    }

    private void setActualSubprotocol(String string) {
        this.actualSubprotocol = string;
    }

    public ChannelFuture handshake(Channel channel) {
        ObjectUtil.checkNotNull(channel, "channel");
        return this.handshake(channel, channel.newPromise());
    }

    public final ChannelFuture handshake(Channel channel, final ChannelPromise channelPromise) {
        Object object;
        ChannelPipeline channelPipeline = channel.pipeline();
        HttpResponseDecoder httpResponseDecoder = channelPipeline.get(HttpResponseDecoder.class);
        if (httpResponseDecoder == null && (object = channelPipeline.get(HttpClientCodec.class)) == null) {
            channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain an HttpResponseDecoder or HttpClientCodec"));
            return channelPromise;
        }
        if (this.uri.getHost() == null) {
            if (this.customHeaders == null || !this.customHeaders.contains(HttpHeaderNames.HOST)) {
                channelPromise.setFailure(new IllegalArgumentException("Cannot generate the 'host' header value, webSocketURI should contain host or passed through customHeaders"));
                return channelPromise;
            }
            if (this.generateOriginHeader && !this.customHeaders.contains(HttpHeaderNames.ORIGIN)) {
                object = this.version == WebSocketVersion.V07 || this.version == WebSocketVersion.V08 ? HttpHeaderNames.SEC_WEBSOCKET_ORIGIN.toString() : HttpHeaderNames.ORIGIN.toString();
                channelPromise.setFailure(new IllegalArgumentException("Cannot generate the '" + (String)object + "' header value, webSocketURI should contain host or disable generateOriginHeader or pass value through customHeaders"));
                return channelPromise;
            }
        }
        object = this.newHandshakeRequest();
        channel.writeAndFlush(object).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    ChannelPipeline channelPipeline = channelFuture.channel().pipeline();
                    ChannelHandlerContext channelHandlerContext = channelPipeline.context(HttpRequestEncoder.class);
                    if (channelHandlerContext == null) {
                        channelHandlerContext = channelPipeline.context(HttpClientCodec.class);
                    }
                    if (channelHandlerContext == null) {
                        channelPromise.setFailure(new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec"));
                        return;
                    }
                    channelPipeline.addAfter(channelHandlerContext.name(), "ws-encoder", WebSocketClientHandshaker.this.newWebSocketEncoder());
                    channelPromise.setSuccess();
                } else {
                    channelPromise.setFailure(channelFuture.cause());
                }
            }
        });
        return channelPromise;
    }

    protected abstract FullHttpRequest newHandshakeRequest();

    public final void finishHandshake(Channel channel, FullHttpResponse fullHttpResponse) {
        ChannelHandlerContext channelHandlerContext;
        HttpObjectAggregator httpObjectAggregator;
        this.verify(fullHttpResponse);
        String string = fullHttpResponse.headers().get(HttpHeaderNames.SEC_WEBSOCKET_PROTOCOL);
        string = string != null ? string.trim() : null;
        String string2 = this.expectedSubprotocol != null ? this.expectedSubprotocol : "";
        boolean bl2 = false;
        if (string2.isEmpty() && string == null) {
            bl2 = true;
            this.setActualSubprotocol(this.expectedSubprotocol);
        } else if (!string2.isEmpty() && string != null && !string.isEmpty()) {
            for (String object2 : string2.split(",")) {
                if (!object2.trim().equals(string)) continue;
                bl2 = true;
                this.setActualSubprotocol(string);
                break;
            }
        }
        if (!bl2) {
            throw new WebSocketClientHandshakeException(String.format("Invalid subprotocol. Actual: %s. Expected one of: %s", string, this.expectedSubprotocol), fullHttpResponse);
        }
        this.setHandshakeComplete();
        String[] stringArray = channel.pipeline();
        HttpContentDecompressor httpContentDecompressor = stringArray.get(HttpContentDecompressor.class);
        if (httpContentDecompressor != null) {
            stringArray.remove(httpContentDecompressor);
        }
        if ((httpObjectAggregator = stringArray.get(HttpObjectAggregator.class)) != null) {
            stringArray.remove(httpObjectAggregator);
        }
        if ((channelHandlerContext = stringArray.context(HttpResponseDecoder.class)) == null) {
            ChannelHandlerContext channelHandlerContext2 = stringArray.context(HttpClientCodec.class);
            if (channelHandlerContext2 == null) {
                throw new IllegalStateException("ChannelPipeline does not contain an HttpRequestEncoder or HttpClientCodec");
            }
            HttpClientCodec httpClientCodec = (HttpClientCodec)channelHandlerContext2.handler();
            httpClientCodec.removeOutboundHandler();
            stringArray.addAfter(channelHandlerContext2.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, httpClientCodec){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ HttpClientCodec val$codec;
                {
                    this.val$p = channelPipeline;
                    this.val$codec = httpClientCodec;
                }

                @Override
                public void run() {
                    this.val$p.remove(this.val$codec);
                }
            });
        } else {
            if (stringArray.get(HttpRequestEncoder.class) != null) {
                stringArray.remove(HttpRequestEncoder.class);
            }
            ChannelHandlerContext channelHandlerContext3 = channelHandlerContext;
            stringArray.addAfter(channelHandlerContext3.name(), "ws-decoder", this.newWebsocketDecoder());
            channel.eventLoop().execute(new Runnable((ChannelPipeline)stringArray, channelHandlerContext3){
                final /* synthetic */ ChannelPipeline val$p;
                final /* synthetic */ ChannelHandlerContext val$context;
                {
                    this.val$p = channelPipeline;
                    this.val$context = channelHandlerContext;
                }

                @Override
                public void run() {
                    this.val$p.remove(this.val$context.handler());
                }
            });
        }
    }

    protected abstract void verify(FullHttpResponse var1);

    protected abstract WebSocketFrameDecoder newWebsocketDecoder();

    protected abstract WebSocketFrameEncoder newWebSocketEncoder();

    protected String upgradeUrl(URI uRI) {
        if (this.absoluteUpgradeUrl) {
            return uRI.toString();
        }
        String string = uRI.getRawPath();
        string = string == null || string.isEmpty() ? "/" : string;
        String string2 = uRI.getRawQuery();
        return string2 != null && !string2.isEmpty() ? string + '?' + string2 : string;
    }

    static CharSequence websocketHostValue(URI uRI) {
        int n2 = uRI.getPort();
        if (n2 == -1) {
            return uRI.getHost();
        }
        String string = uRI.getHost();
        String string2 = uRI.getScheme();
        if (n2 == HttpScheme.HTTP.port()) {
            return HttpScheme.HTTP.name().contentEquals(string2) || WebSocketScheme.WS.name().contentEquals(string2) ? string : NetUtil.toSocketAddressString(string, n2);
        }
        if (n2 == HttpScheme.HTTPS.port()) {
            return HttpScheme.HTTPS.name().contentEquals(string2) || WebSocketScheme.WSS.name().contentEquals(string2) ? string : NetUtil.toSocketAddressString(string, n2);
        }
        return NetUtil.toSocketAddressString(string, n2);
    }

    static CharSequence websocketOriginValue(URI uRI) {
        int n2;
        String string;
        String string2 = uRI.getScheme();
        int n3 = uRI.getPort();
        if (WebSocketScheme.WSS.name().contentEquals(string2) || HttpScheme.HTTPS.name().contentEquals(string2) || string2 == null && n3 == WebSocketScheme.WSS.port()) {
            string = HTTPS_SCHEME_PREFIX;
            n2 = WebSocketScheme.WSS.port();
        } else {
            string = HTTP_SCHEME_PREFIX;
            n2 = WebSocketScheme.WS.port();
        }
        String string3 = uRI.getHost().toLowerCase(Locale.US);
        if (n3 != n2 && n3 != -1) {
            return string + NetUtil.toSocketAddressString(string3, n3);
        }
        return string + string3;
    }
}

