/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.scan.plugin.internal.dep.oshi.util.platform.unix.openbsd;

import com.gradle.scan.plugin.internal.dep.oshi.jna.ByRef;
import com.gradle.scan.plugin.internal.dep.oshi.jna.platform.unix.OpenBsdLibc;
import com.gradle.scan.plugin.internal.dep.oshi.util.ExecutingCommand;
import com.gradle.scan.plugin.internal.dep.oshi.util.ParseUtil;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.platform.unix.LibCAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OpenBsdSysctlUtil {
    private static final Logger LOG = LoggerFactory.getLogger(OpenBsdSysctlUtil.class);

    private OpenBsdSysctlUtil() {
    }

    public static long sysctl(int[] nArray, long l2) {
        int n2 = OpenBsdLibc.UINT64_SIZE;
        try (Memory memory = new Memory(n2);){
            ByRef.CloseableSizeTByReference closeableSizeTByReference;
            block12: {
                closeableSizeTByReference = new ByRef.CloseableSizeTByReference((long)n2);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block12;
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)nArray, (Object)Native.getLastError());
                    long l3 = l2;
                    closeableSizeTByReference.close();
                    return l3;
                }
                catch (Throwable throwable) {
                    try {
                        closeableSizeTByReference.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            long l4 = memory.getLong(0L);
            closeableSizeTByReference.close();
            return l4;
        }
    }

    public static String sysctl(int[] nArray, String string) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            Memory memory;
            block14: {
                if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)nArray, (Object)Native.getLastError());
                    String string2 = string;
                    return string2;
                }
                memory = new Memory(closeableSizeTByReference.longValue() + 1L);
                try {
                    if (0 == OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) break block14;
                    LOG.warn("Failed sysctl call: {}, Error code: {}", (Object)nArray, (Object)Native.getLastError());
                    String string3 = string;
                    memory.close();
                    return string3;
                }
                catch (Throwable throwable) {
                    try {
                        memory.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            String string4 = memory.getString(0L);
            memory.close();
            return string4;
        }
    }

    public static Memory sysctl(int[] nArray) {
        try (ByRef.CloseableSizeTByReference closeableSizeTByReference = new ByRef.CloseableSizeTByReference();){
            if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, null, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error("Failed sysctl call: {}, Error code: {}", (Object)nArray, (Object)Native.getLastError());
                Memory memory = null;
                return memory;
            }
            Memory memory = new Memory(closeableSizeTByReference.longValue());
            if (0 != OpenBsdLibc.INSTANCE.sysctl(nArray, nArray.length, memory, closeableSizeTByReference, null, LibCAPI.size_t.ZERO)) {
                LOG.error("Failed sysctl call: {}, Error code: {}", (Object)nArray, (Object)Native.getLastError());
                memory.close();
                Memory memory2 = null;
                return memory2;
            }
            Memory memory3 = memory;
            return memory3;
        }
    }

    public static int sysctl(String string, int n2) {
        return ParseUtil.parseIntOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n " + string), n2);
    }

    public static long sysctl(String string, long l2) {
        return ParseUtil.parseLongOrDefault(ExecutingCommand.getFirstAnswer("sysctl -n " + string), l2);
    }

    public static String sysctl(String string, String string2) {
        String string3 = ExecutingCommand.getFirstAnswer("sysctl -n " + string);
        if (null == string3 || string3.isEmpty()) {
            return string2;
        }
        return string3;
    }
}

