package com.gradle.scan.plugin;

import com.gradle.obfuscation.Keep;

import java.net.InetAddress;
import java.util.List;
import java.util.function.Function;

/**
 * Allows registering functions for obfuscating certain identifying information within build scans.
 *
 * @see BuildScanExtension#getObfuscation()
 * @deprecated since 3.17, replaced by {@link com.gradle.develocity.agent.gradle.scan.BuildScanDataObfuscationConfiguration}
 */
@Keep
@Deprecated
public interface BuildScanDataObfuscation {

    /**
     * Registers a function to transform the <em>username</em> captured.
     * <p>
     * The function receives the username that would be captured,
     * and should return the username that will be captured.
     * <p>
     * The received username may be <code>null</code>,
     * and the function may return a <code>null</code> value.
     *
     * @param obfuscator the function to obfuscate the username
     * @since 2.4.2
     */
    void username(Function<? super String, ? extends String> obfuscator);

    /**
     * Registers a function to transform the <em>local hostname</em> and <em>public hostname</em> captured.
     * <p>
     * The function receives the hostname that would be captured,
     * and should return the hostname that will be captured.
     * <p>
     * The received hostname may be <code>null</code>,
     * and the function may return a <code>null</code> value.
     *
     * @param obfuscator the function to obfuscate the hostname
     * @since 2.4.2
     */
    void hostname(Function<? super String, ? extends String> obfuscator);

    /**
     * Registers a function used to transform the <em>IP addresses</em> captured.
     * <p>
     * The function receives a list of {@link InetAddress} that would be captured,
     * and should return the list of {@link String} that will be captured.
     * <p>
     * The received list may be <code>null</code> or empty,
     * and the function may return a <code>null</code> or empty list,
     * but may not return a list with a <code>null</code> element.
     *
     * @param obfuscator the function to obfuscate the IP addresses
     * @since 2.4.2
     */
    void ipAddresses(Function<? super List<InetAddress>, ? extends List<String>> obfuscator);

    /**
     * Registers a function to transform the names of <em>external processes</em> captured when resource usage capturing is enabled.
     * <p>
     * An external process is a process running on the same machine as the build, that is not the build process itself, nor a descendant process of the build process.
     * The function receives an external process name that would be captured,
     * and should return the external process name that will be captured.
     * <p>
     * The received process name may not be <code>null</code>,
     * and the function may not return a <code>null</code> value.
     *
     * @param obfuscator the function to obfuscate the external process names
     * @since 3.18
     */
    void externalProcessName(Function<? super String, ? extends String> obfuscator);

}
