/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.develocity.agent.maven.adapters;

import com.gradle.develocity.agent.maven.adapters.ReflectionUtils;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class Property<T> {
    private final Consumer<T> setter;
    private final Supplier<T> getter;

    private Property(Consumer<T> setter, Supplier<T> getter) {
        this.setter = setter;
        this.getter = getter;
    }

    public static <T> Property<T> create(Consumer<T> setter, Supplier<T> getter) {
        return new Property<T>(setter, getter);
    }

    public static <T> Property<T> optional(Object obj, String setterName, String getterName) {
        return new Property<Object>(value -> Property.setIfSupported(obj, setterName, value), () -> Property.getIfSupported(obj, getterName));
    }

    public void set(T value) {
        this.setter.accept(value);
    }

    public T get() {
        return this.getter.get();
    }

    private static <T> void setIfSupported(Object obj, String method, T value) {
        ReflectionUtils.invokeMethod(obj, method, value);
    }

    private static <T> T getIfSupported(Object obj, String method) {
        return (T)ReflectionUtils.invokeMethod(obj, method, new Object[0]);
    }
}

