/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.maven.extension.api.GradleEnterpriseApi;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.File;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.monitor.logging.DefaultLog;
import org.codehaus.plexus.logging.Logger;

final class GroovyScriptUserData {
    static void evaluate(MavenSession session, GradleEnterpriseApi gradleEnterprise, Logger logger) throws MavenExecutionException {
        File groovyScript = GroovyScriptUserData.getGroovyScript(session);
        if (groovyScript.exists()) {
            logger.debug("Evaluating custom user data Groovy script: " + groovyScript);
            GroovyScriptUserData.evaluateGroovyScript(session, gradleEnterprise, logger, groovyScript);
        } else {
            logger.debug("Skipping evaluation of custom user data Groovy script because it does not exist: " + groovyScript);
        }
    }

    private static File getGroovyScript(MavenSession session) {
        File rootDir = session.getRequest().getMultiModuleProjectDirectory();
        return new File(rootDir, ".mvn/gradle-enterprise-custom-user-data.groovy");
    }

    private static void evaluateGroovyScript(MavenSession session, GradleEnterpriseApi gradleEnterprise, Logger logger, File groovyScript) throws MavenExecutionException {
        try {
            Binding binding = GroovyScriptUserData.prepareBinding(session, gradleEnterprise, logger);
            new GroovyShell(GroovyScriptUserData.class.getClassLoader(), binding).evaluate(groovyScript);
        }
        catch (Exception e) {
            throw new MavenExecutionException("Failed to evaluate custom user data Groovy script: " + groovyScript, (Throwable)e);
        }
    }

    private static Binding prepareBinding(MavenSession session, GradleEnterpriseApi gradleEnterprise, Logger logger) {
        Binding binding = new Binding();
        binding.setVariable("project", (Object)session.getTopLevelProject());
        binding.setVariable("session", (Object)session);
        binding.setVariable("gradleEnterprise", (Object)gradleEnterprise);
        binding.setVariable("buildScan", (Object)gradleEnterprise.getBuildScan());
        binding.setVariable("buildCache", (Object)gradleEnterprise.getBuildCache());
        binding.setVariable("log", (Object)new DefaultLog(logger));
        return binding;
    }

    private GroovyScriptUserData() {
    }
}

