/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.maven.extension.api.GradleEnterpriseApi;
import java.util.Comparator;
import java.util.Optional;
import org.apache.maven.MavenExecutionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

final class ApiAccessor {
    private static final String GRADLE_ENTERPRISE_API_PACKAGE = "com.gradle.maven.extension.api";
    private static final String GRADLE_ENTERPRISE_API_CONTAINER_OBJECT = "com.gradle.maven.extension.api.GradleEnterpriseApi";

    static GradleEnterpriseApi lookupGradleEnterpriseApi(PlexusContainer container, Class<?> extensionClass) throws MavenExecutionException {
        ApiAccessor.ensureClassIsAccessible(extensionClass, GRADLE_ENTERPRISE_API_PACKAGE);
        return ApiAccessor.componentExists(GRADLE_ENTERPRISE_API_CONTAINER_OBJECT, container) ? ApiAccessor.lookupClass(GradleEnterpriseApi.class, container) : null;
    }

    private static void ensureClassIsAccessible(Class<?> extensionClass, String componentPackage) throws MavenExecutionException {
        Optional<ClassRealm> sourceRealm;
        ClassRealm extensionRealm;
        ClassLoader classLoader = extensionClass.getClassLoader();
        if (classLoader instanceof ClassRealm && !"maven.ext".equals((extensionRealm = (ClassRealm)classLoader).getId()) && (sourceRealm = extensionRealm.getWorld().getRealms().stream().filter(realm -> realm.getId().contains("com.gradle:gradle-enterprise-maven-extension") || realm.getId().equals("maven.ext")).max(Comparator.comparing(realm -> realm.getId().length()))).isPresent()) {
            String sourceRealmId = sourceRealm.get().getId();
            try {
                extensionRealm.importFrom(sourceRealmId, componentPackage);
            }
            catch (Exception e) {
                throw new MavenExecutionException("Could not import package from realm with id " + sourceRealmId, (Throwable)e);
            }
        }
    }

    private static boolean componentExists(String component, PlexusContainer container) {
        return container.hasComponent(component);
    }

    private static <T> T lookupClass(Class<T> componentClass, PlexusContainer container) throws MavenExecutionException {
        try {
            return (T)container.lookup(componentClass);
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException(String.format("Cannot look up object in container: %s", componentClass), (Throwable)e);
        }
    }

    private ApiAccessor() {
    }
}

