/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.ApiAccessor;
import com.gradle.CustomBuildScanEnhancements;
import com.gradle.CustomGradleEnterpriseConfig;
import com.gradle.GroovyScriptUserData;
import com.gradle.SystemPropertyOverrides;
import com.gradle.maven.extension.api.GradleEnterpriseApi;
import com.gradle.maven.extension.api.cache.BuildCacheApi;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import javax.inject.Inject;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="common-custom-user-data", description="Captures common custom user data in Maven build scans")
public final class CommonCustomUserDataMavenExtension
extends AbstractMavenLifecycleParticipant {
    private final PlexusContainer container;
    private final Logger logger;

    @Inject
    public CommonCustomUserDataMavenExtension(PlexusContainer container, Logger logger) {
        this.container = container;
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.logger.debug("Executing extension: " + ((Object)((Object)this)).getClass().getSimpleName());
        GradleEnterpriseApi gradleEnterprise = ApiAccessor.lookupGradleEnterpriseApi(this.container, ((Object)((Object)this)).getClass());
        if (gradleEnterprise != null) {
            CustomGradleEnterpriseConfig customGradleEnterpriseConfig = new CustomGradleEnterpriseConfig();
            this.logger.debug("Configuring Gradle Enterprise");
            customGradleEnterpriseConfig.configureGradleEnterprise(gradleEnterprise);
            this.logger.debug("Finished configuring Gradle Enterprise");
            this.logger.debug("Configuring build scan publishing and applying build scan enhancements");
            BuildScanApi buildScan = gradleEnterprise.getBuildScan();
            customGradleEnterpriseConfig.configureBuildScanPublishing(buildScan);
            new CustomBuildScanEnhancements(buildScan, session).apply();
            this.logger.debug("Finished configuring build scan publishing and applying build scan enhancements");
            this.logger.debug("Configuring build cache");
            BuildCacheApi buildCache = gradleEnterprise.getBuildCache();
            customGradleEnterpriseConfig.configureBuildCache(buildCache);
            this.logger.debug("Finished configuring build cache");
            GroovyScriptUserData.evaluate(session, gradleEnterprise, this.logger);
            SystemPropertyOverrides.configureBuildCache(buildCache);
        } else {
            this.logger.debug("Could not find GradleEnterpriseApi component in Plexus container");
        }
    }
}

