/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.Utils;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.execution.MavenSession;

final class CustomBuildScanEnhancements {
    static void configureBuildScan(BuildScanApi buildScan, MavenSession mavenSession) {
        new CustomBuildScanEnhancer(buildScan, mavenSession).enhance();
    }

    private CustomBuildScanEnhancements() {
    }

    private static class CustomBuildScanEnhancer {
        private final BuildScanApi buildScan;
        private final MavenSession mavenSession;

        private CustomBuildScanEnhancer(BuildScanApi buildScan, MavenSession mavenSession) {
            this.buildScan = buildScan;
            this.mavenSession = mavenSession;
        }

        private Optional<String> projectProperty(String name) {
            String value = this.mavenSession.getSystemProperties().getProperty(name);
            return Optional.ofNullable(value);
        }

        public void enhance() {
            this.captureOs();
            this.captureIde();
            this.captureCiOrLocal();
            this.captureCiMetadata();
            this.captureGitMetadata();
        }

        private void captureOs() {
            Utils.sysProperty("os.name").ifPresent(arg_0 -> ((BuildScanApi)this.buildScan).tag(arg_0));
        }

        private void captureIde() {
            if (Utils.sysProperty("idea.version").isPresent() || Utils.sysPropertyKeyStartingWith("idea.version")) {
                this.buildScan.tag("IntelliJ IDEA");
            } else if (Utils.sysProperty("eclipse.buildId").isPresent()) {
                this.buildScan.tag("Eclipse");
            } else if (!CustomBuildScanEnhancer.isCi()) {
                this.buildScan.tag("Cmd Line");
            }
        }

        private void captureCiOrLocal() {
            this.buildScan.tag(CustomBuildScanEnhancer.isCi() ? "CI" : "LOCAL");
        }

        private void captureCiMetadata() {
            if (CustomBuildScanEnhancer.isJenkins() || CustomBuildScanEnhancer.isHudson()) {
                Utils.envVariable("BUILD_URL").ifPresent(url -> this.buildScan.link(CustomBuildScanEnhancer.isJenkins() ? "Jenkins build" : "Hudson build", url));
                Utils.envVariable("BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("NODE_NAME").ifPresent(value2 -> this.addCustomValueAndSearchLink("CI node", (String)value2));
                Utils.envVariable("JOB_NAME").ifPresent(value1 -> this.addCustomValueAndSearchLink("CI job", (String)value1));
                Utils.envVariable("STAGE_NAME").ifPresent(value -> this.addCustomValueAndSearchLink("CI stage", (String)value));
            }
            if (CustomBuildScanEnhancer.isTeamCity()) {
                Properties properties;
                String teamCityServerUrl;
                Optional<String> teamCityConfigFile = this.projectProperty("teamcity.configuration.properties.file");
                Optional<String> buildNumber = this.projectProperty("build.number");
                Optional<String> buildTypeId = this.projectProperty("teamcity.buildType.id");
                Optional<String> agentName = this.projectProperty("agent.name");
                if (teamCityConfigFile.isPresent() && buildNumber.isPresent() && buildTypeId.isPresent() && (teamCityServerUrl = (properties = Utils.readPropertiesFile(teamCityConfigFile.get())).getProperty("teamcity.serverUrl")) != null) {
                    String buildUrl = Utils.appendIfMissing(teamCityServerUrl, "/") + "viewLog.html?buildNumber=" + buildNumber.get() + "&buildTypeId=" + buildTypeId.get();
                    this.buildScan.link("TeamCity build", buildUrl);
                }
                buildNumber.ifPresent(value -> this.buildScan.value("CI build number", value));
                agentName.ifPresent(value -> this.addCustomValueAndSearchLink("CI agent", (String)value));
            }
            if (CustomBuildScanEnhancer.isCircleCI()) {
                Utils.envVariable("CIRCLE_BUILD_URL").ifPresent(url -> this.buildScan.link("CircleCI build", url));
                Utils.envVariable("CIRCLE_BUILD_NUM").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("CIRCLE_JOB").ifPresent(value1 -> this.addCustomValueAndSearchLink("CI job", (String)value1));
                Utils.envVariable("CIRCLE_WORKFLOW_ID").ifPresent(value -> this.addCustomValueAndSearchLink("CI workflow", (String)value));
            }
            if (CustomBuildScanEnhancer.isBamboo()) {
                Utils.envVariable("bamboo_resultsUrl").ifPresent(url -> this.buildScan.link("Bamboo build", url));
                Utils.envVariable("bamboo_buildNumber").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("bamboo_planName").ifPresent(value2 -> this.addCustomValueAndSearchLink("CI plan", (String)value2));
                Utils.envVariable("bamboo_buildPlanName").ifPresent(value1 -> this.addCustomValueAndSearchLink("CI build plan", (String)value1));
                Utils.envVariable("bamboo_agentId").ifPresent(value -> this.addCustomValueAndSearchLink("CI agent", (String)value));
            }
            if (CustomBuildScanEnhancer.isGitHubActions()) {
                Optional<String> gitHubRepository = Utils.envVariable("GITHUB_REPOSITORY");
                Optional<String> gitHubRunId = Utils.envVariable("GITHUB_RUN_ID");
                if (gitHubRepository.isPresent() && gitHubRunId.isPresent()) {
                    this.buildScan.link("GitHub Actions build", "https://github.com/" + gitHubRepository.get() + "/actions/runs/" + gitHubRunId.get());
                }
                Utils.envVariable("GITHUB_WORKFLOW").ifPresent(value -> this.addCustomValueAndSearchLink("GitHub workflow", (String)value));
            }
            if (CustomBuildScanEnhancer.isGitLab()) {
                Utils.envVariable("CI_JOB_URL").ifPresent(url1 -> this.buildScan.link("GitLab build", url1));
                Utils.envVariable("CI_PIPELINE_URL").ifPresent(url -> this.buildScan.link("GitLab pipeline", url));
                Utils.envVariable("CI_JOB_NAME").ifPresent(value1 -> this.addCustomValueAndSearchLink("CI job", (String)value1));
                Utils.envVariable("CI_JOB_STAGE").ifPresent(value -> this.addCustomValueAndSearchLink("CI stage", (String)value));
            }
            if (CustomBuildScanEnhancer.isTravis()) {
                Utils.envVariable("TRAVIS_BUILD_WEB_URL").ifPresent(url -> this.buildScan.link("Travis build", url));
                Utils.envVariable("TRAVIS_BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("TRAVIS_JOB_NAME").ifPresent(value -> this.addCustomValueAndSearchLink("CI job", (String)value));
                Utils.envVariable("TRAVIS_EVENT_TYPE").ifPresent(arg_0 -> ((BuildScanApi)this.buildScan).tag(arg_0));
            }
            if (CustomBuildScanEnhancer.isBitrise()) {
                Utils.envVariable("BITRISE_BUILD_URL").ifPresent(url -> this.buildScan.link("Bitrise build", url));
                Utils.envVariable("BITRISE_BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
            }
        }

        private static boolean isCi() {
            return CustomBuildScanEnhancer.isGenericCI() || CustomBuildScanEnhancer.isJenkins() || CustomBuildScanEnhancer.isHudson() || CustomBuildScanEnhancer.isTeamCity() || CustomBuildScanEnhancer.isCircleCI() || CustomBuildScanEnhancer.isBamboo() || CustomBuildScanEnhancer.isGitHubActions() || CustomBuildScanEnhancer.isGitLab() || CustomBuildScanEnhancer.isTravis() || CustomBuildScanEnhancer.isBitrise();
        }

        private static boolean isGenericCI() {
            return Utils.envVariable("CI").isPresent() || Utils.sysProperty("CI").isPresent();
        }

        private static boolean isJenkins() {
            return Utils.envVariable("JENKINS_URL").isPresent();
        }

        private static boolean isHudson() {
            return Utils.envVariable("HUDSON_URL").isPresent();
        }

        private static boolean isTeamCity() {
            return Utils.envVariable("TEAMCITY_VERSION").isPresent();
        }

        private static boolean isCircleCI() {
            return Utils.envVariable("CIRCLE_BUILD_URL").isPresent();
        }

        private static boolean isBamboo() {
            return Utils.envVariable("bamboo_resultsUrl").isPresent();
        }

        private static boolean isGitHubActions() {
            return Utils.envVariable("GITHUB_ACTIONS").isPresent();
        }

        private static boolean isGitLab() {
            return Utils.envVariable("GITLAB_CI").isPresent();
        }

        private static boolean isTravis() {
            return Utils.envVariable("TRAVIS_JOB_ID").isPresent();
        }

        private static boolean isBitrise() {
            return Utils.envVariable("BITRISE_BUILD_URL").isPresent();
        }

        private void captureGitMetadata() {
            this.buildScan.background(api -> {
                if (!CustomBuildScanEnhancer.isGitInstalled()) {
                    return;
                }
                String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
                String gitBranchName = Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD");
                String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
                if (gitCommitId != null) {
                    this.addCustomValueAndSearchLink("Git commit id", gitCommitId);
                    String originUrl = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
                    if (Utils.isNotEmpty(originUrl)) {
                        Matcher matcher;
                        if (originUrl.contains("github.com/") || originUrl.contains("github.com:")) {
                            Matcher matcher2 = Pattern.compile("(.*)github\\.com[/|:](.*)").matcher(originUrl);
                            if (matcher2.matches()) {
                                String rawRepoPath = matcher2.group(2);
                                String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                                api.link("Github source", "https://github.com/" + repoPath + "/tree/" + gitCommitId);
                            }
                        } else if ((originUrl.contains("gitlab.com/") || originUrl.contains("gitlab.com:")) && (matcher = Pattern.compile("(.*)gitlab\\.com[/|:](.*)").matcher(originUrl)).matches()) {
                            String rawRepoPath = matcher.group(2);
                            String repoPath = rawRepoPath.endsWith(".git") ? rawRepoPath.substring(0, rawRepoPath.length() - 4) : rawRepoPath;
                            api.link("GitLab Source", "https://gitlab.com/" + repoPath + "/-/commit/" + gitCommitId);
                        }
                    }
                }
                if (Utils.isNotEmpty(gitBranchName)) {
                    api.tag(gitBranchName);
                    api.value("Git branch", gitBranchName);
                }
                if (Utils.isNotEmpty(gitStatus)) {
                    api.tag("Dirty");
                    api.value("Git status", gitStatus);
                }
            });
        }

        private static boolean isGitInstalled() {
            return Utils.execAndCheckSuccess("git", "--version");
        }

        private void addCustomValueAndSearchLink(String label, String value) {
            this.buildScan.value(label, value);
            String server = this.buildScan.getServer();
            if (server != null) {
                String searchParams = "search.names=" + Utils.urlEncode(label) + "&search.values=" + Utils.urlEncode(value);
                String url = Utils.appendIfMissing(server, "/") + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
                this.buildScan.link(label + " build scans", url);
            }
        }
    }
}

