/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.BuildScanApiAccessor;
import com.gradle.CustomUserData;
import com.gradle.GroovyScriptUserData;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import javax.inject.Inject;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenSession;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.logging.Logger;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="common-custom-user-data")
public final class CommonCustomUserDataMavenExtension
extends AbstractMavenLifecycleParticipant {
    private final PlexusContainer container;
    private final Logger logger;

    @Inject
    public CommonCustomUserDataMavenExtension(PlexusContainer container, Logger logger) {
        this.container = container;
        this.logger = logger;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        this.logger.debug("Executing extension: " + ((Object)((Object)this)).getClass().getSimpleName());
        BuildScanApi buildScan = BuildScanApiAccessor.lookup(this.container, ((Object)((Object)this)).getClass());
        if (buildScan != null) {
            this.logger.debug("Capturing custom user data in build scan");
            CustomUserData.addToBuildScan(buildScan);
            GroovyScriptUserData.addToBuildScan(session, buildScan, this.logger);
            this.logger.debug("Finished capturing custom user data in build scans");
        }
    }
}

