/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.CiUtils;
import com.gradle.Utils;
import com.gradle.maven.extension.api.scan.BuildScanApi;
import java.net.URI;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.maven.execution.MavenSession;

final class CustomBuildScanEnhancements {
    private static final String SYSTEM_PROP_IDEA_VENDOR_NAME = "idea.vendor.name";
    private static final String SYSTEM_PROP_IDEA_VERSION = "idea.version";
    private static final String SYSTEM_PROP_ECLIPSE_BUILD_ID = "eclipse.buildId";
    private static final String SYSTEM_PROP_IDEA_SYNC_ACTIVE = "idea.sync.active";
    private final BuildScanApi buildScan;
    private final MavenSession mavenSession;

    CustomBuildScanEnhancements(BuildScanApi buildScan, MavenSession mavenSession) {
        this.buildScan = buildScan;
        this.mavenSession = mavenSession;
    }

    void apply() {
        this.captureOs();
        this.captureIde();
        this.captureCiOrLocal();
        this.captureCiMetadata();
        this.captureGitMetadata();
        this.captureSkipTestsFlags();
    }

    private void captureOs() {
        Utils.sysProperty("os.name").ifPresent(arg_0 -> ((BuildScanApi)this.buildScan).tag(arg_0));
    }

    private void captureIde() {
        if (!CiUtils.isCi()) {
            HashMap<String, Optional<String>> ideProperties = new HashMap<String, Optional<String>>();
            ideProperties.put(SYSTEM_PROP_IDEA_VENDOR_NAME, Utils.sysProperty(SYSTEM_PROP_IDEA_VENDOR_NAME));
            ideProperties.put(SYSTEM_PROP_IDEA_VERSION, Utils.sysProperty(SYSTEM_PROP_IDEA_VERSION));
            ideProperties.put(SYSTEM_PROP_ECLIPSE_BUILD_ID, Utils.sysProperty(SYSTEM_PROP_ECLIPSE_BUILD_ID));
            ideProperties.put(SYSTEM_PROP_IDEA_SYNC_ACTIVE, Utils.sysProperty(SYSTEM_PROP_IDEA_SYNC_ACTIVE));
            new CaptureIdeMetadataAction(this.buildScan, ideProperties).execute();
        }
    }

    private void captureCiOrLocal() {
        this.buildScan.tag(CiUtils.isCi() ? "CI" : "LOCAL");
    }

    private void captureCiMetadata() {
        if (CiUtils.isCi()) {
            new CaptureCiMetadataAction(this.buildScan).execute();
        }
    }

    private void captureGitMetadata() {
        this.buildScan.background((Consumer)new CaptureGitMetadataAction());
    }

    private void captureSkipTestsFlags() {
        this.addCustomValueWhenProjectPropertyResolvesToTrue("skipITs");
        this.addCustomValueWhenProjectPropertyResolvesToTrue("skipTests");
        this.addCustomValueWhenProjectPropertyResolvesToTrue("maven.test.skip");
    }

    private void addCustomValueWhenProjectPropertyResolvesToTrue(String property) {
        Utils.projectProperty(this.mavenSession, property).ifPresent(value -> {
            if (value.isEmpty() || Boolean.valueOf(value).equals(Boolean.TRUE)) {
                this.buildScan.value("switches." + property, "On");
            }
        });
    }

    private static void addCustomValueAndSearchLink(BuildScanApi buildScan, String name, String value) {
        CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, name, name, value);
    }

    private static void addCustomValueAndSearchLink(BuildScanApi buildScan, String linkLabel, String name, String value) {
        buildScan.value(name, value);
        buildScan.buildFinished(result -> CustomBuildScanEnhancements.addSearchLink(buildScan, linkLabel, name, value));
    }

    private static void addSearchLink(BuildScanApi buildScan, String linkLabel, Map<String, String> values) {
        values.entrySet().stream().sorted(Map.Entry.comparingByKey()).reduce((a, b) -> new AbstractMap.SimpleEntry<String, String>((String)a.getKey() + "," + (String)b.getKey(), (String)a.getValue() + "," + (String)b.getValue())).ifPresent(x -> buildScan.buildFinished(result -> CustomBuildScanEnhancements.addSearchLink(buildScan, linkLabel, (String)x.getKey(), (String)x.getValue())));
    }

    private static void addSearchLink(BuildScanApi buildScan, String linkLabel, String name, String value) {
        String server = buildScan.getServer();
        if (server != null) {
            String searchParams = "search.names=" + Utils.urlEncode(name) + "&search.values=" + Utils.urlEncode(value);
            String url = Utils.appendIfMissing(server, "/") + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
            buildScan.link(linkLabel + " build scans", url);
        }
    }

    private static final class CaptureGitMetadataAction
    implements Consumer<BuildScanApi> {
        private CaptureGitMetadataAction() {
        }

        @Override
        public void accept(BuildScanApi buildScan) {
            if (!this.isGitInstalled()) {
                return;
            }
            String gitRepo = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
            String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--verify", "HEAD");
            String gitCommitShortId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = this.getGitBranchName(() -> Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD"));
            String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
            if (Utils.isNotEmpty(gitRepo)) {
                buildScan.value("Git repository", Utils.redactUserInfo(gitRepo));
            }
            if (Utils.isNotEmpty(gitCommitId)) {
                buildScan.value("Git commit id", gitCommitId);
            }
            if (Utils.isNotEmpty(gitCommitShortId)) {
                CustomBuildScanEnhancements.addCustomValueAndSearchLink(buildScan, "Git commit id", "Git commit id short", gitCommitShortId);
            }
            if (Utils.isNotEmpty(gitBranchName)) {
                buildScan.tag(gitBranchName);
                buildScan.value("Git branch", gitBranchName);
            }
            if (Utils.isNotEmpty(gitStatus)) {
                buildScan.tag("Dirty");
                buildScan.value("Git status", gitStatus);
            }
            Optional<String> gitHubUrl = Utils.envVariable("GITHUB_SERVER_URL");
            Optional<String> gitRepository = Utils.envVariable("GITHUB_REPOSITORY");
            if (gitHubUrl.isPresent() && gitRepository.isPresent() && Utils.isNotEmpty(gitCommitId)) {
                buildScan.link("GitHub source", gitHubUrl.get() + "/" + gitRepository.get() + "/tree/" + gitCommitId);
            } else if (Utils.isNotEmpty(gitRepo) && Utils.isNotEmpty(gitCommitId)) {
                Optional<URI> webRepoUri = Utils.toWebRepoUri(gitRepo);
                webRepoUri.ifPresent(uri -> {
                    if (uri.getHost().contains("github")) {
                        buildScan.link("GitHub source", uri + "/tree/" + gitCommitId);
                    } else if (uri.getHost().contains("gitlab")) {
                        buildScan.link("GitLab source", uri + "/-/commit/" + gitCommitId);
                    }
                });
            }
        }

        private boolean isGitInstalled() {
            return Utils.execAndCheckSuccess("git", "--version");
        }

        private String getGitBranchName(Supplier<String> gitCommand) {
            Optional<String> branch;
            if (CiUtils.isJenkins() || CiUtils.isHudson()) {
                Optional<String> branch2 = Utils.envVariable("BRANCH_NAME");
                if (branch2.isPresent()) {
                    return branch2.get();
                }
            } else if (CiUtils.isGitLab()) {
                Optional<String> branch3 = Utils.envVariable("CI_COMMIT_REF_NAME");
                if (branch3.isPresent()) {
                    return branch3.get();
                }
            } else if (CiUtils.isAzurePipelines() && (branch = Utils.envVariable("BUILD_SOURCEBRANCH")).isPresent()) {
                return branch.get();
            }
            return gitCommand.get();
        }
    }

    private static final class CaptureCiMetadataAction {
        private final BuildScanApi buildScan;

        public CaptureCiMetadataAction(BuildScanApi buildScan) {
            this.buildScan = buildScan;
        }

        private void execute() {
            String buildUrl;
            if (CiUtils.isJenkins() || CiUtils.isHudson()) {
                String ciProvider = CiUtils.isJenkins() ? "Jenkins" : "Hudson";
                String controllerUrlEnvVar = CiUtils.isJenkins() ? "JENKINS_URL" : "HUDSON_URL";
                Optional<String> buildUrl2 = Utils.envVariable("BUILD_URL");
                Optional<String> buildNumber = Utils.envVariable("BUILD_NUMBER");
                Optional<String> nodeName = Utils.envVariable("NODE_NAME");
                Optional<String> jobName = Utils.envVariable("JOB_NAME");
                Optional<String> stageName = Utils.envVariable("STAGE_NAME");
                Optional<String> controllerUrl = Utils.envVariable(controllerUrlEnvVar);
                this.buildScan.value("CI provider", ciProvider);
                buildUrl2.ifPresent(url -> this.buildScan.link(CiUtils.isJenkins() ? "Jenkins build" : "Hudson build", url));
                buildNumber.ifPresent(value -> this.buildScan.value("CI build number", value));
                nodeName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI node", value));
                jobName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                stageName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI stage", value));
                controllerUrl.ifPresent(value -> this.buildScan.value("CI controller", value));
                jobName.ifPresent(j -> buildNumber.ifPresent(b -> {
                    LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                    params.put("CI job", (String)j);
                    params.put("CI build number", (String)b);
                    CustomBuildScanEnhancements.addSearchLink(this.buildScan, "CI pipeline", params);
                }));
            }
            if (CiUtils.isTeamCity()) {
                this.buildScan.value("CI provider", "TeamCity");
                Optional<String> teamcityBuildPropertiesFile = Utils.envVariable("TEAMCITY_BUILD_PROPERTIES_FILE");
                if (teamcityBuildPropertiesFile.isPresent()) {
                    String teamCityAgentName;
                    String teamCityBuildTypeId;
                    String teamCityBuildNumber;
                    Properties configProperties;
                    String teamCityServerUrl;
                    String teamcityConfigFile;
                    Properties buildProperties = Utils.readPropertiesFile(teamcityBuildPropertiesFile.get());
                    String teamCityBuildId = buildProperties.getProperty("teamcity.build.id");
                    if (Utils.isNotEmpty(teamCityBuildId) && Utils.isNotEmpty(teamcityConfigFile = buildProperties.getProperty("teamcity.configuration.properties.file")) && Utils.isNotEmpty(teamCityServerUrl = (configProperties = Utils.readPropertiesFile(teamcityConfigFile)).getProperty("teamcity.serverUrl"))) {
                        buildUrl = Utils.appendIfMissing(teamCityServerUrl, "/") + "viewLog.html?buildId=" + Utils.urlEncode(teamCityBuildId);
                        this.buildScan.link("TeamCity build", buildUrl);
                    }
                    if (Utils.isNotEmpty(teamCityBuildNumber = buildProperties.getProperty("build.number"))) {
                        this.buildScan.value("CI build number", teamCityBuildNumber);
                    }
                    if (Utils.isNotEmpty(teamCityBuildTypeId = buildProperties.getProperty("teamcity.buildType.id"))) {
                        CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI build config", teamCityBuildTypeId);
                    }
                    if (Utils.isNotEmpty(teamCityAgentName = buildProperties.getProperty("agent.name"))) {
                        CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI agent", teamCityAgentName);
                    }
                }
            }
            if (CiUtils.isCircleCI()) {
                this.buildScan.value("CI provider", "CircleCI");
                Utils.envVariable("CIRCLE_BUILD_URL").ifPresent(url -> this.buildScan.link("CircleCI build", url));
                Utils.envVariable("CIRCLE_BUILD_NUM").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("CIRCLE_JOB").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                Utils.envVariable("CIRCLE_WORKFLOW_ID").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI workflow", value));
            }
            if (CiUtils.isBamboo()) {
                this.buildScan.value("CI provider", "Bamboo");
                Utils.envVariable("bamboo_resultsUrl").ifPresent(url -> this.buildScan.link("Bamboo build", url));
                Utils.envVariable("bamboo_buildNumber").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("bamboo_planName").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI plan", value));
                Utils.envVariable("bamboo_buildPlanName").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI build plan", value));
                Utils.envVariable("bamboo_agentId").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI agent", value));
            }
            if (CiUtils.isGitHubActions()) {
                this.buildScan.value("CI provider", "GitHub Actions");
                Optional<String> gitHubUrl = Utils.envVariable("GITHUB_SERVER_URL");
                Optional<String> gitRepository = Utils.envVariable("GITHUB_REPOSITORY");
                Optional<String> gitHubRunId = Utils.envVariable("GITHUB_RUN_ID");
                if (gitHubUrl.isPresent() && gitRepository.isPresent() && gitHubRunId.isPresent()) {
                    this.buildScan.link("GitHub Actions build", gitHubUrl.get() + "/" + gitRepository.get() + "/actions/runs/" + gitHubRunId.get());
                }
                Utils.envVariable("GITHUB_WORKFLOW").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI workflow", value));
                Utils.envVariable("GITHUB_RUN_ID").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI run", value));
            }
            if (CiUtils.isGitLab()) {
                this.buildScan.value("CI provider", "GitLab");
                Utils.envVariable("CI_JOB_URL").ifPresent(url -> this.buildScan.link("GitLab build", url));
                Utils.envVariable("CI_PIPELINE_URL").ifPresent(url -> this.buildScan.link("GitLab pipeline", url));
                Utils.envVariable("CI_JOB_NAME").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                Utils.envVariable("CI_JOB_STAGE").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI stage", value));
            }
            if (CiUtils.isTravis()) {
                this.buildScan.value("CI provider", "Travis");
                Utils.envVariable("TRAVIS_BUILD_WEB_URL").ifPresent(url -> this.buildScan.link("Travis build", url));
                Utils.envVariable("TRAVIS_BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
                Utils.envVariable("TRAVIS_JOB_NAME").ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                Utils.envVariable("TRAVIS_EVENT_TYPE").ifPresent(arg_0 -> ((BuildScanApi)this.buildScan).tag(arg_0));
            }
            if (CiUtils.isBitrise()) {
                this.buildScan.value("CI provider", "Bitrise");
                Utils.envVariable("BITRISE_BUILD_URL").ifPresent(url -> this.buildScan.link("Bitrise build", url));
                Utils.envVariable("BITRISE_BUILD_NUMBER").ifPresent(value -> this.buildScan.value("CI build number", value));
            }
            if (CiUtils.isGoCD()) {
                this.buildScan.value("CI provider", "GoCD");
                Optional<String> pipelineName = Utils.envVariable("GO_PIPELINE_NAME");
                Optional<String> pipelineNumber = Utils.envVariable("GO_PIPELINE_COUNTER");
                Optional<String> stageName = Utils.envVariable("GO_STAGE_NAME");
                Optional<String> stageNumber = Utils.envVariable("GO_STAGE_COUNTER");
                Optional<String> jobName = Utils.envVariable("GO_JOB_NAME");
                Optional<String> goServerUrl = Utils.envVariable("GO_SERVER_URL");
                if (Stream.of(pipelineName, pipelineNumber, stageName, stageNumber, jobName, goServerUrl).allMatch(Optional::isPresent)) {
                    buildUrl = String.format("%s/tab/build/detail/%s/%s/%s/%s/%s", goServerUrl.get(), pipelineName.get(), pipelineNumber.get(), stageName.get(), stageNumber.get(), jobName.get());
                    this.buildScan.link("GoCD build", buildUrl);
                } else if (goServerUrl.isPresent()) {
                    this.buildScan.link("GoCD", goServerUrl.get());
                }
                pipelineName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI pipeline", value));
                jobName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI job", value));
                stageName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI stage", value));
            }
            if (CiUtils.isAzurePipelines()) {
                this.buildScan.value("CI provider", "Azure Pipelines");
                Optional<String> azureServerUrl = Utils.envVariable("SYSTEM_TEAMFOUNDATIONCOLLECTIONURI");
                Optional<String> azureProject = Utils.envVariable("SYSTEM_TEAMPROJECT");
                Optional<String> buildId = Utils.envVariable("BUILD_BUILDID");
                if (Stream.of(azureServerUrl, azureProject, buildId).allMatch(Optional::isPresent)) {
                    String buildUrl3 = String.format("%s%s/_build/results?buildId=%s", azureServerUrl.get(), azureProject.get(), buildId.get());
                    this.buildScan.link("Azure Pipelines build", buildUrl3);
                } else if (azureServerUrl.isPresent()) {
                    this.buildScan.link("Azure Pipelines", azureServerUrl.get());
                }
                buildId.ifPresent(value -> this.buildScan.value("CI build number", value));
            }
            if (CiUtils.isBuildkite()) {
                this.buildScan.value("CI provider", "Buildkite");
                Utils.envVariable("BUILDKITE_BUILD_URL").ifPresent(url -> this.buildScan.link("Buildkite build", url));
                Utils.envVariable("BUILDKITE_COMMAND").ifPresent(command -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.buildScan, "CI command", command));
                Utils.envVariable("BUILDKITE_BUILD_ID").ifPresent(id -> this.buildScan.value("CI build ID", id));
                Optional<String> buildkitePrRepo = Utils.envVariable("BUILDKITE_PULL_REQUEST_REPO");
                Optional<String> buildkitePrNumber = Utils.envVariable("BUILDKITE_PULL_REQUEST");
                if (buildkitePrRepo.isPresent() && buildkitePrNumber.isPresent()) {
                    String prNumber = buildkitePrNumber.get();
                    Utils.toWebRepoUri(buildkitePrRepo.get()).ifPresent(url -> this.buildScan.link("PR source", url + "/pull/" + prNumber));
                }
            }
        }
    }

    private static final class CaptureIdeMetadataAction {
        private final BuildScanApi buildScan;
        private final Map<String, Optional<String>> props;

        private CaptureIdeMetadataAction(BuildScanApi buildScan, Map<String, Optional<String>> props) {
            this.buildScan = buildScan;
            this.props = props;
        }

        private void execute() {
            if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VENDOR_NAME).isPresent()) {
                String ideaVendorNameValue = this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VENDOR_NAME).get();
                if ("JetBrains".equals(ideaVendorNameValue)) {
                    this.tagIde("IntelliJ IDEA", this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).orElse(""));
                }
            } else if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).isPresent()) {
                this.tagIde("IntelliJ IDEA", this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).get());
            } else if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_ECLIPSE_BUILD_ID).isPresent()) {
                this.tagIde("Eclipse", this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_ECLIPSE_BUILD_ID).get());
            } else {
                this.buildScan.tag("Cmd Line");
            }
            if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_SYNC_ACTIVE).isPresent()) {
                this.buildScan.tag("IDE sync");
            }
        }

        private void tagIde(String ideLabel, String version) {
            this.buildScan.tag(ideLabel);
            if (!version.isEmpty()) {
                this.buildScan.value(ideLabel + " version", version);
            }
        }
    }
}

