/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.maven.extension.api.scan.BuildScanApi;
import java.util.Comparator;
import java.util.Optional;
import org.apache.maven.MavenExecutionException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

final class BuildScanApiAccessor {
    private static final String PACKAGE = "com.gradle.maven.extension.api.scan";
    private static final String BUILD_SCAN_API_CONTAINER_OBJECT = "com.gradle.maven.extension.api.scan.BuildScanApi";

    static BuildScanApi lookup(PlexusContainer container, Class<?> extensionClass) throws MavenExecutionException {
        BuildScanApiAccessor.ensureBuildScanApiIsAccessible(extensionClass);
        try {
            return (BuildScanApi)container.lookup(BUILD_SCAN_API_CONTAINER_OBJECT);
        }
        catch (ComponentLookupException e) {
            throw new MavenExecutionException(String.format("Cannot look up object in container: %s", BUILD_SCAN_API_CONTAINER_OBJECT), (Throwable)e);
        }
    }

    private static void ensureBuildScanApiIsAccessible(Class<?> extensionClass) throws MavenExecutionException {
        Optional<ClassRealm> sourceRealm;
        ClassRealm extensionRealm;
        ClassLoader classLoader = extensionClass.getClassLoader();
        if (classLoader instanceof ClassRealm && !"maven.ext".equals((extensionRealm = (ClassRealm)classLoader).getId()) && (sourceRealm = extensionRealm.getWorld().getRealms().stream().filter(realm -> realm.getId().contains("com.gradle:gradle-enterprise-maven-extension") || realm.getId().equals("maven.ext")).max(Comparator.comparing(realm -> realm.getId().length()))).isPresent()) {
            String sourceRealmId = sourceRealm.get().getId();
            try {
                extensionRealm.importFrom(sourceRealmId, PACKAGE);
            }
            catch (Exception e) {
                throw new MavenExecutionException("Could not import package from realm with id " + sourceRealmId, (Throwable)e);
            }
        }
    }

    private BuildScanApiAccessor() {
    }
}

