/*
 * Decompiled with CFR 0.152.
 */
package com.gradle;

import com.gradle.CiUtils;
import com.gradle.Utils;
import com.gradle.develocity.agent.gradle.adapters.BuildResultAdapter;
import com.gradle.develocity.agent.gradle.adapters.BuildScanAdapter;
import com.gradle.develocity.agent.gradle.adapters.DevelocityAdapter;
import java.net.URI;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;

final class CustomBuildScanEnhancements {
    private static final String SYSTEM_PROP_IDEA_VENDOR_NAME = "idea.vendor.name";
    private static final String SYSTEM_PROP_IDEA_VERSION = "idea.version";
    private static final String PROJECT_PROP_ANDROID_INVOKED_FROM_IDE = "android.injected.invoked.from.ide";
    private static final String PROJECT_PROP_ANDROID_STUDIO_VERSION_LEGACY = "android.injected.studio.version";
    private static final String PROJECT_PROP_ANDROID_STUDIO_VERSION = "android.studio.version";
    private static final String SYSTEM_PROP_ECLIPSE_BUILD_ID = "eclipse.buildId";
    private static final String SYSTEM_PROP_IDEA_SYNC_ACTIVE = "idea.sync.active";
    private final DevelocityAdapter develocity;
    private final BuildScanAdapter buildScan;
    private final ProviderFactory providers;
    private final Gradle gradle;

    CustomBuildScanEnhancements(DevelocityAdapter develocity, ProviderFactory providers, Gradle gradle) {
        this.develocity = develocity;
        this.buildScan = develocity.getBuildScan();
        this.providers = providers;
        this.gradle = gradle;
    }

    void apply() {
        this.captureOs();
        this.captureIde();
        this.captureCiOrLocal();
        this.captureCiMetadata();
        this.captureGitMetadata();
    }

    private void captureOs() {
        Utils.sysProperty("os.name", this.providers).ifPresent(this.buildScan::tag);
    }

    private void captureIde() {
        if (!CiUtils.isCi(this.providers)) {
            HashMap<String, Provider<String>> ideProperties = new HashMap<String, Provider<String>>();
            ideProperties.put(SYSTEM_PROP_IDEA_VENDOR_NAME, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_IDEA_VENDOR_NAME, this.providers));
            ideProperties.put(SYSTEM_PROP_IDEA_VERSION, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_IDEA_VERSION, this.providers));
            ideProperties.put(PROJECT_PROP_ANDROID_INVOKED_FROM_IDE, CustomBuildScanEnhancements.gradlePropertyProvider(PROJECT_PROP_ANDROID_INVOKED_FROM_IDE, this.gradle, this.providers));
            ideProperties.put(PROJECT_PROP_ANDROID_STUDIO_VERSION, CustomBuildScanEnhancements.firstOrElseSecond(this.providers, CustomBuildScanEnhancements.gradlePropertyProvider(PROJECT_PROP_ANDROID_STUDIO_VERSION, this.gradle, this.providers), CustomBuildScanEnhancements.gradlePropertyProvider(PROJECT_PROP_ANDROID_STUDIO_VERSION_LEGACY, this.gradle, this.providers)));
            ideProperties.put(SYSTEM_PROP_ECLIPSE_BUILD_ID, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_ECLIPSE_BUILD_ID, this.providers));
            ideProperties.put(SYSTEM_PROP_IDEA_SYNC_ACTIVE, CustomBuildScanEnhancements.systemPropertyProvider(SYSTEM_PROP_IDEA_SYNC_ACTIVE, this.providers));
            this.buildScan.buildFinished(new CaptureIdeMetadataAction(this.buildScan, ideProperties));
        }
    }

    private void captureCiOrLocal() {
        this.buildScan.tag(CiUtils.isCi(this.providers) ? "CI" : "LOCAL");
    }

    private void captureCiMetadata() {
        if (CiUtils.isCi(this.providers)) {
            Provider projectDirectory = this.providers.provider(() -> this.gradle.getRootProject().getLayout().getProjectDirectory());
            this.buildScan.buildFinished(new CaptureCiMetadataAction(this.develocity, this.providers, projectDirectory));
        }
    }

    private void captureGitMetadata() {
        this.buildScan.background(new CaptureGitMetadataAction(this.providers, this.develocity));
    }

    private static void addCustomValueAndSearchLink(DevelocityAdapter develocity, String name, String value) {
        develocity.getBuildScan().value(name, value);
        CustomBuildScanEnhancements.addSearchLink(develocity, name, name, value);
    }

    private static void addCustomValueAndSearchLink(DevelocityAdapter develocity, String linkLabel, String name, String value) {
        develocity.getBuildScan().value(name, value);
        CustomBuildScanEnhancements.addSearchLink(develocity, linkLabel, name, value);
    }

    private static void addSearchLink(DevelocityAdapter develocity, String linkLabel, Map<String, String> values) {
        values.entrySet().stream().sorted(Map.Entry.comparingByKey()).reduce((a, b) -> new AbstractMap.SimpleEntry<String, String>((String)a.getKey() + "," + (String)b.getKey(), (String)a.getValue() + "," + (String)b.getValue())).ifPresent(x -> CustomBuildScanEnhancements.addSearchLink(develocity, linkLabel, (String)x.getKey(), (String)x.getValue()));
    }

    private static void addSearchLink(DevelocityAdapter develocity, String linkLabel, String name, String value) {
        String searchParams = "search.names=" + Utils.urlEncode(name) + "&search.values=" + Utils.urlEncode(value);
        String server = develocity.getServer();
        if (server != null) {
            String url = Utils.appendIfMissing(server, '/') + "scans?" + searchParams + "#selection.buildScanB=" + Utils.urlEncode("{SCAN_ID}");
            develocity.getBuildScan().link(linkLabel + " build scans", url);
        }
    }

    private static Provider<String> systemPropertyProvider(String name, ProviderFactory providers) {
        if (Utils.isGradle61OrNewer()) {
            return providers.systemProperty(name);
        }
        return providers.provider(() -> System.getProperty(name));
    }

    private static Provider<String> gradlePropertyProvider(String name, Gradle gradle, ProviderFactory providers) {
        if (Utils.isGradle62OrNewer()) {
            return providers.gradleProperty(name);
        }
        return providers.provider(() -> (String)gradle.getRootProject().findProperty(name));
    }

    private static <T> Provider<T> firstOrElseSecond(ProviderFactory providers, Provider<T> overrideProperty, Provider<T> mainProperty) {
        if (Utils.isGradle56OrNewer()) {
            return overrideProperty.orElse(mainProperty);
        }
        return providers.provider(() -> overrideProperty.isPresent() ? overrideProperty.get() : mainProperty.getOrNull());
    }

    private static final class CaptureGitMetadataAction
    implements Action<BuildScanAdapter> {
        private final ProviderFactory providers;
        private final DevelocityAdapter develocity;

        private CaptureGitMetadataAction(ProviderFactory providers, DevelocityAdapter develocity) {
            this.providers = providers;
            this.develocity = develocity;
        }

        public void execute(BuildScanAdapter buildScan) {
            if (!this.isGitInstalled()) {
                return;
            }
            String gitRepo = Utils.execAndGetStdOut("git", "config", "--get", "remote.origin.url");
            String gitCommitId = Utils.execAndGetStdOut("git", "rev-parse", "--verify", "HEAD");
            String gitCommitShortId = Utils.execAndGetStdOut("git", "rev-parse", "--short=8", "--verify", "HEAD");
            String gitBranchName = this.getGitBranchName(() -> Utils.execAndGetStdOut("git", "rev-parse", "--abbrev-ref", "HEAD"));
            String gitStatus = Utils.execAndGetStdOut("git", "status", "--porcelain");
            if (Utils.isNotEmpty(gitRepo)) {
                buildScan.value("Git repository", Utils.redactUserInfo(gitRepo));
            }
            if (Utils.isNotEmpty(gitCommitId)) {
                buildScan.value("Git commit id", gitCommitId);
            }
            if (Utils.isNotEmpty(gitCommitShortId)) {
                buildScan.buildFinished((Action<? super BuildResultAdapter>)((Action)result -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "Git commit id", "Git commit id short", gitCommitShortId)));
            }
            if (Utils.isNotEmpty(gitBranchName)) {
                buildScan.tag(gitBranchName);
                buildScan.value("Git branch", gitBranchName);
            }
            if (Utils.isNotEmpty(gitStatus)) {
                buildScan.tag("Dirty");
                buildScan.value("Git status", gitStatus);
            }
            Optional<String> gitHubUrl = Utils.envVariable("GITHUB_SERVER_URL", this.providers);
            Optional<String> gitRepository = Utils.envVariable("GITHUB_REPOSITORY", this.providers);
            if (gitHubUrl.isPresent() && gitRepository.isPresent() && Utils.isNotEmpty(gitCommitId)) {
                buildScan.link("GitHub source", gitHubUrl.get() + "/" + gitRepository.get() + "/tree/" + gitCommitId);
            } else if (Utils.isNotEmpty(gitRepo) && Utils.isNotEmpty(gitCommitId)) {
                Optional<URI> webRepoUri = Utils.toWebRepoUri(gitRepo);
                webRepoUri.ifPresent(uri -> {
                    if (uri.getHost().contains("github")) {
                        buildScan.link("GitHub source", uri + "/tree/" + gitCommitId);
                    } else if (uri.getHost().contains("gitlab")) {
                        buildScan.link("GitLab source", uri + "/-/commit/" + gitCommitId);
                    }
                });
            }
        }

        private boolean isGitInstalled() {
            return Utils.execAndCheckSuccess("git", "--version");
        }

        private String getGitBranchName(Supplier<String> gitCommand) {
            Optional<String> branch;
            if (CiUtils.isJenkins(this.providers) || CiUtils.isHudson(this.providers)) {
                Optional<String> localBranch;
                Optional<String> branchName = Utils.envVariable("BRANCH_NAME", this.providers);
                if (branchName.isPresent()) {
                    return branchName.get();
                }
                Optional<String> gitBranch = Utils.envVariable("GIT_BRANCH", this.providers);
                if (gitBranch.isPresent() && (localBranch = CaptureGitMetadataAction.getLocalBranch(gitBranch.get())).isPresent()) {
                    return localBranch.get();
                }
            } else if (CiUtils.isGitLab(this.providers)) {
                Optional<String> branch2 = Utils.envVariable("CI_COMMIT_REF_NAME", this.providers);
                if (branch2.isPresent()) {
                    return branch2.get();
                }
            } else if (CiUtils.isAzurePipelines(this.providers)) {
                Optional<String> branch3 = Utils.envVariable("BUILD_SOURCEBRANCH", this.providers);
                if (branch3.isPresent()) {
                    return branch3.get();
                }
            } else if (CiUtils.isBuildkite(this.providers)) {
                Optional<String> branch4 = Utils.envVariable("BUILDKITE_BRANCH", this.providers);
                if (branch4.isPresent()) {
                    return branch4.get();
                }
            } else if (CiUtils.isGitHubActions(this.providers) && (branch = Utils.envVariable("GITHUB_REF_NAME", this.providers)).isPresent()) {
                return branch.get();
            }
            return gitCommand.get();
        }

        private static Optional<String> getLocalBranch(String remoteBranch) {
            Function<String, Optional> findLongestMatchingRemote = remotes -> Arrays.stream(remotes.split("\\R")).filter(remote -> remoteBranch.startsWith(remote + "/")).max(Comparator.comparingInt(String::length));
            return Optional.ofNullable(Utils.execAndGetStdOut("git", "remote")).filter(Utils::isNotEmpty).flatMap(findLongestMatchingRemote).map(remote -> remoteBranch.replaceFirst("^" + remote + "/", ""));
        }
    }

    private static final class CaptureCiMetadataAction
    implements Action<BuildResultAdapter> {
        private final DevelocityAdapter develocity;
        private final BuildScanAdapter buildScan;
        private final ProviderFactory providers;
        private final Provider<Directory> projectDirectory;

        private CaptureCiMetadataAction(DevelocityAdapter develocity, ProviderFactory providers, Provider<Directory> projectDirectory) {
            this.develocity = develocity;
            this.buildScan = develocity.getBuildScan();
            this.providers = providers;
            this.projectDirectory = projectDirectory;
        }

        public void execute(BuildResultAdapter buildResult) {
            String buildUrl;
            if (CiUtils.isJenkins(this.providers) || CiUtils.isHudson(this.providers)) {
                String ciProvider = CiUtils.isJenkins(this.providers) ? "Jenkins" : "Hudson";
                String controllerUrlEnvVar = CiUtils.isJenkins(this.providers) ? "JENKINS_URL" : "HUDSON_URL";
                Optional<String> buildUrl2 = Utils.envVariable("BUILD_URL", this.providers);
                Optional<String> buildNumber = Utils.envVariable("BUILD_NUMBER", this.providers);
                Optional<String> nodeName = Utils.envVariable("NODE_NAME", this.providers);
                Optional<String> jobName = Utils.envVariable("JOB_NAME", this.providers);
                Optional<String> stageName = Utils.envVariable("STAGE_NAME", this.providers);
                Optional<String> controllerUrl = Utils.envVariable(controllerUrlEnvVar, this.providers);
                this.buildScan.value("CI provider", ciProvider);
                buildUrl2.ifPresent(url -> this.buildScan.link(CiUtils.isJenkins(this.providers) ? "Jenkins build" : "Hudson build", (String)url));
                buildNumber.ifPresent(value -> this.buildScan.value("CI build number", (String)value));
                nodeName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI node", value));
                jobName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI job", value));
                stageName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI stage", value));
                controllerUrl.ifPresent(value -> this.buildScan.value("CI controller", (String)value));
                jobName.ifPresent(j -> buildNumber.ifPresent(b -> {
                    LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
                    params.put("CI job", (String)j);
                    params.put("CI build number", (String)b);
                    CustomBuildScanEnhancements.addSearchLink(this.develocity, "CI pipeline", params);
                }));
            }
            if (CiUtils.isTeamCity(this.providers)) {
                this.buildScan.value("CI provider", "TeamCity");
                Optional<String> teamcityBuildPropertiesFile = Utils.envVariable("TEAMCITY_BUILD_PROPERTIES_FILE", this.providers);
                if (teamcityBuildPropertiesFile.isPresent()) {
                    String teamCityAgentName;
                    String teamCityBuildTypeId;
                    String teamCityBuildNumber;
                    Properties configProperties;
                    String teamCityServerUrl;
                    String teamcityConfigFile;
                    Properties buildProperties = Utils.readPropertiesFile(teamcityBuildPropertiesFile.get(), this.providers, (Directory)this.projectDirectory.get());
                    String teamCityBuildId = buildProperties.getProperty("teamcity.build.id");
                    if (Utils.isNotEmpty(teamCityBuildId) && Utils.isNotEmpty(teamcityConfigFile = buildProperties.getProperty("teamcity.configuration.properties.file")) && Utils.isNotEmpty(teamCityServerUrl = (configProperties = Utils.readPropertiesFile(teamcityConfigFile, this.providers, (Directory)this.projectDirectory.get())).getProperty("teamcity.serverUrl"))) {
                        buildUrl = Utils.appendIfMissing(teamCityServerUrl, '/') + "viewLog.html?buildId=" + Utils.urlEncode(teamCityBuildId);
                        this.buildScan.link("TeamCity build", buildUrl);
                    }
                    if (Utils.isNotEmpty(teamCityBuildNumber = buildProperties.getProperty("build.number"))) {
                        this.buildScan.value("CI build number", teamCityBuildNumber);
                    }
                    if (Utils.isNotEmpty(teamCityBuildTypeId = buildProperties.getProperty("teamcity.buildType.id"))) {
                        CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI build config", teamCityBuildTypeId);
                    }
                    if (Utils.isNotEmpty(teamCityAgentName = buildProperties.getProperty("agent.name"))) {
                        CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI agent", teamCityAgentName);
                    }
                }
            }
            if (CiUtils.isCircleCI(this.providers)) {
                this.buildScan.value("CI provider", "CircleCI");
                Utils.envVariable("CIRCLE_BUILD_URL", this.providers).ifPresent(url -> this.buildScan.link("CircleCI build", (String)url));
                Utils.envVariable("CIRCLE_BUILD_NUM", this.providers).ifPresent(value -> this.buildScan.value("CI build number", (String)value));
                Utils.envVariable("CIRCLE_JOB", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI job", value));
                Utils.envVariable("CIRCLE_WORKFLOW_ID", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI workflow", value));
            }
            if (CiUtils.isBamboo(this.providers)) {
                this.buildScan.value("CI provider", "Bamboo");
                Utils.envVariable("bamboo_resultsUrl", this.providers).ifPresent(url -> this.buildScan.link("Bamboo build", (String)url));
                Utils.envVariable("bamboo_buildNumber", this.providers).ifPresent(value -> this.buildScan.value("CI build number", (String)value));
                Utils.envVariable("bamboo_planName", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI plan", value));
                Utils.envVariable("bamboo_buildPlanName", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI build plan", value));
                Utils.envVariable("bamboo_agentId", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI agent", value));
            }
            if (CiUtils.isGitHubActions(this.providers)) {
                this.buildScan.value("CI provider", "GitHub Actions");
                Optional<String> gitHubUrl = Utils.envVariable("GITHUB_SERVER_URL", this.providers);
                Optional<String> gitRepository = Utils.envVariable("GITHUB_REPOSITORY", this.providers);
                Optional<String> gitHubRunId = Utils.envVariable("GITHUB_RUN_ID", this.providers);
                if (gitHubUrl.isPresent() && gitRepository.isPresent() && gitHubRunId.isPresent()) {
                    this.buildScan.link("GitHub Actions build", gitHubUrl.get() + "/" + gitRepository.get() + "/actions/runs/" + gitHubRunId.get());
                }
                Utils.envVariable("GITHUB_WORKFLOW", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI workflow", value));
                Utils.envVariable("GITHUB_RUN_ID", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI run", value));
                Utils.envVariable("GITHUB_HEAD_REF", this.providers).filter(value -> !value.isEmpty()).ifPresent(value -> this.buildScan.value("PR branch", (String)value));
            }
            if (CiUtils.isGitLab(this.providers)) {
                this.buildScan.value("CI provider", "GitLab");
                Utils.envVariable("CI_JOB_URL", this.providers).ifPresent(url -> this.buildScan.link("GitLab build", (String)url));
                Utils.envVariable("CI_PIPELINE_URL", this.providers).ifPresent(url -> this.buildScan.link("GitLab pipeline", (String)url));
                Utils.envVariable("CI_JOB_NAME", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI job", value));
                Utils.envVariable("CI_JOB_STAGE", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI stage", value));
            }
            if (CiUtils.isTravis(this.providers)) {
                this.buildScan.value("CI provider", "Travis");
                Utils.envVariable("TRAVIS_BUILD_WEB_URL", this.providers).ifPresent(url -> this.buildScan.link("Travis build", (String)url));
                Utils.envVariable("TRAVIS_BUILD_NUMBER", this.providers).ifPresent(value -> this.buildScan.value("CI build number", (String)value));
                Utils.envVariable("TRAVIS_JOB_NAME", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI job", value));
                Utils.envVariable("TRAVIS_EVENT_TYPE", this.providers).ifPresent(this.buildScan::tag);
            }
            if (CiUtils.isBitrise(this.providers)) {
                this.buildScan.value("CI provider", "Bitrise");
                Utils.envVariable("BITRISE_BUILD_URL", this.providers).ifPresent(url -> this.buildScan.link("Bitrise build", (String)url));
                Utils.envVariable("BITRISE_BUILD_NUMBER", this.providers).ifPresent(value -> this.buildScan.value("CI build number", (String)value));
            }
            if (CiUtils.isGoCD(this.providers)) {
                this.buildScan.value("CI provider", "GoCD");
                Optional<String> pipelineName = Utils.envVariable("GO_PIPELINE_NAME", this.providers);
                Optional<String> pipelineNumber = Utils.envVariable("GO_PIPELINE_COUNTER", this.providers);
                Optional<String> stageName = Utils.envVariable("GO_STAGE_NAME", this.providers);
                Optional<String> stageNumber = Utils.envVariable("GO_STAGE_COUNTER", this.providers);
                Optional<String> jobName = Utils.envVariable("GO_JOB_NAME", this.providers);
                Optional<String> goServerUrl = Utils.envVariable("GO_SERVER_URL", this.providers);
                if (Stream.of(pipelineName, pipelineNumber, stageName, stageNumber, jobName, goServerUrl).allMatch(Optional::isPresent)) {
                    buildUrl = String.format("%s/tab/build/detail/%s/%s/%s/%s/%s", goServerUrl.get(), pipelineName.get(), pipelineNumber.get(), stageName.get(), stageNumber.get(), jobName.get());
                    this.buildScan.link("GoCD build", buildUrl);
                } else if (goServerUrl.isPresent()) {
                    this.buildScan.link("GoCD", goServerUrl.get());
                }
                pipelineName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI pipeline", value));
                jobName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI job", value));
                stageName.ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI stage", value));
            }
            if (CiUtils.isAzurePipelines(this.providers)) {
                this.buildScan.value("CI provider", "Azure Pipelines");
                Optional<String> azureServerUrl = Utils.envVariable("SYSTEM_TEAMFOUNDATIONCOLLECTIONURI", this.providers);
                Optional<String> azureProject = Utils.envVariable("SYSTEM_TEAMPROJECT", this.providers);
                Optional<String> buildId = Utils.envVariable("BUILD_BUILDID", this.providers);
                if (Stream.of(azureServerUrl, azureProject, buildId).allMatch(Optional::isPresent)) {
                    String buildUrl3 = String.format("%s%s/_build/results?buildId=%s", azureServerUrl.get(), azureProject.get(), buildId.get());
                    this.buildScan.link("Azure Pipelines build", buildUrl3);
                } else if (azureServerUrl.isPresent()) {
                    this.buildScan.link("Azure Pipelines", azureServerUrl.get());
                }
                buildId.ifPresent(value -> this.buildScan.value("CI build number", (String)value));
            }
            if (CiUtils.isBuildkite(this.providers)) {
                this.buildScan.value("CI provider", "Buildkite");
                Utils.envVariable("BUILDKITE_BUILD_URL", this.providers).ifPresent(s -> this.buildScan.link("Buildkite build", (String)s));
                Utils.envVariable("BUILDKITE_COMMAND", this.providers).ifPresent(value -> CustomBuildScanEnhancements.addCustomValueAndSearchLink(this.develocity, "CI command", value));
                Utils.envVariable("BUILDKITE_BUILD_ID", this.providers).ifPresent(value -> this.buildScan.value("CI build ID", (String)value));
                Optional<String> buildkitePrRepo = Utils.envVariable("BUILDKITE_PULL_REQUEST_REPO", this.providers);
                Optional<String> buildkitePrNumber = Utils.envVariable("BUILDKITE_PULL_REQUEST", this.providers);
                if (buildkitePrRepo.isPresent() && buildkitePrNumber.isPresent()) {
                    String prNumber = buildkitePrNumber.get();
                    Utils.toWebRepoUri(buildkitePrRepo.get()).ifPresent(s -> this.buildScan.link("PR source", s + "/pull/" + prNumber));
                }
            }
        }
    }

    private static final class CaptureIdeMetadataAction
    implements Action<BuildResultAdapter> {
        private final BuildScanAdapter buildScan;
        private final Map<String, Provider<String>> props;

        private CaptureIdeMetadataAction(BuildScanAdapter buildScan, Map<String, Provider<String>> props) {
            this.buildScan = buildScan;
            this.props = props;
        }

        public void execute(BuildResultAdapter buildResult) {
            if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VENDOR_NAME).isPresent()) {
                String ideaVendorNameValue = (String)this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VENDOR_NAME).get();
                if ("Google".equals(ideaVendorNameValue)) {
                    this.tagIde("Android Studio", this.getOrEmpty(this.props.get(CustomBuildScanEnhancements.PROJECT_PROP_ANDROID_STUDIO_VERSION)));
                } else if ("JetBrains".equals(ideaVendorNameValue)) {
                    this.tagIde("IntelliJ IDEA", this.getOrEmpty(this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION)));
                }
            } else if (this.props.get(CustomBuildScanEnhancements.PROJECT_PROP_ANDROID_INVOKED_FROM_IDE).isPresent()) {
                this.tagIde("Android Studio", this.getOrEmpty(this.props.get(CustomBuildScanEnhancements.PROJECT_PROP_ANDROID_STUDIO_VERSION)));
            } else if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).isPresent()) {
                this.tagIde("IntelliJ IDEA", (String)this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_VERSION).get());
            } else if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_ECLIPSE_BUILD_ID).isPresent()) {
                this.tagIde("Eclipse", (String)this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_ECLIPSE_BUILD_ID).get());
            } else {
                this.buildScan.tag("Cmd Line");
            }
            if (this.props.get(CustomBuildScanEnhancements.SYSTEM_PROP_IDEA_SYNC_ACTIVE).isPresent()) {
                this.buildScan.tag("IDE sync");
            }
        }

        private String getOrEmpty(Provider<String> p) {
            if (Utils.isGradle43rNewer()) {
                return (String)p.getOrElse((Object)"");
            }
            String value = (String)p.getOrNull();
            return value != null ? value : "";
        }

        private void tagIde(String ideLabel, String version) {
            this.buildScan.tag(ideLabel);
            if (!version.isEmpty()) {
                this.buildScan.value(ideLabel + " version", version);
            }
        }
    }
}

