/*
 * Decompiled with CFR 0.152.
 */
package com.gpfreetech.aadhaarkyc.util;

import android.content.Context;
import android.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public class SignVerifier {
    public Pair<String, Boolean> verifySignature(byte[] inputData, byte[] signature, PublicKey publicKey, int recur) {
        try {
            Signature publicSignature = Signature.getInstance("SHA256withRSA");
            publicSignature.initVerify(publicKey);
            publicSignature.update(inputData);
            return new Pair((Object)"", (Object)publicSignature.verify(signature));
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (SignatureException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return new Pair((Object)"", (Object)false);
    }

    public PublicKey getPublicKey(String filename, Context context) {
        try {
            InputStream fis = context.getAssets().open(filename);
            CertificateFactory f = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)f.generateCertificate(fis);
            PublicKey pk = certificate.getPublicKey();
            fis.close();
            return pk;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getHexStringFromBytes(byte[] data) {
        char[] hexCharset = "0123456789abcdef".toCharArray();
        char[] hexString = new char[2 * data.length];
        for (int i = 0; i < data.length; ++i) {
            int temp = data[i] & 0xFF;
            hexString[2 * i] = hexCharset[temp >> 4];
            hexString[2 * i + 1] = hexCharset[temp & 0xF];
        }
        return new String(hexString);
    }

    private byte[] getBytefromHex(String hexString) {
        String hexCharset = "0123456789abcdef";
        byte[] data = new byte[hexString.length() / 2];
        for (int i = 0; i < hexString.length(); i += 2) {
            int j = hexCharset.indexOf(hexString.charAt(i));
            int k = hexCharset.indexOf(hexString.charAt(i + 1));
            data[i / 2] = (byte)(j << 4 ^ k);
        }
        return data;
    }

    private String getSHARec(String input, int recur) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (int i = 0; i < recur; ++i) {
                input = SignVerifier.getHexStringFromBytes(md.digest(input.getBytes()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return input;
    }

    private byte[] getSHA(byte[] input, int recur) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (int i = 0; i <= recur; ++i) {
                input = md.digest(input);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        return input;
    }
}

