/*
 *     Apache License
 *                            Version 2.0, January 2004
 *                         http://www.apache.org/licenses/
 *
 *    TERMS AND CONDITIONS FOR USE, REPRODUCTION, AND DISTRIBUTION
 *
 *    1. Definitions.
 *
 *       "License" shall mean the terms and conditions for use, reproduction,
 *       and distribution as defined by Sections 1 through 9 of this document.
 *
 *       "Licensor" shall mean the copyright owner or entity authorized by
 *       the copyright owner that is granting the License.
 *
 *       "Legal Entity" shall mean the union of the acting entity and all
 *       other entities that control, are controlled by, or are under common
 *       control with that entity. For the purposes of this definition,
 *       "control" means (i) the power, direct or indirect, to cause the
 *       direction or management of such entity, whether by contract or
 *       otherwise, or (ii) ownership of fifty percent (50%) or more of the
 *       outstanding shares, or (iii) beneficial ownership of such entity.
 *
 *       "You" (or "Your") shall mean an individual or Legal Entity
 *       exercising permissions granted by this License.
 *
 *       "Source" form shall mean the preferred form for making modifications,
 *       including but not limited to software source code, documentation
 *       source, and configuration files.
 *
 *       "Object" form shall mean any form resulting from mechanical
 *       transformation or translation of a Source form, including but
 *       not limited to compiled object code, generated documentation,
 *       and conversions to other media types.
 *
 *       "Work" shall mean the work of authorship, whether in Source or
 *       Object form, made available under the License, as indicated by a
 *       copyright notice that is included in or attached to the work
 *       (an example is provided in the Appendix below).
 *
 *       "Derivative Works" shall mean any work, whether in Source or Object
 *       form, that is based on (or derived from) the Work and for which the
 *       editorial revisions, annotations, elaborations, or other modifications
 *       represent, as a whole, an original work of authorship. For the purposes
 *       of this License, Derivative Works shall not include works that remain
 *       separable from, or merely link (or bind by name) to the interfaces of,
 *       the Work and Derivative Works thereof.
 *
 *       "Contribution" shall mean any work of authorship, including
 *       the original version of the Work and any modifications or additions
 *       to that Work or Derivative Works thereof, that is intentionally
 *       submitted to Licensor for inclusion in the Work by the copyright owner
 *       or by an individual or Legal Entity authorized to submit on behalf of
 *       the copyright owner. For the purposes of this definition, "submitted"
 *       means any form of electronic, verbal, or written communication sent
 *       to the Licensor or its representatives, including but not limited to
 *       communication on electronic mailing lists, source code control systems,
 *       and issue tracking systems that are managed by, or on behalf of, the
 *       Licensor for the purpose of discussing and improving the Work, but
 *       excluding communication that is conspicuously marked or otherwise
 *       designated in writing by the copyright owner as "Not a Contribution."
 *
 *       "Contributor" shall mean Licensor and any individual or Legal Entity
 *       on behalf of whom a Contribution has been received by Licensor and
 *       subsequently incorporated within the Work.
 *
 *    2. Grant of Copyright License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       copyright license to reproduce, prepare Derivative Works of,
 *       publicly display, publicly perform, sublicense, and distribute the
 *       Work and such Derivative Works in Source or Object form.
 *
 *    3. Grant of Patent License. Subject to the terms and conditions of
 *       this License, each Contributor hereby grants to You a perpetual,
 *       worldwide, non-exclusive, no-charge, royalty-free, irrevocable
 *       (except as stated in this section) patent license to make, have made,
 *       use, offer to sell, sell, import, and otherwise transfer the Work,
 *       where such license applies only to those patent claims licensable
 *       by such Contributor that are necessarily infringed by their
 *       Contribution(s) alone or by combination of their Contribution(s)
 *       with the Work to which such Contribution(s) was submitted. If You
 *       institute patent litigation against any entity (including a
 *       cross-claim or counterclaim in a lawsuit) alleging that the Work
 *       or a Contribution incorporated within the Work constitutes direct
 *       or contributory patent infringement, then any patent licenses
 *       granted to You under this License for that Work shall terminate
 *       as of the date such litigation is filed.
 *
 *    4. Redistribution. You may reproduce and distribute copies of the
 *       Work or Derivative Works thereof in any medium, with or without
 *       modifications, and in Source or Object form, provided that You
 *       meet the following conditions:
 *
 *       (a) You must give any other recipients of the Work or
 *           Derivative Works a copy of this License; and
 *
 *       (b) You must cause any modified files to carry prominent notices
 *           stating that You changed the files; and
 *
 *       (c) You must retain, in the Source form of any Derivative Works
 *           that You distribute, all copyright, patent, trademark, and
 *           attribution notices from the Source form of the Work,
 *           excluding those notices that do not pertain to any part of
 *           the Derivative Works; and
 *
 *       (d) If the Work includes a "NOTICE" text file as part of its
 *           distribution, then any Derivative Works that You distribute must
 *           include a readable copy of the attribution notices contained
 *           within such NOTICE file, excluding those notices that do not
 *           pertain to any part of the Derivative Works, in at least one
 *           of the following places: within a NOTICE text file distributed
 *           as part of the Derivative Works; within the Source form or
 *           documentation, if provided along with the Derivative Works; or,
 *           within a display generated by the Derivative Works, if and
 *           wherever such third-party notices normally appear. The contents
 *           of the NOTICE file are for informational purposes only and
 *           do not modify the License. You may add Your own attribution
 *           notices within Derivative Works that You distribute, alongside
 *           or as an addendum to the NOTICE text from the Work, provided
 *           that such additional attribution notices cannot be construed
 *           as modifying the License.
 *
 *       You may add Your own copyright statement to Your modifications and
 *       may provide additional or different license terms and conditions
 *       for use, reproduction, or distribution of Your modifications, or
 *       for any such Derivative Works as a whole, provided Your use,
 *       reproduction, and distribution of the Work otherwise complies with
 *       the conditions stated in this License.
 *
 *    5. Submission of Contributions. Unless You explicitly state otherwise,
 *       any Contribution intentionally submitted for inclusion in the Work
 *       by You to the Licensor shall be under the terms and conditions of
 *       this License, without any additional terms or conditions.
 *       Notwithstanding the above, nothing herein shall supersede or modify
 *       the terms of any separate license agreement you may have executed
 *       with Licensor regarding such Contributions.
 *
 *    6. Trademarks. This License does not grant permission to use the trade
 *       names, trademarks, service marks, or product names of the Licensor,
 *       except as required for reasonable and customary use in describing the
 *       origin of the Work and reproducing the content of the NOTICE file.
 *
 *    7. Disclaimer of Warranty. Unless required by applicable law or
 *       agreed to in writing, Licensor provides the Work (and each
 *       Contributor provides its Contributions) on an "AS IS" BASIS,
 *       WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
 *       implied, including, without limitation, any warranties or conditions
 *       of TITLE, NON-INFRINGEMENT, MERCHANTABILITY, or FITNESS FOR A
 *       PARTICULAR PURPOSE. You are solely responsible for determining the
 *       appropriateness of using or redistributing the Work and assume any
 *       risks associated with Your exercise of permissions under this License.
 *
 *    8. Limitation of Liability. In no event and under no legal theory,
 *       whether in tort (including negligence), contract, or otherwise,
 *       unless required by applicable law (such as deliberate and grossly
 *       negligent acts) or agreed to in writing, shall any Contributor be
 *       liable to You for damages, including any direct, indirect, special,
 *       incidental, or consequential damages of any character arising as a
 *       result of this License or out of the use or inability to use the
 *       Work (including but not limited to damages for loss of goodwill,
 *       work stoppage, computer failure or malfunction, or any and all
 *       other commercial damages or losses), even if such Contributor
 *       has been advised of the possibility of such damages.
 *
 *    9. Accepting Warranty or Additional Liability. While redistributing
 *       the Work or Derivative Works thereof, You may choose to offer,
 *       and charge a fee for, acceptance of support, warranty, indemnity,
 *       or other liability obligations and/or rights consistent with this
 *       License. However, in accepting such obligations, You may act only
 *       on Your own behalf and on Your sole responsibility, not on behalf
 *       of any other Contributor, and only if You agree to indemnify,
 *       defend, and hold each Contributor harmless for any liability
 *       incurred by, or claims asserted against, such Contributor by reason
 *       of your accepting any such warranty or additional liability.
 *
 *    END OF TERMS AND CONDITIONS
 *
 *    APPENDIX: How to apply the Apache License to your work.
 *
 *       To apply the Apache License to your work, attach the following
 *       boilerplate notice, with the fields enclosed by brackets "[]"
 *       replaced with your own identifying information. (Don't include
 *       the brackets!)  The text should be enclosed in the appropriate
 *       comment syntax for the file format. We also recommend that a
 *       file or class name and description of purpose be included on the
 *       same "printed page" as the copyright notice for easier
 *       identification within third-party archives.
 *
 *    Copyright [2019] [govinda p]
 *
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

package com.gpfreetech.aadhaarkyc;

import android.content.Context;
import android.content.DialogInterface;
import android.graphics.Bitmap;
import android.os.AsyncTask;
import android.util.Base64;
import android.util.Log;
import android.util.Pair;
import android.util.Xml;

import androidx.appcompat.app.AlertDialog;

import com.gemalto.jp2.JP2Decoder;
import com.gpfreetech.aadhaarkyc.entity.AadhaarUser;
import com.gpfreetech.aadhaarkyc.util.SignVerifier;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;
import org.xmlpull.v1.XmlSerializer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.util.zip.GZIPInputStream;

import static com.gpfreetech.aadhaarkyc.util.SignVerifier.getHexStringFromBytes;

public class AadhaarParser {
    public static final String IS_XML = "is_xml";
    private boolean isXML;
    private final Charset CHARSET = Charset.forName("ISO-8859-1");
    private boolean isVerified;
    private String sha256;
    private String address[] = new String[11];
    private boolean isDataValid = true;
    public static Context mContext = null;
    private AadhaarUser aadhaarUser = new AadhaarUser();

    public OnAadhaarResponse onAadhaarResponse = null;
    //String[] SECURE_KEY = new String[]{};

    public static AadhaarParser getInstance(Context context) {
        if (mContext == null) {
            mContext = context;
        }
        return new AadhaarParser();
    }

    public AadhaarParser() {
    }

    private void showAlertDialog(String alertMessage) {
        new AlertDialog.Builder(mContext)
                .setTitle(mContext.getResources().getString(R.string.app_name))
                .setCancelable(false)
                .setMessage(alertMessage + mContext.getString(R.string.readingErrorMessage))
                .setPositiveButton("OK", new DialogInterface.OnClickListener() {
                    public void onClick(DialogInterface dialog, int which) {

                    }
                })
                .show();
    }

    private byte[] decompress(byte[] data) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(data);
            GZIPInputStream gis = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            int len;
            while ((len = gis.read(buffer)) != -1) {
                os.write(buffer, 0, len);
            }
            os.close();
            gis.close();
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return os.toByteArray();
    }


    private void showScannedResult(byte[] uidData, boolean isXML) {

        this.isXML = isXML;
        byte[] uidBytes = uidData;
        if (isXML) {
            parseXMLToObject(uidBytes);
        } else {
            loadDataToObject(uidBytes);
        }
        if (!isVerified) {
            verifySignature(uidBytes);
        }
    }

    public void parse(String response, OnAadhaarResponse onAadhaarResponse) {
        this.onAadhaarResponse = onAadhaarResponse;
        Log.e("parse string", ": " + response);
        isDataValid = true;
        boolean isXML = false;
        byte[] message = response.getBytes();

        String res = new String(message, Charset.forName("UTF-8"));
        String xmlHeader = res.substring(0, 4);
        Log.e("parse", "onPreviewFrame: res " + res);
        Log.e("parse", "onPreviewFrame: xmlHeader " + xmlHeader);

        byte[] uiData = null;
        if (xmlHeader.equals("<QPD") || xmlHeader.equals("<QDB")) {
            uiData = message;
            isXML = true;
        } else if (xmlHeader.equals("<?xm") && response.contains("PrintLetterBarcodeData")) {
            uiData = message;
            isXML = true;
            isVerified = false;
        } else {
            try {
                uiData = new BigInteger(res).toByteArray();
                String data_ = new BigInteger(res).toString();
                Log.d("DATA", data_ + " " + data_.length());
                Log.d("Size", uiData.length + " " + res.length());
                uiData = decompress(uiData);
                //showAlertDialog(new BigInteger(res).toString());
                if (uiData == null) {
                    isDataValid = false;
                }
            } catch (NumberFormatException e) {

                isDataValid = false;
            }
        }
        if (isDataValid) {
            showScannedResult(uiData, isXML);
        }
    }

    private void parseXMLToObject(byte[] uidBytes) {
        XmlPullParserFactory parserFactory;
        try {
            parserFactory = XmlPullParserFactory.newInstance();
            XmlPullParser parser = parserFactory.newPullParser();
            InputStream is = new ByteArrayInputStream(uidBytes);
            parser.setFeature(XmlPullParser.FEATURE_PROCESS_NAMESPACES, false);
            parser.setInput(is, null);

            int eventType = parser.getEventType();
            //Log.e("Gpfreetech", "parseXMLToObject: " + parser.toString());
            while (eventType != XmlPullParser.END_DOCUMENT) {
                String eltName = null;

                switch (eventType) {
                    case XmlPullParser.START_TAG:
                        eltName = parser.getName();
                        if ("QPDB".equals(eltName) || "QDB".equals(eltName)) {
                            aadhaarUser.setName(parser.getAttributeValue(null, "n"));
                            aadhaarUser.setUid(parser.getAttributeValue(null, "u"));
                            aadhaarUser.setGender(parser.getAttributeValue(null, "g"));
                            aadhaarUser.setDob(parser.getAttributeValue(null, "d"));
                            aadhaarUser.setAddress(parser.getAttributeValue(null, "a"));
                            aadhaarUser.setDigSign(parser.getAttributeValue(null, "s"));
                            aadhaarUser.setMobile(parser.getAttributeValue(null, "m"));
                            if ("QPDB".equals(eltName)) {
                                aadhaarUser.setImage(parser.getAttributeValue(null, "i"));
                                try {
                                    byte[] imageBytes = Base64.decode(aadhaarUser.getImage(), Base64.DEFAULT);
                                    Bitmap bmp = new JP2Decoder(imageBytes).decode();
                                    aadhaarUser.setImageBitmap(bmp);
                                } catch (Exception e) {
                                    e.printStackTrace();
                                }
                                // clear image after generating bitmap
                                aadhaarUser.setImage("");
                            }
                        } else if ("PrintLetterBarcodeData".equals(eltName)) {

                            aadhaarUser.setName(parser.getAttributeValue(null, "name"));
                            aadhaarUser.setUid(parser.getAttributeValue(null, "uid"));
                            aadhaarUser.setGender(parser.getAttributeValue(null, "gender"));
                            aadhaarUser.setDob(parser.getAttributeValue(null, "yob"));
                            //parser.getAttributeValue(null, "a")
                            StringBuilder sb = new StringBuilder();
                            sb.append(parser.getAttributeValue(null, "house") + ",");
                            sb.append(parser.getAttributeValue(null, "street") + ",");
                            sb.append(parser.getAttributeValue(null, "loc") + ",");
                            sb.append(parser.getAttributeValue(null, "vtc") + ",");
                            sb.append(parser.getAttributeValue(null, "subdist") + ",");
                            sb.append(parser.getAttributeValue(null, "dist") + ",");
                            sb.append(parser.getAttributeValue(null, "state") + ",");
                            sb.append(parser.getAttributeValue(null, "pc") + ",");
                            String address = sb.toString();
                            aadhaarUser.setAddress(address);
                            aadhaarUser.setDigSign(null);
                            aadhaarUser.setMobile(null);
                            aadhaarUser.setImage(null);
                        }
                        break;
                }
                eventType = parser.next();
            }
        } catch (XmlPullParserException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadDataToObject(byte[] uidBytes) {
        int end = uidBytes.length - 1;
        aadhaarUser.setDigSign(Base64.encodeToString(getDataReverse(uidBytes, end, 256), Base64.DEFAULT));
        end -= 256;

        Pair<Integer, String> temp = getData(uidBytes, 2);
        aadhaarUser.setUid(temp.second);

        temp = getData(uidBytes, temp.first);
        aadhaarUser.setName(temp.second);

        temp = getData(uidBytes, temp.first);
        aadhaarUser.setDob(temp.second);

        temp = getData(uidBytes, temp.first);
        aadhaarUser.setGender(temp.second);

        temp = getData(uidBytes, temp.first);
        address[0] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[1] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[2] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[3] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[4] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[5] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[6] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[7] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[8] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[9] = temp.second;

        temp = getData(uidBytes, temp.first);
        address[10] = temp.second;

//        StringBuilder str=new StringBuilder();
//
//        for(String part:address) {
//            str.append(part+" ");
//        }
        String add = address[0] + " " + address[3] + " " + address[8] + " " + address[4] + " " + address[2] + " " + address[10] + " " + address[6] + " " + address[9] + " " + address[1] + " " +
                address[7] + "-" + address[5] + " ";

        aadhaarUser.setAddress(add);

        byte flag = uidBytes[0];

        switch (new String(new byte[]{flag}, CHARSET).charAt(0)) {
            case '0':
                break;
            case '1':
                aadhaarUser.setEmail(getHexStringFromBytes(getDataReverse(uidBytes, end, 32)));
                end -= 32;
                break;
            case '2':
                aadhaarUser.setMobile(getHexStringFromBytes(getDataReverse(uidBytes, end, 32)));
                end -= 32;
                break;
            case '3':
                aadhaarUser.setMobile(getHexStringFromBytes(getDataReverse(uidBytes, end, 32)));
                end -= 32;
                aadhaarUser.setEmail(getHexStringFromBytes(getDataReverse(uidBytes, end, 32)));
                end -= 32;
                break;
        }
        aadhaarUser.setImage(Base64.encodeToString(getDataReverse(uidBytes, end, end - temp.first + 1), Base64.DEFAULT));
        try {
            byte[] imageBytes = Base64.decode(aadhaarUser.getImage(), Base64.DEFAULT);
            Bitmap bmp = new JP2Decoder(imageBytes).decode();
            aadhaarUser.setImageBitmap(bmp);
        } catch (Exception e) {
            e.printStackTrace();
        }
        // clear image after generating bitmap
        aadhaarUser.setImage("");
    }

    private void verifySignature(byte[] uidData) {
        if (aadhaarUser.getDigSign() != null) {
            // send for Digi sign checking
            byte[] sign = Base64.decode(aadhaarUser.getDigSign(), Base64.DEFAULT);
            new VerifyAsyncTask().execute(uidData, sign);
        } else {
            //return very old aadhaar response which is invalid
            onAadhaarResponse.onAadhaarResponse(aadhaarUser);
        }
    }

    private String getXmlOutput(String[] address, AadhaarUser aadhaarUser) {
        StringWriter stringWriter = new StringWriter();
        XmlSerializer serializer = Xml.newSerializer();
        try {
            serializer.setOutput(stringWriter);
            serializer.startDocument("UTF-8", true);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);

            serializer.startTag("", "OfflinePaperlessKyc");
            serializer.attribute("", "referenceId", aadhaarUser.getUid());

            serializer.startTag("", "UidData");

            serializer.startTag("", "Poi");
            serializer.attribute("", "dob", aadhaarUser.getDob());
            serializer.attribute("", "e", aadhaarUser.getEmail());
            serializer.attribute("", "gender", aadhaarUser.getGender());
            serializer.attribute("", "m", aadhaarUser.getMobile());
            serializer.attribute("", "name", aadhaarUser.getName());
            serializer.endTag("", "Poi");

            serializer.startTag("", "Poa");
            serializer.attribute("", "country", "India");
            serializer.attribute("", "dist", address[1]);
            serializer.attribute("", "house", address[3]);
            serializer.attribute("", "loc", address[4]);
            serializer.attribute("", "pc", address[5]);
            serializer.attribute("", "po", address[6]);
            serializer.attribute("", "state", address[7]);
            serializer.attribute("", "street", address[8]);
            serializer.attribute("", "subdist", address[9]);
            serializer.attribute("", "vtc", address[10]);
            serializer.endTag("", "Poa");

            serializer.startTag("", "Pht");
            serializer.text(aadhaarUser.getImage());
            serializer.endTag("", "Pht");
            serializer.endTag("", "UidData");

            serializer.startTag("", "Signature");
            serializer.startTag("", "SignedInfo");
            serializer.startTag("", "CanonicalizationMethod");
            serializer.attribute("", "Algorithm", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
            serializer.endTag("", "CanonicalizationMethod");
            serializer.startTag("", "SignatureMethod");
            serializer.attribute("", "Algorithm", "http://www.w3.org/2000/09/xmldsig#rsa-sha1");
            serializer.endTag("", "SignatureMethod");
            serializer.startTag("", "Reference");
            serializer.attribute("", "URI", "");
            serializer.startTag("", "Transforms");
            serializer.startTag("", "Transform");
            serializer.attribute("", "Algorithm", "http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            serializer.endTag("", "Transform");
            serializer.endTag("", "Transforms");
            serializer.startTag("", "DigestMethod");
            serializer.attribute("", "Algorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
            serializer.endTag("", "DigestMethod");
            serializer.startTag("", "DigestValue");
            serializer.text(sha256);
            serializer.endTag("", "DigestValue");
            serializer.endTag("", "Reference");
            serializer.endTag("", "SignedInfo");
            serializer.startTag("", "SignatureValue");
            serializer.text(aadhaarUser.getDigSign());
            serializer.endTag("", "SignatureValue");
            serializer.endTag("", "Signature");
            serializer.endTag("", "OfflinePaperlessKyc");
            serializer.endDocument();
            stringWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return stringWriter.toString();

    }

    private Pair<Integer, String> getData(byte[] uidBytes, int start) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int i = start;
        while (uidBytes[i] != -1) {
            out.write(uidBytes[i++]);
        }
        try {
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return new Pair<>(i + 1, new String(out.toByteArray(), CHARSET));
    }

    private byte[] getDataReverse(byte[] uidBytes, int end, int length) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        int offSet = end - length + 1;
        try {
            out.write(uidBytes, offSet, length);
            out.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return out.toByteArray();
    }

    class VerifyAsyncTask extends AsyncTask<byte[], Void, Pair<String, Boolean>> {
        @Override
        protected Pair<String, Boolean> doInBackground(byte[]... uidDataBytes) {
            /*
            Now validate (signature value and signed data value) by using public key
with algorithm SHA256withRSA.

Read the entire XML.

2. Get signature from xml

3. Get Certificate from here.

4. If you have downloaded Offline XML before 18 Jun 2019. then get Certificate from here

5. If you have downloaded the client before 28 March, then get Certificate from here.

6. Convert certificate to base64 string.
             */
            byte[] uidData = uidDataBytes[0];
            byte[] sign = uidDataBytes[1];
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                out.write(uidData, 0, uidData.length - 256);
                byte[] rawData = out.toByteArray();
                out.close();
                SignVerifier signVerifier = new SignVerifier();
                String[] SECURE_KEY = new String[]{"uidai_offline_publickey_29032019.cer","auth_hsm.cer","uidai.cer", "uidai_auth_prod.cer", "okyc-publickey.cer", "uidai_offline_publickey_19062019.cer", "uidai_prod_cdup.cer"};
                Pair<String, Boolean> ret = null;
                for (String str :
                        SECURE_KEY) {
                    try {
                        PublicKey publicKey = signVerifier.getPublicKey(str, mContext);
                        if (publicKey != null) {
                            ret = signVerifier.verifySignature(rawData, sign, publicKey, aadhaarUser.getUid().charAt(3) - '0');
                            if (ret.second == true) {
                                Log.e("DigiSign", "true");
                                return ret;
                            } else {
                                Log.e("DigiSign", "false");
                            }
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return ret;

            } catch (IOException e) {
                e.printStackTrace();
            }
            return new Pair<>("", false);
        }

        @Override
        protected void onPreExecute() {
            super.onPreExecute();
        }

        @Override
        protected void onPostExecute(Pair<String, Boolean> isVerified) {
            super.onPostExecute(isVerified);
            Log.e("verify", " " + isVerified.second);
            AadhaarParser.this.isVerified = isVerified.second;
            AadhaarParser.this.sha256 = isVerified.first;
            aadhaarUser.setVerified(isVerified.second);
            String xmlContent = "";
            if (!isXML) {
                xmlContent = getXmlOutput(address, aadhaarUser);
            }

            onAadhaarResponse.onAadhaarResponse(aadhaarUser);
        }
    }

    public boolean verifyUserDetail(String uid, String input, String key_of_input) {

        String digit = "";
        try {

            if (uid.toLowerCase().contains("xxx")) {
                digit = "" + uid.charAt(uid.length() - 1);
                Log.e("last char X", "" + digit);
            } else {
                String substring = uid.substring(0, 4);
                digit = "" + substring.charAt(3);
                Log.e("last char", "" + digit);
            }
            String generatedString = checkMobileAndEmail(input, digit);
            if (key_of_input.equals(generatedString)) {
                return true;
            } else {
                return false;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private String checkMobileAndEmail(String str, String last_no) {
        int parseInt = Integer.parseInt(last_no);
        //int parseInt = last_no;
        if (!(parseInt == 0 || parseInt == 1)) {
            int i = parseInt - 1;
            for (int i2 = 0; i2 < i; i2++) {
                str = stringToHex(str);
            }
        }
        byte[] response = m6151c(str);
        Log.e("checkMobileAndEmail", " " + getHexStringFromBytes(response));
        return getHexStringFromBytes(response);
    }

    private String stringToHex(String str) {
        try {
            byte[] digest = MessageDigest.getInstance("SHA-256").digest(str.getBytes("UTF-8"));
            StringBuffer stringBuffer = new StringBuffer();
            for (byte b : digest) {
                String hexString = Integer.toHexString(b & 255);
                if (hexString.length() == 1) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(hexString);
            }
            return stringBuffer.toString();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private byte[] m6151c(String str) {
        try {
            return MessageDigest.getInstance("SHA-256").digest(str.getBytes("UTF-8"));
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

